/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeonsengine.builder;

import com.someguyssoftware.dungeonsengine.builder.GenUtil;
import com.someguyssoftware.dungeonsengine.builder.IRoomBuilder;
import com.someguyssoftware.dungeonsengine.config.ILevelConfig;
import com.someguyssoftware.dungeonsengine.enums.RoomTag;
import com.someguyssoftware.dungeonsengine.model.Boundary;
import com.someguyssoftware.dungeonsengine.model.IRoom;
import com.someguyssoftware.dungeonsengine.model.Room;
import com.someguyssoftware.gottschcore.enums.Direction;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import java.util.List;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RoomBuilder
implements IRoomBuilder {
    public static Logger logger = LogManager.getLogger((String)"DungeonsEngine");
    public static final IRoom EMPTY_ROOM = new Room();
    public static final ICoords EMPTY_COORDS = new Coords(0, 0, 0);
    private ILevelConfig config;
    private Random random;
    private Boundary boundary;

    public RoomBuilder(Random random, Boundary boundary, ILevelConfig config) {
        this.random = random;
        this.config = config;
        this.boundary = config.getSpawnBoundaryFactor() < 1.0 ? boundary.shrink(config.getSpawnBoundaryFactor()) : boundary;
    }

    public IRoom randomizeDimensions(IRoom spaceIn) {
        IRoom space = spaceIn.copy();
        space.setWidth(Math.max(5, RandomHelper.randomInt((Random)this.random, (int)this.config.getWidth().getMinInt(), (int)this.config.getWidth().getMaxInt())));
        space.setDepth(Math.max(5, RandomHelper.randomInt((Random)this.random, (int)this.config.getDepth().getMinInt(), (int)this.config.getDepth().getMaxInt())));
        space.setHeight(Math.max(4, RandomHelper.randomInt((Random)this.random, (int)this.config.getHeight().getMinInt(), (int)this.config.getHeight().getMaxInt())));
        return space;
    }

    public IRoom randomizeCoords(IRoom roomIn) {
        IRoom room = roomIn.copy();
        ICoords c = GenUtil.randomizeCoords(this.random, this.boundary);
        if (c == EMPTY_COORDS) {
            return EMPTY_ROOM;
        }
        room.setCoords(c.add(-(room.getWidth() / 2), 0, -(room.getDepth() / 2)));
        return room;
    }

    @Override
    public IRoom buildRoom(ICoords startPoint, IRoom roomIn) {
        IRoom room = this.randomizeDimensions(roomIn);
        if (room == EMPTY_ROOM) {
            return room;
        }
        if ((room = this.randomizeCoords(room)) == EMPTY_ROOM) {
            return room;
        }
        room.setDegrees(RandomHelper.randomInt((Random)this.random, (int)this.config.getDegrees().getMinInt(), (int)this.config.getDegrees().getMaxInt()));
        room.setDirection(Direction.getByCode((Integer)RandomHelper.randomInt((int)2, (int)5)));
        return room;
    }

    @Override
    public IRoom buildStartRoom(ICoords startPoint) {
        IRoom start = new Room().setStart(true).setAnchor(true);
        start = this.randomizeDimensions(start);
        start.setWidth(Math.max(7, start.getWidth()));
        start.setDepth(Math.max(7, start.getDepth()));
        if (start.getWidth() % 2 == 0) {
            start.setWidth(start.getWidth() + 1);
        }
        if (start.getDepth() % 2 == 0) {
            start.setDepth(start.getDepth() + 1);
        }
        start.centerOn(startPoint);
        start.setDirection(Direction.getByCode((Integer)RandomHelper.randomInt((int)2, (int)5)));
        return start;
    }

    @Override
    public IRoom buildEndRoom(ICoords startPoint, List<IRoom> predefinedSpaces) {
        IRoom end = this.buildPlannedRoom(startPoint, predefinedSpaces).setEnd(true).setAnchor(true);
        end.setWidth(Math.max(7, end.getWidth()));
        end.setDepth(Math.max(7, end.getDepth()));
        if (end.getWidth() % 2 == 0) {
            end.setWidth(end.getWidth() + 1);
        }
        if (end.getDepth() % 2 == 0) {
            end.setDepth(end.getDepth() + 1);
        }
        return end;
    }

    @Override
    public IRoom buildTreasureRoom(ICoords startPoint, List<IRoom> predefinedSpaces) {
        int SPACE_MIN_XZ = 10;
        int SPACE_MIN_Y = 10;
        IRoom space = this.buildEndRoom(startPoint, predefinedSpaces).setDegrees(1);
        space.getTags().add(RoomTag.TREASURE);
        space.setWidth(Math.max(10, space.getWidth()));
        space.setDepth(Math.max(10, space.getDepth()));
        space.setHeight(Math.max(Math.min(10, this.config.getHeight().getMaxInt()), space.getHeight()));
        return space;
    }

    @Override
    public IRoom buildPlannedRoom(ICoords startPoint, List<IRoom> predefinedSpaces) {
        IRoom predefinedSpace = new Room();
        boolean checkSpaces = true;
        int endCheckIndex = 0;
        block0: do {
            if ((predefinedSpace = this.buildRoom(startPoint, predefinedSpace)) == EMPTY_ROOM) {
                return predefinedSpace;
            }
            logger.debug("New Planned Space:" + predefinedSpace);
            if (++endCheckIndex > 10) {
                logger.warn("Unable to position Planned Space that meets positional criteria.");
                return EMPTY_ROOM;
            }
            for (IRoom space : predefinedSpaces) {
                if (!space.getXZBoundingBox().intersects(predefinedSpace.getXZBoundingBox())) continue;
                logger.debug("New Planned room intersects with predefined list room.");
                continue block0;
            }
            checkSpaces = false;
        } while (checkSpaces);
        return predefinedSpace;
    }

    @Override
    public Boundary getBoundary() {
        return this.boundary;
    }

    @Override
    public void setBoundary(Boundary field) {
        this.boundary = field;
    }

    protected ILevelConfig getConfig() {
        return this.config;
    }

    protected Random getRandom() {
        return this.random;
    }
}

