/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeonsengine.config;

import com.someguyssoftware.dungeons2.Dungeons2;
import com.someguyssoftware.dungeonsengine.config.ChestConfig;
import com.someguyssoftware.dungeonsengine.config.IChestConfig;
import com.someguyssoftware.dungeonsengine.config.ILevelConfig;
import com.someguyssoftware.gottschcore.Quantity;
import java.util.List;

public class LevelConfig
implements ILevelConfig {
    private Double boundaryFactor;
    private Double spawnBoundaryFactor;
    private Quantity numRooms;
    private Quantity width;
    private Quantity depth;
    private Quantity height;
    private Quantity degrees;
    private Integer decayMultiplier;
    private Quantity spawnerFrequency;
    private IChestConfig chestConfig;
    private Quantity chestFrequency;
    private List<String> chestCategories;
    private Quantity numberOfWebs;
    private Quantity webFrequency;
    private Quantity numberOfVines;
    private Quantity vineFrequency;
    private String theme;
    private Boolean support;
    private Boolean decorations;

    public LevelConfig() {
    }

    public LevelConfig(LevelConfig c) {
        this.setChestConfig(new ChestConfig(c.getChestConfig()));
        this.setChestCategories(c.getChestCategories());
        this.setChestFrequency(c.getChestFrequency());
        this.setDecayMultiplier(c.getDecayMultiplier());
        this.setDegrees(c.getDegrees());
        this.setDepth(c.getDepth());
        this.setBoundaryFactor(c.getBoundaryFactor());
        this.setHeight(c.getHeight());
        this.setNumRooms(c.getNumRooms());
        this.setSpawnerFrequency(c.getSpawnerFrequency());
        this.setSupport(c.isSupport());
        this.setWidth(c.getWidth());
        this.setNumberOfVines(c.getNumberOfVines());
        this.setVineFrequency(c.getVineFrequency());
        this.setNumberOfWebs(c.getNumberOfWebs());
        this.setWebFrequency(c.getWebFrequency());
        this.setTheme(c.getTheme());
        this.setSupport(c.isSupport());
        this.setDecorations(c.isDecorations());
    }

    @Override
    public ILevelConfig copy() {
        return new LevelConfig(this);
    }

    @Override
    public ILevelConfig apply(ILevelConfig config) {
        if (config == null) {
            Dungeons2.log.debug("apply configIn is null.");
            return this;
        }
        if (this.getBoundaryFactor() == null) {
            this.setBoundaryFactor(config.getBoundaryFactor());
        }
        if (this.getChestConfig() == null) {
            this.setChestConfig(new ChestConfig(config.getChestConfig()));
        } else {
            this.getChestConfig().apply(config.getChestConfig());
        }
        if (this.getChestCategories() == null || this.getChestCategories().equals("")) {
            this.setChestCategories(config.getChestCategories());
        }
        if (this.getChestFrequency() == null) {
            this.setChestFrequency(config.getChestFrequency());
        }
        if (this.getDecayMultiplier() == null) {
            this.setDecayMultiplier(config.getDecayMultiplier());
        }
        if (this.isDecorations() == null) {
            this.setDecorations(config.isDecorations());
        }
        if (this.getDegrees() == null) {
            this.setDegrees(config.getDegrees());
        }
        if (this.getDepth() == null) {
            this.setDepth(config.getDepth());
        }
        if (this.getHeight() == null) {
            this.setHeight(config.getHeight());
        }
        if (this.getNumberOfVines() == null) {
            this.setNumberOfVines(config.getNumberOfVines());
        }
        if (this.getNumberOfWebs() == null) {
            this.setNumberOfWebs(config.getNumberOfWebs());
        }
        if (this.getNumRooms() == null) {
            this.setNumRooms(config.getNumRooms());
        }
        if (this.getSpawnBoundaryFactor() == null) {
            this.setSpawnBoundaryFactor(config.getSpawnBoundaryFactor());
        }
        if (this.getSpawnerFrequency() == null) {
            this.setSpawnerFrequency(config.getSpawnerFrequency());
        }
        if (this.isSupport() == null) {
            this.setSupport(config.isSupport());
        }
        if (this.getTheme() == null || this.getTheme().equals("")) {
            this.setTheme(config.getTheme());
        }
        if (this.getVineFrequency() == null) {
            this.setVineFrequency(config.getVineFrequency());
        }
        if (this.getWebFrequency() == null) {
            this.setWebFrequency(config.getWebFrequency());
        }
        if (this.getWidth() == null) {
            this.setWidth(config.getWidth());
        }
        return this;
    }

    @Override
    public Boolean isSupport() {
        return this.support;
    }

    @Override
    public void setSupport(Boolean support) {
        this.support = support;
    }

    @Override
    public Double getBoundaryFactor() {
        return this.boundaryFactor;
    }

    @Override
    public void setBoundaryFactor(Double fieldFactor) {
        this.boundaryFactor = fieldFactor;
    }

    @Override
    public Quantity getNumRooms() {
        return this.numRooms;
    }

    @Override
    public void setNumRooms(Quantity numRooms) {
        this.numRooms = numRooms;
    }

    @Override
    public Quantity getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(Quantity width) {
        this.width = width;
    }

    @Override
    public Quantity getDepth() {
        return this.depth;
    }

    @Override
    public void setDepth(Quantity depth) {
        this.depth = depth;
    }

    @Override
    public Quantity getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(Quantity height) {
        this.height = height;
    }

    @Override
    public Quantity getDegrees() {
        return this.degrees;
    }

    @Override
    public void setDegrees(Quantity degrees) {
        this.degrees = degrees;
    }

    @Override
    public Integer getDecayMultiplier() {
        return this.decayMultiplier;
    }

    @Override
    public void setDecayMultiplier(Integer decayMultiplier) {
        this.decayMultiplier = decayMultiplier;
    }

    @Override
    public Quantity getSpawnerFrequency() {
        return this.spawnerFrequency;
    }

    public void setSpawnerFrequency(Quantity spawnerFrequency) {
        this.spawnerFrequency = spawnerFrequency;
    }

    @Override
    public Quantity getChestFrequency() {
        return this.chestFrequency;
    }

    public void setChestFrequency(Quantity chestFrequency) {
        this.chestFrequency = chestFrequency;
    }

    @Override
    public List<String> getChestCategories() {
        return this.chestCategories;
    }

    public void setChestCategories(List<String> chestCategories) {
        this.chestCategories = chestCategories;
    }

    @Override
    public Quantity getNumberOfWebs() {
        return this.numberOfWebs;
    }

    public void setNumberOfWebs(Quantity numberOfWebs) {
        this.numberOfWebs = numberOfWebs;
    }

    @Override
    public Quantity getWebFrequency() {
        return this.webFrequency;
    }

    public void setWebFrequency(Quantity webFrequency) {
        this.webFrequency = webFrequency;
    }

    @Override
    public Quantity getNumberOfVines() {
        return this.numberOfVines;
    }

    public void setNumberOfVines(Quantity numberOfVines) {
        this.numberOfVines = numberOfVines;
    }

    @Override
    public Quantity getVineFrequency() {
        return this.vineFrequency;
    }

    public void setVineFrequency(Quantity vineFrequency) {
        this.vineFrequency = vineFrequency;
    }

    @Override
    public Boolean isDecorations() {
        return this.decorations;
    }

    @Override
    public void setDecorations(Boolean decorations) {
        this.decorations = decorations;
    }

    public String toString() {
        return "LevelConfig [boundaryFactor=" + this.boundaryFactor + ", spawnBoundaryFactor=" + this.spawnBoundaryFactor + ", numRooms=" + this.numRooms + ", width=" + this.width + ", depth=" + this.depth + ", height=" + this.height + ", degrees=" + this.degrees + ", decayMultiplier=" + this.decayMultiplier + ", spawnerFrequency=" + this.spawnerFrequency + ", chestConfig=" + this.chestConfig + ", chestFrequency=" + this.chestFrequency + ", chestCategories=" + this.chestCategories + ", numberOfWebs=" + this.numberOfWebs + ", webFrequency=" + this.webFrequency + ", numberOfVines=" + this.numberOfVines + ", vineFrequency=" + this.vineFrequency + ", theme=" + this.theme + ", support=" + this.support + ", decorations=" + this.decorations + "]";
    }

    @Override
    public Double getSpawnBoundaryFactor() {
        return this.spawnBoundaryFactor;
    }

    @Override
    public void setSpawnBoundaryFactor(Double spawnBoundaryFactor) {
        this.spawnBoundaryFactor = spawnBoundaryFactor;
    }

    @Override
    public String getTheme() {
        return this.theme;
    }

    @Override
    public void setTheme(String theme) {
        this.theme = theme;
    }

    @Override
    public IChestConfig getChestConfig() {
        return this.chestConfig;
    }

    @Override
    public void setChestConfig(IChestConfig chestConfig) {
        this.chestConfig = chestConfig;
    }
}

