/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeonsengine.model;

import com.someguyssoftware.dungeons2.Dungeons2;
import com.someguyssoftware.gottschcore.positional.BBox;
import com.someguyssoftware.gottschcore.positional.ICoords;

public class Boundary {
    private BBox bbox;

    public Boundary(ICoords c1, ICoords c2) {
        this.bbox = new BBox(c1, c2);
    }

    public Boundary(BBox bbox) {
        this.bbox = bbox;
    }

    public Boundary(BBox bbox, double factor) {
    }

    public Boundary resize(double factor, int minSize) {
        if (factor < 1.0) {
            double p;
            double deltaX = this.getMaxCoords().getX() - this.getMinCoords().getX();
            double deltaZ = this.getMaxCoords().getZ() - this.getMinCoords().getZ();
            Dungeons2.log.debug("deltaX -> {}", (Object)deltaX);
            Dungeons2.log.debug("deltaZ -> {}", (Object)deltaZ);
            int xAmount = (int)(deltaX * (1.0 - factor) / 2.0);
            int zAmount = (int)(deltaZ * (1.0 - factor) / 2.0);
            Dungeons2.log.debug("initial shrink amounts -> {} {}", (Object)xAmount, (Object)zAmount);
            if (Math.abs(deltaX - (double)(xAmount * 2)) < (double)minSize) {
                p = 1.0 - 50.0 / Math.abs(deltaX);
                xAmount = (int)(deltaX * p / 2.0);
                Dungeons2.log.debug("x less than min, new amount -> {} [{}%]", (Object)xAmount, (Object)p);
            }
            if (Math.abs(deltaZ - (double)(zAmount * 2)) < (double)minSize) {
                p = 1.0 - 50.0 / Math.abs(deltaZ);
                zAmount = (int)(deltaZ * p / 2.0);
                Dungeons2.log.debug("z less than min, new amount -> {} [{}%]", (Object)zAmount, (Object)p);
            }
            Boundary newBoundary = this.grow(-xAmount, 0, -zAmount);
            Dungeons2.log.debug("boundary shrunk by -> {} {}, to new size -> {}", (Object)xAmount, (Object)zAmount, (Object)newBoundary);
            return newBoundary;
        }
        return this;
    }

    public Boundary grow(int factor) {
        int amount = (int)((double)(this.bbox.getMaxCoords().getX() - this.bbox.getMinCoords().getX()) * (1.0 - (double)factor) / 2.0);
        BBox bbox = this.bbox.grow(amount, 0, amount);
        return new Boundary(bbox);
    }

    public Boundary grow(int x, int y, int z) {
        return new Boundary(this.bbox.grow(x, y, z));
    }

    public Boundary expand(int x, int y, int z) {
        return new Boundary(this.bbox.expand((double)x, (double)y, (double)z));
    }

    public Boundary shrink(double factor) {
        int amount = (int)((double)(this.bbox.getMaxCoords().getX() - this.bbox.getMinCoords().getX()) * (1.0 - factor) / 2.0);
        BBox bbox = this.bbox.grow(-amount, 0, -amount);
        return new Boundary(bbox);
    }

    public ICoords getMaxCoords() {
        return this.bbox.getMaxCoords();
    }

    public ICoords getMinCoords() {
        return this.bbox.getMinCoords();
    }

    public BBox getBbox() {
        return this.bbox;
    }

    public void setBbox(BBox bbox) {
        this.bbox = bbox;
    }
}

