/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeonsengine.model;

import com.someguyssoftware.dungeonsengine.enums.RoomTag;
import com.someguyssoftware.dungeonsengine.model.ISpace;
import com.someguyssoftware.gottschcore.enums.Direction;
import com.someguyssoftware.gottschcore.positional.BBox;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.positional.Intersect;
import java.util.Comparator;
import java.util.List;

public interface IRoom
extends ISpace {
    public static final int MIN_DEPTH = 5;
    public static final int MIN_WIDTH = 5;
    public static final int MIN_HEIGHT = 4;
    public static final int MIN_SPECIAL_WIDTH = 7;
    public static final int MIN_SPECIAL_DEPTH = 7;
    public static final Comparator<IRoom> idComparator = new Comparator<IRoom>(){

        @Override
        public int compare(IRoom p1, IRoom p2) {
            if (p1.getID() > p2.getID()) {
                return 1;
            }
            return -1;
        }
    };

    public IRoom copy();

    public int getID();

    public IRoom setID(int var1);

    public String getName();

    public IRoom setName(String var1);

    public Direction getDirection();

    public IRoom setDirection(Direction var1);

    public int getDegrees();

    public IRoom setDegrees(int var1);

    default public int getMinX() {
        return this.getCoords().getX();
    }

    default public int getMaxX() {
        return this.getCoords().getX() + this.getWidth() - 1;
    }

    default public int getMinY() {
        return this.getCoords().getY();
    }

    default public int getMaxY() {
        return this.getCoords().getY() + this.getHeight() - 1;
    }

    default public int getMinZ() {
        return this.getCoords().getZ();
    }

    default public int getMaxZ() {
        return this.getCoords().getZ() + this.getDepth() - 1;
    }

    default public BBox getBoundingBox() {
        BBox bb = new BBox(this.getCoords(), this.getCoords().add(this.getWidth(), this.getHeight(), this.getDepth()));
        return bb;
    }

    default public BBox getXZBoundingBox() {
        BBox bb = new BBox((ICoords)new Coords(this.getCoords().getX(), 0, this.getCoords().getZ()), this.getCoords().add(this.getWidth(), 1, this.getDepth()));
        return bb;
    }

    default public ICoords getCenter() {
        int x = this.getCoords().getX() + (this.getWidth() - 1) / 2;
        int y = this.getCoords().getY() + (this.getHeight() - 1) / 2;
        int z = this.getCoords().getZ() + (this.getDepth() - 1) / 2;
        Coords coords = new Coords(x, y, z);
        return coords;
    }

    default public ICoords getBottomCenter() {
        int x = this.getCoords().getX() + (this.getWidth() - 1) / 2;
        int y = this.getCoords().getY();
        int z = this.getCoords().getZ() + (this.getDepth() - 1) / 2;
        Coords coords = new Coords(x, y, z);
        return coords;
    }

    default public ICoords getTopCenter() {
        int x = this.getCoords().getX() + (this.getWidth() - 1) / 2;
        int y = this.getCoords().getY() + this.getHeight();
        int z = this.getCoords().getZ() + (this.getDepth() - 1) / 2;
        Coords coords = new Coords(x, y, z);
        return coords;
    }

    default public ICoords getXZCenter() {
        int x = this.getCoords().getX() + (this.getWidth() - 1) / 2;
        int y = this.getCoords().getY();
        int z = this.getCoords().getZ() + (this.getDepth() - 1) / 2;
        Coords coords = new Coords(x, y, z);
        return coords;
    }

    default public Intersect getIntersect(IRoom room) {
        return Intersect.getIntersect((BBox)this.getBoundingBox(), (BBox)room.getBoundingBox());
    }

    default public IRoom addXZForce(double angle, double force) {
        double xForce = Math.sin(angle) * force;
        double zForce = Math.cos(angle) * force;
        IRoom room = this.copy();
        room.setCoords(room.getCoords().add((int)xForce, 0, (int)zForce));
        return room;
    }

    default public String printDimensions() {
        return String.format("Dimensions -> [w: %d, h: %d, d: %d]", this.getWidth(), this.getHeight(), this.getDepth());
    }

    default public String printCoords() {
        return String.format("Coords -> [x: %d, y: %d, z: %d]", this.getCoords().getX(), this.getCoords().getY(), this.getCoords().getZ());
    }

    default public String printCenter() {
        return String.format("Center -> [x: %d, y: %d, z: %d]", this.getCenter().getX(), this.getCenter().getY(), this.getCenter().getZ());
    }

    public boolean isAnchor();

    public IRoom setAnchor(boolean var1);

    public boolean isStart();

    public IRoom setStart(boolean var1);

    public boolean isEnd();

    public IRoom setEnd(boolean var1);

    public boolean isObstacle();

    public IRoom setObstacle(boolean var1);

    public void centerOn(ICoords var1);

    public List<RoomTag> getTags();

    public void setTags(List<RoomTag> var1);

    public IRoom setDimensions(int var1, int var2, int var3);
}

