/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles;

import com.creativemd.creativecore.transformer.CreativeTransformer;
import com.creativemd.creativecore.transformer.Transformer;
import com.creativemd.creativecore.transformer.TransformerNames;
import java.util.ListIterator;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class LittleTilesTransformer
extends CreativeTransformer {
    public LittleTilesTransformer() {
        super("littletiles");
    }

    protected void initTransformers() {
        this.addTransformer(new Transformer("net.minecraft.client.renderer.RenderGlobal"){

            public void transform(ClassNode classNode) {
                MethodNode m = this.findMethod(classNode, "renderEntities", "(Lnet/minecraft/entity/Entity;Lnet/minecraft/client/renderer/culling/ICamera;F)V");
                m.instructions.insertBefore(m.instructions.getFirst(), (AbstractInsnNode)new MethodInsnNode(184, "com/creativemd/littletiles/client/world/LittleAnimationHandlerClient", "renderTick", "()V", false));
                m = this.findMethod(classNode, "loadRenderers", "()V");
                AbstractInsnNode first = m.instructions.getFirst();
                m.instructions.insertBefore(first, (AbstractInsnNode)new LabelNode());
                m.instructions.insertBefore(first, (AbstractInsnNode)new VarInsnNode(25, 0));
                m.instructions.insertBefore(first, (AbstractInsnNode)new MethodInsnNode(184, "com/creativemd/littletiles/client/render/world/LittleChunkDispatcher", "onReloadRenderers", this.patchDESC("(Lnet/minecraft/client/renderer/RenderGlobal;)V"), false));
            }
        });
        this.addTransformer(new Transformer("net.minecraft.client.renderer.chunk.ChunkRenderDispatcher"){

            public void transform(ClassNode node) {
                MethodNode m = this.findMethod(node, "uploadChunk", "(Lnet/minecraft/util/BlockRenderLayer;Lnet/minecraft/client/renderer/BufferBuilder;Lnet/minecraft/client/renderer/chunk/RenderChunk;Lnet/minecraft/client/renderer/chunk/CompiledChunk;D)Lcom/google/common/util/concurrent/ListenableFuture;");
                AbstractInsnNode first = m.instructions.getFirst();
                m.instructions.insertBefore(first, (AbstractInsnNode)new VarInsnNode(25, 1));
                m.instructions.insertBefore(first, (AbstractInsnNode)new VarInsnNode(25, 2));
                m.instructions.insertBefore(first, (AbstractInsnNode)new VarInsnNode(25, 3));
                m.instructions.insertBefore(first, (AbstractInsnNode)new VarInsnNode(25, 4));
                m.instructions.insertBefore(first, (AbstractInsnNode)new VarInsnNode(24, 5));
                m.instructions.insertBefore(first, (AbstractInsnNode)new MethodInsnNode(184, "com/creativemd/littletiles/client/render/world/LittleChunkDispatcher", "uploadChunk", this.patchDESC("(Lnet/minecraft/util/BlockRenderLayer;Lnet/minecraft/client/renderer/BufferBuilder;Lnet/minecraft/client/renderer/chunk/RenderChunk;Lnet/minecraft/client/renderer/chunk/CompiledChunk;D)V"), false));
            }
        });
        this.addTransformer(new Transformer("net.minecraft.entity.player.EntityPlayer"){

            public void transform(ClassNode node) {
                node.fields.add(new FieldNode(1, "littleBed", "Lcom/creativemd/littletiles/common/structure/LittleStructure;", null, null));
                MethodNode m = this.findMethod(node, "getBedOrientationInDegrees", "()F");
                if (m != null) {
                    m.instructions.clear();
                    m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    m.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/creativemd/littletiles/common/structure/type/LittleBed", "getBedOrientationInDegrees", this.patchDESC("(Lnet/minecraft/entity/player/EntityPlayer;)F"), false));
                    m.instructions.add((AbstractInsnNode)new InsnNode(174));
                }
            }
        });
        this.addTransformer(new Transformer("net.minecraftforge.client.ForgeHooksClient"){

            public void transform(ClassNode node) {
                MethodNode m = this.findMethod(node, "orientBedCamera", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/Entity;)V");
                ListIterator iterator = m.instructions.iterator();
                boolean nextLabel = false;
                while (iterator.hasNext()) {
                    AbstractInsnNode insn = (AbstractInsnNode)iterator.next();
                    if (nextLabel && insn instanceof LabelNode) {
                        m.instructions.insert(insn, (AbstractInsnNode)new MethodInsnNode(184, "com/creativemd/littletiles/common/structure/type/LittleBed", "setBedDirection", this.patchDESC("(Lnet/minecraft/entity/Entity;)V"), false));
                        m.instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 3));
                        break;
                    }
                    if (!(insn instanceof MethodInsnNode) || !((MethodInsnNode)insn).owner.equals(this.patchDESC("org/lwjgl/opengl/GL11")) || !((MethodInsnNode)insn).name.equals(this.patchFieldName("glRotatef"))) continue;
                    nextLabel = true;
                }
            }
        });
        this.addTransformer(new Transformer("net.minecraft.client.renderer.chunk.RenderChunk"){

            public void transform(ClassNode node) {
                MethodNode m = this.findMethod(node, "resortTransparency", "(FFFLnet/minecraft/client/renderer/chunk/ChunkCompileTaskGenerator;)V");
                m.instructions.clear();
                m.instructions.add((AbstractInsnNode)new LabelNode());
                m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                m.instructions.add((AbstractInsnNode)new VarInsnNode(23, 1));
                m.instructions.add((AbstractInsnNode)new VarInsnNode(23, 2));
                m.instructions.add((AbstractInsnNode)new VarInsnNode(23, 3));
                m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 4));
                m.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/creativemd/littletiles/client/render/world/LittleChunkDispatcher", "resortTransparency", "(Lnet/minecraft/client/renderer/chunk/RenderChunk;FFFLnet/minecraft/client/renderer/chunk/ChunkCompileTaskGenerator;)V", false));
                m.instructions.add((AbstractInsnNode)new InsnNode(177));
                m.instructions.add((AbstractInsnNode)new LabelNode());
            }
        });
        this.addTransformer(new Transformer("net.minecraft.client.renderer.BufferBuilder"){

            public void transform(ClassNode node) {
                node.fields.add(new FieldNode(1, "littleTilesAdded", "Z", null, (Object)Boolean.FALSE));
                MethodNode m = this.findMethod(node, "reset", "()V");
                AbstractInsnNode start = m.instructions.getFirst();
                m.instructions.insertBefore(start, (AbstractInsnNode)new LabelNode());
                m.instructions.insertBefore(start, (AbstractInsnNode)new VarInsnNode(25, 0));
                m.instructions.insertBefore(start, (AbstractInsnNode)new InsnNode(3));
                m.instructions.insertBefore(start, (AbstractInsnNode)new FieldInsnNode(181, this.patchClassName("net/minecraft/client/renderer/BufferBuilder"), "littleTilesAdded", "Z"));
                m = this.findMethod(node, "getDistanceSq", "(Ljava/nio/FloatBuffer;FFFII)F");
                m.instructions.clear();
                m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                m.instructions.add((AbstractInsnNode)new VarInsnNode(23, 1));
                m.instructions.add((AbstractInsnNode)new VarInsnNode(23, 2));
                m.instructions.add((AbstractInsnNode)new VarInsnNode(23, 3));
                m.instructions.add((AbstractInsnNode)new VarInsnNode(21, 4));
                m.instructions.add((AbstractInsnNode)new VarInsnNode(21, 5));
                m.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/creativemd/littletiles/client/render/world/LittleChunkDispatcher", "getDistanceSq", "(Ljava/nio/FloatBuffer;FFFII)F", false));
                m.instructions.add((AbstractInsnNode)new InsnNode(174));
            }
        });
        this.addTransformer(new Transformer("net.minecraft.network.NettyCompressionDecoder"){

            public void transform(ClassNode node) {
                String descException = this.patchDESC("io/netty/handler/codec/DecoderException");
                String desc = this.patchDESC("(Lio/netty/channel/ChannelHandlerContext;Lio/netty/buffer/ByteBuf;Ljava/util/List;)V");
                String name = TransformerNames.patchMethodName((String)"decode", (String)desc, (String)this.patchClassName("io/netty/handler/codec/ByteToMessageDecoder"));
                MethodNode m = this.findMethod(node, name, desc);
                ListIterator iterator = m.instructions.iterator();
                int found = 0;
                while (iterator.hasNext()) {
                    AbstractInsnNode insn = (AbstractInsnNode)iterator.next();
                    if (insn instanceof TypeInsnNode && insn.getOpcode() == 187 && ((TypeInsnNode)insn).desc.equals(descException)) {
                        if (++found != 2) continue;
                        iterator.remove();
                        continue;
                    }
                    if (found != 2) continue;
                    iterator.remove();
                    if (!(insn instanceof InsnNode) || insn.getOpcode() != 191) continue;
                    break;
                }
            }
        });
        this.addTransformer(new Transformer("net.minecraft.network.PacketBuffer"){

            public void transform(ClassNode node) {
                MethodNode m = this.findMethod(node, "readCompoundTag", "()Lnet/minecraft/nbt/NBTTagCompound;");
                for (AbstractInsnNode insn : m.instructions) {
                    if (!(insn instanceof LdcInsnNode) || !(((LdcInsnNode)insn).cst instanceof Long)) continue;
                    m.instructions.remove(insn.getPrevious().getPrevious());
                    m.instructions.remove(insn.getPrevious());
                    m.instructions.remove(insn.getNext());
                    m.instructions.insert(insn, (AbstractInsnNode)new FieldInsnNode(178, this.patchDESC("net/minecraft/nbt/NBTSizeTracker"), TransformerNames.patchFieldName((String)"INFINITE", (String)this.patchClassName("net/minecraft/nbt/NBTSizeTracker")), this.patchDESC("Lnet/minecraft/nbt/NBTSizeTracker;")));
                    m.instructions.remove(insn);
                    break;
                }
            }
        });
        this.addTransformer(new Transformer("net.minecraft.util.math.AxisAlignedBB"){

            public void transform(ClassNode node) {
                MethodNode m = this.findMethod(node, "intersects", "(Lnet/minecraft/util/math/AxisAlignedBB;)Z");
                String axisClassName = this.patchClassName("net/minecraft/util/math/AxisAlignedBB");
                String methodDesc = "(L" + axisClassName + ";)Z";
                LabelNode label = (LabelNode)m.instructions.getFirst();
                m.instructions.insertBefore((AbstractInsnNode)label, (AbstractInsnNode)new LabelNode());
                m.instructions.insertBefore((AbstractInsnNode)label, (AbstractInsnNode)new VarInsnNode(25, 1));
                m.instructions.insertBefore((AbstractInsnNode)label, (AbstractInsnNode)new TypeInsnNode(193, "com/creativemd/creativecore/common/utils/math/box/CreativeAxisAlignedBB"));
                m.instructions.insertBefore((AbstractInsnNode)label, (AbstractInsnNode)new JumpInsnNode(153, label));
                m.instructions.insertBefore((AbstractInsnNode)label, (AbstractInsnNode)new LabelNode());
                m.instructions.insertBefore((AbstractInsnNode)label, (AbstractInsnNode)new VarInsnNode(25, 1));
                m.instructions.insertBefore((AbstractInsnNode)label, (AbstractInsnNode)new VarInsnNode(25, 0));
                m.instructions.insertBefore((AbstractInsnNode)label, (AbstractInsnNode)new MethodInsnNode(182, axisClassName, this.patchMethodName("intersects", methodDesc), methodDesc, false));
                m.instructions.insertBefore((AbstractInsnNode)label, (AbstractInsnNode)new InsnNode(172));
                String methodDESC2 = this.patchDESC("(Lnet/minecraft/util/math/AxisAlignedBB;D)D");
                String methodName = this.patchMethodName("calculateYOffset", methodDESC2);
                m = new MethodNode(1, "calculateYOffsetStepUp", this.patchDESC("(Lnet/minecraft/util/math/AxisAlignedBB;Lnet/minecraft/util/math/AxisAlignedBB;D)D"), null, null);
                LabelNode l0 = new LabelNode();
                m.instructions.add((AbstractInsnNode)l0);
                m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                m.instructions.add((AbstractInsnNode)new VarInsnNode(24, 3));
                m.instructions.add((AbstractInsnNode)new MethodInsnNode(182, axisClassName, methodName, methodDESC2, false));
                m.instructions.add((AbstractInsnNode)new InsnNode(175));
                LabelNode l1 = new LabelNode();
                m.instructions.add((AbstractInsnNode)l1);
                m.localVariables.add(new LocalVariableNode("this", "L" + axisClassName + ";", null, l0, l1, 0));
                m.localVariables.add(new LocalVariableNode("other", "L" + axisClassName + ";", null, l0, l1, 1));
                m.localVariables.add(new LocalVariableNode("otherY", "L" + axisClassName + ";", null, l0, l1, 2));
                m.localVariables.add(new LocalVariableNode("offset", "D", null, l0, l1, 3));
                m.visitMaxs(4, 5);
                node.methods.add(m);
            }
        });
        this.addTransformer(new Transformer("net.minecraftforge.common.ForgeHooks"){

            public void transform(ClassNode node) {
                MethodNode m = this.findMethod(node, "isLivingOnLadder", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/EntityLivingBase;)Z");
                m.instructions.clear();
                m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
                m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 3));
                m.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/creativemd/littletiles/common/structure/type/LittleLadder", "isLivingOnLadder", this.patchDESC("(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/EntityLivingBase;)Z"), false));
                m.instructions.add((AbstractInsnNode)new InsnNode(172));
            }
        });
        this.addTransformer(new Transformer("net.minecraft.entity.Entity"){

            public void transform(ClassNode node) {
                MethodNode m = this.findMethod(node, "move", "(Lnet/minecraft/entity/MoverType;DDD)V");
                for (AbstractInsnNode insn : m.instructions) {
                    if (!(insn instanceof VarInsnNode) || insn.getOpcode() != 25 || ((VarInsnNode)insn).var != 32) continue;
                    MethodInsnNode methodInsn = (MethodInsnNode)insn.getNext().getNext();
                    methodInsn.name = "calculateYOffsetStepUp";
                    methodInsn.desc = this.patchDESC("(Lnet/minecraft/util/math/AxisAlignedBB;Lnet/minecraft/util/math/AxisAlignedBB;D)D");
                    m.instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 31));
                    return;
                }
            }
        });
        this.addTransformer(new Transformer("net.minecraft.client.Minecraft"){

            public void transform(ClassNode node) {
                MethodNode m = this.findMethod(node, "middleClickMouse", "()V");
                String className = this.patchClassName("net/minecraft/client/Minecraft");
                LabelNode first = (LabelNode)m.instructions.getFirst();
                m.instructions.insertBefore((AbstractInsnNode)first, (AbstractInsnNode)new LabelNode());
                m.instructions.insertBefore((AbstractInsnNode)first, (AbstractInsnNode)new VarInsnNode(25, 0));
                m.instructions.insertBefore((AbstractInsnNode)first, (AbstractInsnNode)new FieldInsnNode(180, className, this.patchFieldName("player"), this.patchDESC("Lnet/minecraft/client/entity/EntityPlayerSP;")));
                m.instructions.insertBefore((AbstractInsnNode)first, (AbstractInsnNode)new VarInsnNode(25, 0));
                m.instructions.insertBefore((AbstractInsnNode)first, (AbstractInsnNode)new FieldInsnNode(180, className, this.patchFieldName("world"), this.patchDESC("Lnet/minecraft/client/multiplayer/WorldClient;")));
                m.instructions.insertBefore((AbstractInsnNode)first, (AbstractInsnNode)new MethodInsnNode(184, "com/creativemd/littletiles/client/event/InputEventHandler", "onMouseWheelClick", this.patchDESC("(Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/world/World;)Z"), false));
                m.instructions.insertBefore((AbstractInsnNode)first, (AbstractInsnNode)new JumpInsnNode(153, first));
                m.instructions.insertBefore((AbstractInsnNode)first, (AbstractInsnNode)new LabelNode());
                m.instructions.insertBefore((AbstractInsnNode)first, (AbstractInsnNode)new InsnNode(177));
                for (AbstractInsnNode insn : m.instructions) {
                    if (!(insn instanceof MethodInsnNode) || insn.getOpcode() != 184 || !((MethodInsnNode)insn).owner.equals("net/minecraftforge/common/ForgeHooks") || !((MethodInsnNode)insn).name.equals("onPickBlock") || !((MethodInsnNode)insn).desc.equals(this.patchDESC("(Lnet/minecraft/util/math/RayTraceResult;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/world/World;)Z"))) continue;
                    m.instructions.insertBefore(insn, (AbstractInsnNode)new MethodInsnNode(184, "com/creativemd/littletiles/client/event/InputEventHandler", "onPickBlock", this.patchDESC("(Lnet/minecraft/util/math/RayTraceResult;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/world/World;)Z"), false));
                    m.instructions.insertBefore(insn, (AbstractInsnNode)new JumpInsnNode(154, this.findNextLabel(insn)));
                    m.instructions.insertBefore(insn, (AbstractInsnNode)new LabelNode());
                    m.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                    m.instructions.insertBefore(insn, (AbstractInsnNode)new FieldInsnNode(180, className, this.patchFieldName("objectMouseOver"), this.patchDESC("Lnet/minecraft/util/math/RayTraceResult;")));
                    m.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                    m.instructions.insertBefore(insn, (AbstractInsnNode)new FieldInsnNode(180, className, this.patchFieldName("player"), this.patchDESC("Lnet/minecraft/client/entity/EntityPlayerSP;")));
                    m.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                    m.instructions.insertBefore(insn, (AbstractInsnNode)new FieldInsnNode(180, className, this.patchFieldName("world"), this.patchDESC("Lnet/minecraft/client/multiplayer/WorldClient;")));
                    break;
                }
                m = this.findMethod(node, "processKeyBinds", "()V");
                String clickMouse = this.patchMethodName("clickMouse", "()V");
                for (AbstractInsnNode insn : m.instructions) {
                    if (!(insn instanceof MethodInsnNode) || insn.getOpcode() != 183 || !((MethodInsnNode)insn).owner.equals(className) || !((MethodInsnNode)insn).name.equals(clickMouse) || !((MethodInsnNode)insn).desc.equals("()V")) continue;
                    AbstractInsnNode after = insn.getNext();
                    insn = insn.getPrevious();
                    LabelNode elseNode = new LabelNode();
                    m.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                    m.instructions.insertBefore(insn, (AbstractInsnNode)new FieldInsnNode(180, className, this.patchFieldName("objectMouseOver"), this.patchDESC("Lnet/minecraft/util/math/RayTraceResult;")));
                    m.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                    m.instructions.insertBefore(insn, (AbstractInsnNode)new FieldInsnNode(180, className, this.patchFieldName("player"), this.patchDESC("Lnet/minecraft/client/entity/EntityPlayerSP;")));
                    m.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                    m.instructions.insertBefore(insn, (AbstractInsnNode)new FieldInsnNode(180, className, this.patchFieldName("world"), this.patchDESC("Lnet/minecraft/client/multiplayer/WorldClient;")));
                    m.instructions.insertBefore(insn, (AbstractInsnNode)new MethodInsnNode(184, "com/creativemd/littletiles/client/event/InputEventHandler", "onMouseClick", this.patchDESC("(Lnet/minecraft/util/math/RayTraceResult;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/world/World;)Z"), false));
                    m.instructions.insertBefore(insn, (AbstractInsnNode)new JumpInsnNode(154, elseNode));
                    m.instructions.insertBefore(after, (AbstractInsnNode)elseNode);
                    break;
                }
                String sendClickBlockToController = this.patchMethodName("sendClickBlockToController", "(Z)V");
                for (AbstractInsnNode insn : m.instructions) {
                    if (!(insn instanceof MethodInsnNode) || insn.getOpcode() != 183 || !((MethodInsnNode)insn).owner.equals(className) || !((MethodInsnNode)insn).name.equals(sendClickBlockToController) || !((MethodInsnNode)insn).desc.equals("(Z)V")) continue;
                    ((MethodInsnNode)insn).owner = "com/creativemd/littletiles/client/event/InputEventHandler";
                    ((MethodInsnNode)insn).setOpcode(184);
                    ((MethodInsnNode)insn).name = "onHoldClick";
                    ((MethodInsnNode)insn).desc = "(Z)V";
                }
            }
        });
        this.addTransformer(new Transformer("net.optifine.DynamicLight"){

            public void transform(ClassNode node) {
                MethodNode m = this.findMethod(node, "updateChunkLight", "(Lnet/minecraft/client/renderer/chunk/RenderChunk;Ljava/util/Set;Ljava/util/Set;)V");
                String className = this.patchClassName("net/minecraft/client/renderer/chunk/RenderChunk");
                String methodName = TransformerNames.patchMethodName((String)"setNeedsUpdate", (String)"(Z)V", (String)className);
                for (AbstractInsnNode insn : m.instructions) {
                    if (!(insn instanceof MethodInsnNode) || insn.getOpcode() != 182 || !((MethodInsnNode)insn).name.equals(methodName) || !((MethodInsnNode)insn).owner.equals(className)) continue;
                    AbstractInsnNode before = insn.getPrevious().getPrevious();
                    m.instructions.insert(insn, (AbstractInsnNode)new MethodInsnNode(184, "com/creativemd/littletiles/client/render/world/LittleChunkDispatcher", "onOptifineMarksChunkRenderUpdateForDynamicLights", "(Lnet/minecraft/client/renderer/chunk/RenderChunk;)V", false));
                    m.instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, ((VarInsnNode)before).var));
                    return;
                }
            }
        });
        this.addTransformer(new Transformer("net.optifine.ConnectedTextures"){

            public void transform(ClassNode node) {
                MethodNode m = this.findMethod(node, "getConnectedTextureSingle", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;Lnet/minecraft/client/renderer/block/model/BakedQuad;ZILnet/optifine/render/RenderEnv;)[Lnet/minecraft/client/renderer/block/model/BakedQuad;");
                for (AbstractInsnNode insn : m.instructions) {
                    if (!(insn instanceof MethodInsnNode) || insn.getOpcode() != 182 || !((MethodInsnNode)insn).name.equals("matchesBlockId") || !((MethodInsnNode)insn).owner.equals("net/optifine/ConnectedProperties")) continue;
                    m.instructions.remove(insn.getPrevious());
                    m.instructions.remove(insn.getPrevious());
                    m.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                    m.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 2));
                    m.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 9));
                    m.instructions.insertBefore(insn, (AbstractInsnNode)new MethodInsnNode(184, "com/creativemd/littletiles/client/mod/optifine/ConnectedTexturesModifier", "matches", this.patchDESC("(Ljava/lang/Object;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)Z"), false));
                    m.instructions.remove(insn);
                    break;
                }
                m = this.findMethod(node, "isNeighbourMatching", "(Lnet/optifine/ConnectedProperties;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/math/BlockPos;ILnet/minecraft/client/renderer/texture/TextureAtlasSprite;I)Z");
                for (AbstractInsnNode insn : m.instructions) {
                    if (!(insn instanceof MethodInsnNode) || insn.getOpcode() != 182 || !((MethodInsnNode)insn).name.equals("matchesBlock") || !((MethodInsnNode)insn).owner.equals("net/optifine/ConnectedProperties")) continue;
                    AbstractInsnNode before = insn.getPrevious().getPrevious();
                    m.instructions.remove(before.getPrevious());
                    m.instructions.remove(before.getPrevious());
                    m.instructions.insertBefore(before, (AbstractInsnNode)new VarInsnNode(25, 1));
                    m.instructions.insertBefore(before, (AbstractInsnNode)new VarInsnNode(25, 3));
                    m.instructions.insertBefore(insn, (AbstractInsnNode)new MethodInsnNode(184, "com/creativemd/littletiles/client/mod/optifine/ConnectedTexturesModifier", "matches", this.patchDESC("(Ljava/lang/Object;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;I)Z"), false));
                    m.instructions.remove(insn);
                    break;
                }
                m = this.findMethod(node, "isNeighbour", "(Lnet/optifine/ConnectedProperties;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;ILnet/minecraft/client/renderer/texture/TextureAtlasSprite;I)Z");
                LabelNode insn = (LabelNode)m.instructions.getFirst();
                m.instructions.insertBefore((AbstractInsnNode)insn, (AbstractInsnNode)new LabelNode());
                m.instructions.insertBefore((AbstractInsnNode)insn, (AbstractInsnNode)new VarInsnNode(25, 1));
                m.instructions.insertBefore((AbstractInsnNode)insn, (AbstractInsnNode)new VarInsnNode(25, 2));
                m.instructions.insertBefore((AbstractInsnNode)insn, (AbstractInsnNode)new VarInsnNode(25, 3));
                m.instructions.insertBefore((AbstractInsnNode)insn, (AbstractInsnNode)new MethodInsnNode(184, "com/creativemd/littletiles/client/mod/optifine/ConnectedTexturesModifier", "isNeighbour", this.patchDESC("(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/math/BlockPos;)Z"), false));
                m.instructions.insertBefore((AbstractInsnNode)insn, (AbstractInsnNode)new JumpInsnNode(153, insn));
                m.instructions.insertBefore((AbstractInsnNode)insn, (AbstractInsnNode)new LabelNode());
                m.instructions.insertBefore((AbstractInsnNode)insn, (AbstractInsnNode)new InsnNode(4));
                m.instructions.insertBefore((AbstractInsnNode)insn, (AbstractInsnNode)new InsnNode(172));
                m = this.findMethod(node, "isFullCubeModel", "(Lnet/minecraft/block/state/IBlockState;)Z");
                insn = (LabelNode)m.instructions.getFirst();
                m.instructions.insertBefore((AbstractInsnNode)insn, (AbstractInsnNode)new LabelNode());
                m.instructions.insertBefore((AbstractInsnNode)insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                m.instructions.insertBefore((AbstractInsnNode)insn, (AbstractInsnNode)new MethodInsnNode(184, "com/creativemd/littletiles/client/mod/optifine/ConnectedTexturesModifier", "isFullCube", this.patchDESC("(Lnet/minecraft/block/state/IBlockState;)Z"), false));
                m.instructions.insertBefore((AbstractInsnNode)insn, (AbstractInsnNode)new JumpInsnNode(153, insn));
                m.instructions.insertBefore((AbstractInsnNode)insn, (AbstractInsnNode)new LabelNode());
                m.instructions.insertBefore((AbstractInsnNode)insn, (AbstractInsnNode)new InsnNode(4));
                m.instructions.insertBefore((AbstractInsnNode)insn, (AbstractInsnNode)new InsnNode(172));
            }
        });
        this.addTransformer(new Transformer("net.minecraft.client.multiplayer.WorldClient"){

            public void transform(ClassNode node) {
                MethodNode m = this.findMethod(node, "addEntityToWorld", "(ILnet/minecraft/entity/Entity;)V");
                LabelNode first = (LabelNode)m.instructions.getFirst();
                m.instructions.insertBefore((AbstractInsnNode)first, (AbstractInsnNode)new VarInsnNode(25, 0));
                m.instructions.insertBefore((AbstractInsnNode)first, (AbstractInsnNode)new VarInsnNode(21, 1));
                m.instructions.insertBefore((AbstractInsnNode)first, (AbstractInsnNode)new VarInsnNode(25, 2));
                m.instructions.insertBefore((AbstractInsnNode)first, (AbstractInsnNode)new MethodInsnNode(184, "com/creativemd/littletiles/common/event/LittleEventHandler", "cancelEntitySpawn", "(Lnet/minecraft/client/multiplayer/WorldClient;ILnet/minecraft/entity/Entity;)Z", false));
                m.instructions.insertBefore((AbstractInsnNode)first, (AbstractInsnNode)new JumpInsnNode(153, first));
                m.instructions.insertBefore((AbstractInsnNode)first, (AbstractInsnNode)new LabelNode());
                m.instructions.insertBefore((AbstractInsnNode)first, (AbstractInsnNode)new InsnNode(177));
            }
        });
        this.addTransformer(new Transformer("net.minecraft.entity.player.EntityPlayerMP"){

            public void transform(ClassNode node) {
                node.fields.add(new FieldNode(1, "wasPushedByDoor", "I", null, (Object)false));
                MethodNode m = this.findMethod(node, "onUpdate", "()V");
                LabelNode first = (LabelNode)m.instructions.getFirst();
                m.instructions.insertBefore((AbstractInsnNode)first, (AbstractInsnNode)new LabelNode());
                m.instructions.insertBefore((AbstractInsnNode)first, (AbstractInsnNode)new VarInsnNode(25, 0));
                m.instructions.insertBefore((AbstractInsnNode)first, (AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/player/EntityPlayerMP", "wasPushedByDoor", "I"));
                m.instructions.insertBefore((AbstractInsnNode)first, (AbstractInsnNode)new JumpInsnNode(158, first));
                m.instructions.insertBefore((AbstractInsnNode)first, (AbstractInsnNode)new VarInsnNode(25, 0));
                m.instructions.insertBefore((AbstractInsnNode)first, (AbstractInsnNode)new InsnNode(89));
                m.instructions.insertBefore((AbstractInsnNode)first, (AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/player/EntityPlayerMP", "wasPushedByDoor", "I"));
                m.instructions.insertBefore((AbstractInsnNode)first, (AbstractInsnNode)new InsnNode(4));
                m.instructions.insertBefore((AbstractInsnNode)first, (AbstractInsnNode)new InsnNode(100));
                m.instructions.insertBefore((AbstractInsnNode)first, (AbstractInsnNode)new FieldInsnNode(181, "net/minecraft/entity/player/EntityPlayerMP", "wasPushedByDoor", "I"));
            }
        });
        this.addTransformer(new Transformer("net.minecraft.network.NetHandlerPlayServer"){

            public void transform(ClassNode node) {
                MethodNode m = this.findMethod(node, "processPlayer", "(Lnet/minecraft/network/play/client/CPacketPlayer;)V");
                for (AbstractInsnNode insn : m.instructions) {
                    if (!(insn instanceof MethodInsnNode) || insn.getOpcode() != 185 || !((MethodInsnNode)insn).name.equals("isEmpty") || !((MethodInsnNode)insn).owner.equals("java/util/List")) continue;
                    m.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                    m.instructions.insertBefore(insn, (AbstractInsnNode)new FieldInsnNode(180, this.patchClassName("net/minecraft/network/NetHandlerPlayServer"), this.patchFieldName("player"), this.patchDESC("Lnet/minecraft/entity/player/EntityPlayerMP;")));
                    MethodInsnNode mInsn = (MethodInsnNode)insn;
                    mInsn.setOpcode(184);
                    mInsn.owner = "com/creativemd/littletiles/common/world/WorldAnimationHandler";
                    mInsn.name = "checkIfEmpty";
                    mInsn.desc = this.patchDESC("(Ljava/util/List;Lnet/minecraft/entity/player/EntityPlayerMP;)Z");
                    mInsn.itf = false;
                }
            }
        });
        this.addTransformer(new Transformer("net.minecraft.client.renderer.BlockModelRenderer"){

            public void transform(ClassNode node) {
                String name = this.patchClassName("net/minecraft/client/renderer/BlockModelRenderer$AmbientOcclusionFace");
                for (InnerClassNode innerClass : node.innerClasses) {
                    if (!innerClass.name.equals(name)) continue;
                    innerClass.access += 33;
                }
            }
        });
        this.addTransformer(new Transformer("net.minecraft.client.renderer.BlockModelRenderer$AmbientOcclusionFace"){

            public void transform(ClassNode node) {
                for (MethodNode m : node.methods) {
                    if (!m.name.equals("<init>")) continue;
                    m.access = 1;
                    break;
                }
            }
        });
    }
}

