/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.gui;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.GuiRenderHelper;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBoxCategory;
import com.creativemd.creativecore.common.gui.controls.gui.GuiIconButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiPanel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.gui.controls.gui.custom.GuiItemComboBox;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.creativecore.common.utils.type.PairList;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.gui.configure.SubGuiConfigure;
import com.creativemd.littletiles.client.gui.controls.GuiAnimationViewer;
import com.creativemd.littletiles.client.gui.controls.IAnimationControl;
import com.creativemd.littletiles.common.entity.AnimationPreview;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.registry.LittleStructureGuiParser;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.tile.preview.LittlePreviewsStructure;
import com.creativemd.littletiles.common.util.animation.AnimationGuiHandler;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class SubGuiRecipe
extends SubGuiConfigure
implements IAnimationControl {
    public LittleStructure structure;
    public LittleStructureGuiParser parser;
    public PairList<String, PairList<String, Class<? extends LittleStructureGuiParser>>> craftables;
    public AnimationPreview animationPreview;
    public StructureHolder selected;
    protected LoadingThread loadingThread;
    public List<StructureHolder> hierarchy;
    public List<ItemStack> hierarchyStacks;
    public List<String> hierarchyNames;
    public LittlePreviews previews;
    public AnimationGuiHandler handler = new AnimationGuiHandler();

    public SubGuiRecipe(ItemStack stack) {
        super(350, 200, stack);
        PairList noneCategory = new PairList();
        noneCategory.add((Object)"structure.none.name", null);
        this.craftables = new PairList(LittleStructureRegistry.getCraftables());
        this.craftables.add(0, new Pair((Object)"", (Object)noneCategory));
        this.previews = LittlePreview.getPreview(stack);
        this.hierarchy = new ArrayList<StructureHolder>();
        this.hierarchyStacks = new ArrayList<ItemStack>();
        this.hierarchyNames = new ArrayList<String>();
        SubGuiRecipe.addPreviews(this.previews, this.hierarchy, this.hierarchyStacks, this.hierarchyNames, "", null, -1);
    }

    protected static void addPreviews(LittlePreviews previews, List<StructureHolder> hierarchy, List<ItemStack> stacks, List<String> lines, String prefix, LittlePreviews parent, int childId) {
        StructureHolder holder = new StructureHolder(parent, childId, hierarchy.size());
        holder.previews = previews;
        holder.prefix = prefix;
        lines.add(holder.getDisplayName());
        ItemStack stack = new ItemStack(LittleTiles.multiTiles);
        LittlePreviews newPreviews = new LittlePreviews(previews.context);
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        for (LittlePreview preview : previews) {
            newPreviews.addWithoutCheckingPreview(preview.copy());
            minX = Math.min(minX, preview.box.minX);
            minY = Math.min(minY, preview.box.minY);
            minZ = Math.min(minZ, preview.box.minZ);
            minX = Math.min(minX, preview.box.maxX);
            minY = Math.min(minY, preview.box.maxY);
            minZ = Math.min(minZ, preview.box.maxZ);
        }
        for (LittlePreview preview : newPreviews) {
            preview.box.sub(minX, minY, minZ);
        }
        LittlePreview.savePreview(newPreviews, stack);
        stacks.add(stack);
        holder.explicit = stack;
        hierarchy.add(holder);
        if (previews.hasChildren()) {
            int i = 0;
            for (LittlePreviews child : previews.getChildren()) {
                SubGuiRecipe.addPreviews(child, hierarchy, stacks, lines, prefix + "-", previews, i);
                ++i;
            }
        }
    }

    @Override
    public void onLoaded(AnimationPreview animationPreview) {
        this.onLoaded((GuiParent)this, animationPreview);
    }

    public void onLoaded(GuiParent parent, AnimationPreview animationPreview) {
        for (GuiControl control : parent.controls) {
            if (control instanceof IAnimationControl) {
                ((IAnimationControl)control).onLoaded(animationPreview);
            }
            if (!(control instanceof GuiParent)) continue;
            this.onLoaded((GuiParent)control, animationPreview);
        }
    }

    public void onTick() {
        super.onTick();
        if (this.loadingThread != null && this.loadingThread.result != null) {
            this.animationPreview = this.loadingThread.result;
            this.loadingThread = null;
            this.onLoaded(this.animationPreview);
            if (this.parser != null) {
                this.parser.onLoaded(this.animationPreview);
            }
        }
        if (this.animationPreview != null) {
            this.handler.tick(this.animationPreview.previews, this.animationPreview.animation.structure, this.animationPreview.animation);
        }
    }

    @Override
    public void saveConfiguration() {
    }

    public void createControls() {
        this.controls.add(new GuiComboBoxCategory("types", 0, 5, 90, this.craftables));
        this.controls.add(new GuiButton("clear", SubGuiRecipe.translate((String)"selection.clear"), 105, 176, 38){

            public void onClicked(int x, int y, int button) {
                SubGuiRecipe.this.openYesNoDialog(1.translate((String)"selection.dialog.clear"));
            }
        });
        this.controls.add(new GuiLabel("tilescount", "", 208, 158));
        this.controls.add(new GuiItemComboBox("hierarchy", 100, 5, 200, this.hierarchyNames, this.hierarchyStacks));
        this.controls.add(new GuiAnimationViewer("renderer", 208, 30, 136, 135));
        this.controls.add(new GuiIconButton("play", 248, 172, 10){

            public void onClicked(int x, int y, int button) {
                SubGuiRecipe.this.handler.play();
            }
        });
        this.controls.add(new GuiIconButton("pause", 268, 172, 9){

            public void onClicked(int x, int y, int button) {
                SubGuiRecipe.this.handler.pause();
            }
        });
        this.controls.add(new GuiIconButton("stop", 288, 172, 11){

            public void onClicked(int x, int y, int button) {
                SubGuiRecipe.this.handler.stop();
            }
        });
        this.controls.add(new GuiPanel("panel", 0, 30, 200, 135));
        this.controls.add(new GuiButton("save", 150, 176, 40){

            public void onClicked(int x, int y, int button) {
                SubGuiRecipe.this.savePreview();
                SubGuiRecipe.this.finializePreview(SubGuiRecipe.this.previews);
                SubGuiRecipe.this.stack.func_77982_d(new NBTTagCompound());
                LittlePreview.savePreview(SubGuiRecipe.this.previews, SubGuiRecipe.this.stack);
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74757_a("set_structure", true);
                nbt.func_74782_a("stack", (NBTBase)SubGuiRecipe.this.stack.func_77978_p());
                SubGuiRecipe.this.sendPacketToServer(nbt);
                SubGuiRecipe.this.closeGui();
            }
        });
        this.controls.add(new GuiTextfield("name", "", 2, 176, 95, 14).setCustomTooltip(new String[]{SubGuiRecipe.translate((String)"selection.structure.name")}));
        this.loadStack(this.hierarchy.get(0));
    }

    public void loadStack(StructureHolder holder) {
        this.selected = holder;
        this.animationPreview = null;
        LittlePreviews previews = holder.previews;
        LittleStructure structure = previews.getStructure();
        GuiComboBoxCategory comboBox = (GuiComboBoxCategory)this.get("types");
        this.structure = structure;
        int index = 0;
        for (Pair category : this.craftables) {
            int currentIndex = ((PairList)category.value).indexOfKey((Object)("structure." + (structure != null ? structure.type.id : "none") + ".name"));
            if (currentIndex != -1) {
                comboBox.select(currentIndex + index);
                break;
            }
            index += ((PairList)category.value).size();
        }
        GuiTextfield textfield = (GuiTextfield)this.get("name");
        textfield.text = structure != null && structure.name != null ? structure.name : "";
        textfield.setCursorPositionZero();
        int size = previews.totalSize();
        GuiLabel label = (GuiLabel)this.get("tilescount");
        label.caption = size + " " + SubGuiRecipe.translate((String)(size == 1 ? "selection.structure.tile" : "selection.structure.tiles"));
        label.width = GuiRenderHelper.instance.getStringWidth(label.caption) + label.getContentOffset() * 2;
        if (this.loadingThread != null && this.loadingThread.isAlive()) {
            this.loadingThread.stop();
        }
        this.loadingThread = new LoadingThread(previews);
        this.onStructureSelectorChanged();
    }

    public void onStructureSelectorChanged() {
        LittleStructure saved;
        GuiPanel panel = (GuiPanel)this.get("panel");
        panel.controls.clear();
        GuiComboBoxCategory types = (GuiComboBoxCategory)this.get("types");
        Pair selected = types.getSelected();
        if (this.parser != null) {
            this.removeListener(this.parser);
        }
        if ((saved = this.structure) != null && !((String)selected.key).equals("structure." + saved.type.id + ".name")) {
            saved = null;
        }
        this.parser = LittleStructureRegistry.getParser((GuiParent)panel, this.handler, (Class)selected.value);
        if (this.parser != null) {
            this.handler.setTimeline(null, null);
            this.parser.createControls(this.selected.previews, saved);
            panel.refreshControls();
            this.addListener(this.parser);
            if (this.animationPreview != null) {
                this.onLoaded((GuiParent)panel, this.animationPreview);
            }
        } else {
            this.parser = null;
        }
        this.get("name").setEnabled(this.parser != null);
    }

    public void finializePreview(LittlePreviews previews) {
        if (previews.hasStructure()) {
            previews.getStructure().finializePreview(previews);
        }
        if (previews.hasChildren()) {
            for (LittlePreviews child : previews.getChildren()) {
                this.finializePreview(child);
            }
        }
    }

    public void savePreview() {
        LittleStructure structure = null;
        LittlePreviews oldPreviews = this.selected.previews;
        if (this.parser != null) {
            GuiTextfield textfield = (GuiTextfield)this.get("name");
            structure = this.parser.parseStructure(oldPreviews);
            if (structure != null) {
                structure.name = textfield.text.isEmpty() ? null : textfield.text;
            }
            NBTTagCompound structureNBT = new NBTTagCompound();
            structure.writeToNBT(structureNBT);
            this.selected.previews = new LittlePreviewsStructure(structureNBT, oldPreviews.context);
        } else {
            this.selected.previews = new LittlePreviews(oldPreviews.context);
        }
        this.selected.previews.assign(oldPreviews);
        if (this.selected.parent != null) {
            this.selected.parent.updateChild(this.selected.childId, this.selected.previews);
        } else {
            this.previews = this.selected.previews;
        }
        this.hierarchyNames.set(this.selected.index, this.selected.getDisplayName());
    }

    @CustomEventSubscribe
    public void onComboChange(GuiControlChangedEvent event) {
        int index;
        if (event.source.is(new String[]{"types"})) {
            this.onStructureSelectorChanged();
        } else if (event.source.is(new String[]{"hierarchy"}) && (index = ((GuiItemComboBox)event.source).index) != this.selected.index) {
            this.savePreview();
            this.loadStack(this.hierarchy.get(index));
        }
    }

    public void onDialogClosed(String text, String[] buttons, String clicked) {
        if (clicked.equalsIgnoreCase("yes")) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74757_a("clear_content", true);
            this.sendPacketToServer(nbt);
        }
    }

    public void receiveContainerPacket(NBTTagCompound nbt) {
        if (nbt.func_82582_d()) {
            this.stack.func_77982_d(null);
        } else {
            this.stack.func_77982_d(nbt);
        }
    }

    public static class StructureHolder {
        public final LittlePreviews parent;
        public final int childId;
        public final int index;
        public String prefix;
        public ItemStack explicit;
        public LittlePreviews previews;

        public StructureHolder(LittlePreviews parent, int childId, int index) {
            this.parent = parent;
            this.childId = childId;
            this.index = index;
        }

        public String getDisplayName() {
            String name = this.previews.getStructureName();
            if (name == null) {
                name = this.previews.hasStructure() ? this.previews.getStructureId() : "none";
            }
            if (this.parent != null) {
                name = name + " " + this.childId;
            }
            return this.prefix + name;
        }
    }

    public static class LoadingThread
    extends Thread {
        public final LittlePreviews previews;
        public AnimationPreview result;

        public LoadingThread(LittlePreviews previews) {
            this.start();
            this.previews = previews;
        }

        @Override
        public void run() {
            this.result = new AnimationPreview(this.previews);
        }
    }
}

