/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render.cache;

import com.creativemd.creativecore.client.rendering.RenderCubeObject;
import com.creativemd.creativecore.client.rendering.model.BufferBuilderUtils;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.BlockRenderLayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BlockLayerRenderBuffer {
    private AtomicBoolean isDrawing = new AtomicBoolean(false);
    public final VertexFormat format;
    public final int bufferSizePerQuad;
    private BufferBuilder solid;
    private BufferBuilder cutout_mipped;
    private BufferBuilder cutout;
    private BufferBuilder translucent;

    public synchronized void setDrawing() throws RenderOverlapException {
        if (this.isDrawing.get()) {
            throw new RenderOverlapException();
        }
        this.isDrawing.set(true);
    }

    public synchronized void setFinishedDrawing() {
        this.isDrawing.set(false);
    }

    public synchronized boolean isDrawing() {
        return this.isDrawing.get();
    }

    public BlockLayerRenderBuffer() {
        this(DefaultVertexFormats.field_176600_a);
    }

    public BlockLayerRenderBuffer(VertexFormat format) {
        this.format = format;
        this.bufferSizePerQuad = format.func_177338_f();
    }

    public BufferBuilder createVertexBuffer(List<? extends RenderCubeObject> cubes) {
        int size = 1;
        for (RenderCubeObject renderCubeObject : cubes) {
            size += renderCubeObject.getQuads();
        }
        return new BufferBuilder(this.bufferSizePerQuad * size);
    }

    public BufferBuilder getBufferByLayer(BlockRenderLayer layer) {
        switch (layer) {
            case SOLID: {
                return this.solid;
            }
            case CUTOUT_MIPPED: {
                return this.cutout_mipped;
            }
            case CUTOUT: {
                return this.cutout;
            }
            case TRANSLUCENT: {
                return this.translucent;
            }
        }
        return null;
    }

    public void setBufferByLayer(BufferBuilder buffer, BlockRenderLayer layer) {
        switch (layer) {
            case SOLID: {
                this.solid = buffer;
                break;
            }
            case CUTOUT_MIPPED: {
                this.cutout_mipped = buffer;
                break;
            }
            case CUTOUT: {
                this.cutout = buffer;
                break;
            }
            case TRANSLUCENT: {
                this.translucent = buffer;
            }
        }
    }

    public boolean isEmpty() {
        return this.solid == null && this.cutout_mipped == null && this.cutout == null && this.translucent == null;
    }

    public void clear() {
        this.solid = null;
        this.cutout_mipped = null;
        this.cutout = null;
        this.translucent = null;
    }

    public void combine(BlockLayerRenderBuffer buffer) {
        this.solid = BlockLayerRenderBuffer.combine(this.solid, buffer.solid);
        this.cutout_mipped = BlockLayerRenderBuffer.combine(this.cutout_mipped, buffer.cutout_mipped);
        this.cutout = BlockLayerRenderBuffer.combine(this.cutout, buffer.cutout);
        this.translucent = BlockLayerRenderBuffer.combine(this.translucent, buffer.translucent);
    }

    public static BufferBuilder combine(BufferBuilder first, BufferBuilder second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        BufferBuilderUtils.growBufferSmall((BufferBuilder)first, (int)(first.func_178973_g().func_181719_f() * second.func_178989_h() * 4));
        BufferBuilderUtils.addBuffer((BufferBuilder)first, (BufferBuilder)second);
        return first;
    }

    public static class RenderOverlapException
    extends Exception {
        public RenderOverlapException() {
            super("Buffer is already rendering!");
        }
    }
}

