/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.action.block;

import com.creativemd.creativecore.common.utils.mc.WorldUtils;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.LittleActionInteract;
import com.creativemd.littletiles.common.action.block.LittleActionDestroyBoxes;
import com.creativemd.littletiles.common.action.block.LittleActionPlaceAbsolute;
import com.creativemd.littletiles.common.block.BlockTile;
import com.creativemd.littletiles.common.item.ItemLittleWrench;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleAbsoluteBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxes;
import com.creativemd.littletiles.common.tile.preview.LittleAbsolutePreviews;
import com.creativemd.littletiles.common.tile.preview.LittleAbsolutePreviewsStructure;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tileentity.TileList;
import com.creativemd.littletiles.common.util.ingredient.LittleInventory;
import com.creativemd.littletiles.common.util.place.PlacementMode;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class LittleActionDestroy
extends LittleActionInteract {
    public LittleAbsolutePreviews destroyedTiles;
    public StructurePreview structurePreview;

    public LittleActionDestroy(World world, BlockPos blockPos, EntityPlayer player) {
        super(world, blockPos, player);
    }

    public LittleActionDestroy() {
    }

    @Override
    public boolean canBeReverted() {
        return this.destroyedTiles != null || this.structurePreview != null;
    }

    @Override
    public LittleAction revert() {
        if (this.structurePreview != null) {
            return this.structurePreview.getPlaceAction();
        }
        this.destroyedTiles.convertToSmallest();
        return new LittleActionPlaceAbsolute(this.destroyedTiles, PlacementMode.normal);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean action(World world, TileEntityLittleTiles te, LittleTile tile, ItemStack stack, EntityPlayer player, RayTraceResult moving, BlockPos pos, boolean secondMode) throws LittleActionException {
        if (!world.field_72995_K) {
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, te.func_174877_v(), te.getBlockTileState(), player);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                LittleActionDestroy.sendBlockResetToClient(world, (EntityPlayerMP)player, te);
                return false;
            }
        }
        if (tile.isChildOfStructure()) {
            boolean loaded;
            boolean bl = loaded = tile.isConnectedToStructure() && tile.connection.getStructure(world).load() && tile.connection.getStructure(world).loadChildren();
            if (!loaded && !(player.func_184614_ca().func_77973_b() instanceof ItemLittleWrench)) throw new LittleActionException.StructureNotLoadedException();
            if (loaded) {
                this.structurePreview = new StructurePreview(tile.connection.getStructure(world));
                if (LittleActionDestroy.needIngredients(player) && !player.field_70170_p.field_72995_K) {
                    WorldUtils.dropItem((World)world, (ItemStack)tile.connection.getStructure(world).getStructureDrop(), (BlockPos)pos);
                }
                tile.te.updateTiles(x -> tile.destroy((TileList)x));
            } else if (secondMode) {
                ArrayList<LittleTile> toRemove = new ArrayList<LittleTile>();
                for (LittleTile teTile : tile.te) {
                    boolean teLoaded = teTile.isChildOfStructure() && teTile.isConnectedToStructure() && teTile.connection.getStructure(world).load() && teTile.connection.getStructure(world).loadChildren();
                    if (teLoaded) continue;
                    toRemove.add(teTile);
                }
                tile.te.updateTiles(x -> x.removeAll(toRemove));
            } else {
                tile.te.updateTiles(x -> x.remove(tile));
            }
        } else {
            LittleInventory inventory = new LittleInventory(player);
            this.destroyedTiles = new LittleAbsolutePreviews(pos, te.getContext());
            ArrayList<LittleTile> tiles = new ArrayList<LittleTile>();
            if (BlockTile.selectEntireBlock(player, secondMode)) {
                ArrayList<LittleTile> remains = new ArrayList<LittleTile>();
                for (LittleTile toDestory : te) {
                    if (!toDestory.isChildOfStructure()) {
                        this.destroyedTiles.addTile(toDestory);
                        tiles.add(toDestory);
                        continue;
                    }
                    remains.add(toDestory);
                }
                LittleActionDestroy.giveOrDrop(player, inventory, tiles);
                te.updateTiles(x -> {
                    x.clear();
                    x.addAll((Collection<? extends LittleTile>)remains);
                });
            } else {
                this.destroyedTiles.addTile(tile);
                LittleActionDestroy.checkAndGive(player, inventory, LittleActionDestroy.getIngredients(this.destroyedTiles));
                tile.te.updateTiles(x -> tile.destroy((TileList)x));
            }
        }
        world.func_184133_a((EntityPlayer)null, pos, tile.getSound().func_185845_c(), SoundCategory.BLOCKS, (tile.getSound().func_185843_a() + 1.0f) / 2.0f, tile.getSound().func_185847_b() * 0.8f);
        return true;
    }

    @Override
    protected boolean isRightClick() {
        return false;
    }

    @Override
    public LittleAction flip(EnumFacing.Axis axis, LittleAbsoluteBox box) {
        LittleBoxes boxes;
        if (this.structurePreview != null) {
            boxes = new LittleBoxes(this.structurePreview.previews.pos, this.structurePreview.previews.context);
            boxes.add(this.structurePreview.previews.get((int)0).box);
        } else if (this.destroyedTiles != null) {
            this.destroyedTiles.convertToSmallest();
            boxes = new LittleBoxes(this.blockPos, this.destroyedTiles.context);
            for (LittlePreview preview : this.destroyedTiles) {
                boxes.add(preview.box);
            }
        } else {
            return null;
        }
        boxes.flip(axis, box);
        return new LittleActionDestroyBoxes(boxes);
    }

    public static class StructurePreview {
        public LittleAbsolutePreviewsStructure previews;
        public boolean requiresItemStack;
        public LittleStructure structure;

        public StructurePreview(LittleStructure structure) {
            if (!structure.load()) {
                throw new RuntimeException("Structure is not loaded, can't create preview of it!");
            }
            this.previews = structure.getAbsolutePreviews(structure.getMainTile().te.func_174877_v());
            this.requiresItemStack = structure.canOnlyBePlacedByItemStack();
            this.structure = structure;
        }

        public LittleAction getPlaceAction() {
            if (this.requiresItemStack) {
                return new LittleActionPlaceAbsolute.LittleActionPlaceAbsolutePremade(this.previews, PlacementMode.all, false);
            }
            return new LittleActionPlaceAbsolute(this.previews, PlacementMode.all, false);
        }

        public int hashCode() {
            return this.previews.getStructureData().hashCode();
        }

        public boolean equals(Object paramObject) {
            if (paramObject instanceof StructurePreview) {
                return this.structure == ((StructurePreview)paramObject).structure;
            }
            if (paramObject instanceof LittleStructure) {
                return this.structure == paramObject;
            }
            return false;
        }
    }
}

