/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.api.block;

import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.mc.BlockUtils;
import com.creativemd.creativecore.common.utils.sorting.BlockSelector;
import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.creativecore.common.utils.type.PairList;
import com.creativemd.littletiles.common.api.block.ISpecialBlockHandler;
import com.creativemd.littletiles.common.entity.EntitySizedTNTPrimed;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tileentity.TileList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.BlockWorkbench;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;

public class SpecialBlockHandler {
    public static PairList<BlockSelector, ISpecialBlockHandler> specialHandlers = new PairList();
    public static final ISpecialBlockHandler EMPTY_HANDLER = new ISpecialBlockHandler(){};

    public static ISpecialBlockHandler getSpecialBlockHandler(Block block, int meta) {
        if (block instanceof ISpecialBlockHandler) {
            return (ISpecialBlockHandler)block;
        }
        for (Pair pair : specialHandlers) {
            if (!((BlockSelector)pair.key).is(block, meta)) continue;
            return (ISpecialBlockHandler)pair.value;
        }
        return EMPTY_HANDLER;
    }

    public static void registerSpecialHandler(Class<? extends Block> clazz, ISpecialBlockHandler handler) {
        SpecialBlockHandler.registerSpecialHandler((BlockSelector)new BlockSelector.BlockSelectorClass(new Class[]{clazz}), handler);
    }

    public static void registerSpecialHandler(Block block, int meta, ISpecialBlockHandler handler) {
        SpecialBlockHandler.registerSpecialHandler((BlockSelector)new BlockSelector.BlockSelectorState(block, meta), handler);
    }

    public static void registerSpecialHandler(Block block, ISpecialBlockHandler handler) {
        SpecialBlockHandler.registerSpecialHandler((BlockSelector)new BlockSelector.BlockSelectorBlock(block), handler);
    }

    public static void registerSpecialHandler(BlockSelector selector, ISpecialBlockHandler handler) {
        specialHandlers.add((Object)selector, (Object)handler);
    }

    static {
        SpecialBlockHandler.registerSpecialHandler(BlockTNT.class, new ISpecialBlockHandler(){

            @Override
            public boolean onBlockActivated(LittleTile tile, World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
                if (heldItem != null && (heldItem.func_77973_b() == Items.field_151033_d || heldItem.func_77973_b() == Items.field_151059_bz)) {
                    if (!worldIn.field_72995_K) {
                        this.explodeTile(tile, (EntityLivingBase)playerIn, false);
                    }
                    tile.te.updateTiles(x -> tile.destroy((TileList)x));
                    if (heldItem.func_77973_b() == Items.field_151033_d) {
                        heldItem.func_77972_a(1, (EntityLivingBase)playerIn);
                    } else if (!playerIn.field_71075_bZ.field_75098_d) {
                        heldItem.func_190918_g(1);
                    }
                    return true;
                }
                return false;
            }

            @Override
            public void onTileExplodes(LittleTile tile, Explosion explosion) {
                this.explodeTile(tile, explosion.func_94613_c(), true);
            }

            public void explodeTile(LittleTile tile, EntityLivingBase entity, boolean randomFuse) {
                BlockPos pos = tile.te.func_174877_v();
                LittleVec size = tile.box.getSize();
                LittleVec min = tile.box.getMinVec();
                EntitySizedTNTPrimed entitytntprimed = new EntitySizedTNTPrimed(tile.te.func_145831_w(), (double)pos.func_177958_n() + min.getPosX(tile.getContext()) + size.getPosX(tile.getContext()) / 2.0, (double)pos.func_177956_o() + min.getPosY(tile.getContext()) + size.getPosY(tile.getContext()) / 2.0, (double)pos.func_177952_p() + min.getPosZ(tile.getContext()) + size.getPosZ(tile.getContext()) / 2.0, entity, tile.getContext(), size);
                if (randomFuse) {
                    entitytntprimed.func_184534_a((short)(tile.te.func_145831_w().field_73012_v.nextInt(entitytntprimed.func_184536_l() / 4) + entitytntprimed.func_184536_l() / 8));
                }
                tile.te.func_145831_w().func_72838_d((Entity)entitytntprimed);
                tile.te.func_145831_w().func_184148_a((EntityPlayer)null, entitytntprimed.field_70165_t, entitytntprimed.field_70163_u, entitytntprimed.field_70161_v, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        });
        SpecialBlockHandler.registerSpecialHandler(Blocks.field_150462_ai, new ISpecialBlockHandler(){

            @Override
            public boolean onBlockActivated(LittleTile tile, final World worldIn, final BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
                if (worldIn.field_72995_K) {
                    return true;
                }
                playerIn.func_180468_a((IInteractionObject)new BlockWorkbench.InterfaceCraftingTable(worldIn, pos){

                    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
                        return new ContainerWorkbench(playerInventory, worldIn, pos){

                            public boolean func_75145_c(EntityPlayer playerIn) {
                                return true;
                            }
                        };
                    }
                });
                playerIn.func_71029_a(StatList.field_188062_ab);
                return true;
            }
        });
        SpecialBlockHandler.registerSpecialHandler((BlockSelector)new BlockSelector.BlockSelectorAnd(new BlockSelector[]{new BlockSelector.BlockSelectorClass(new Class[]{BlockLog.class}), new BlockSelector.BlockSelectorProperty(new IProperty[]{BlockLog.field_176299_a})}), new ISpecialBlockHandler(){

            public EnumFacing.Axis logAxisToNormal(BlockLog.EnumAxis axis) {
                switch (axis) {
                    case X: {
                        return EnumFacing.Axis.X;
                    }
                    case Y: {
                        return EnumFacing.Axis.Y;
                    }
                    case Z: {
                        return EnumFacing.Axis.Z;
                    }
                }
                return null;
            }

            @Override
            public void rotatePreview(Rotation rotation, LittlePreview preview, LittleVec doubledCenter) {
                IBlockState state = BlockUtils.getState((Block)preview.getBlock(), (int)preview.getMeta());
                EnumFacing.Axis axis = this.logAxisToNormal((BlockLog.EnumAxis)state.func_177229_b((IProperty)BlockLog.field_176299_a));
                if (axis != null) {
                    preview.getTileData().func_74778_a("block", preview.getBlockName() + ":" + preview.getBlock().func_176201_c(state.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.func_176870_a((EnumFacing.Axis)RotationUtils.rotate((EnumFacing.Axis)axis, (Rotation)rotation)))));
                }
            }
        });
        SpecialBlockHandler.registerSpecialHandler((BlockSelector)new BlockSelector.BlockSelectorAnd(new BlockSelector[]{new BlockSelector.BlockSelectorClass(new Class[]{BlockRotatedPillar.class}), new BlockSelector.BlockSelectorProperty(new IProperty[]{BlockRotatedPillar.field_176298_M})}), new ISpecialBlockHandler(){

            @Override
            public void rotatePreview(Rotation rotation, LittlePreview preview, LittleVec doubledCenter) {
                preview.getTileData().func_74768_a("meta", RotationUtils.rotate((EnumFacing.Axis)((EnumFacing.Axis)BlockUtils.getState((Block)preview.getBlock(), (int)preview.getMeta()).func_177229_b((IProperty)BlockRotatedPillar.field_176298_M)), (Rotation)rotation).ordinal());
            }
        });
    }
}

