/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.world.CreativeWorld;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.packet.LittleEntityRequestPacket;
import com.creativemd.littletiles.common.packet.LittleResetAnimationPacket;
import com.creativemd.littletiles.common.structure.IAnimatedStructure;
import com.creativemd.littletiles.common.structure.type.door.LittleDoor;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.identifier.LittleIdentifierAbsolute;
import com.creativemd.littletiles.common.world.WorldAnimationHandler;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleActivateDoorPacket
extends CreativeCorePacket {
    public LittleIdentifierAbsolute coord;
    public UUID worldUUID;
    public UUID uuid;
    public LittleDoor.DoorOpeningResult result;

    public LittleActivateDoorPacket(LittleTile tile, UUID uuid, LittleDoor.DoorOpeningResult result) {
        this.coord = new LittleIdentifierAbsolute(tile);
        this.uuid = uuid;
        this.result = result;
        if (tile.te.func_145831_w() instanceof CreativeWorld) {
            this.worldUUID = ((CreativeWorld)tile.te.func_145831_w()).parent.func_110124_au();
        }
    }

    public LittleActivateDoorPacket() {
    }

    public void writeBytes(ByteBuf buf) {
        LittleAction.writeAbsoluteCoord(this.coord, buf);
        LittleActivateDoorPacket.writeString((ByteBuf)buf, (String)this.uuid.toString());
        buf.writeBoolean(this.result.nbt != null);
        if (this.result.nbt != null) {
            LittleActivateDoorPacket.writeNBT((ByteBuf)buf, (NBTTagCompound)this.result.nbt);
        }
        if (this.worldUUID != null) {
            buf.writeBoolean(true);
            LittleActivateDoorPacket.writeString((ByteBuf)buf, (String)this.worldUUID.toString());
        } else {
            buf.writeBoolean(false);
        }
    }

    public void readBytes(ByteBuf buf) {
        this.coord = LittleAction.readAbsoluteCoord(buf);
        this.uuid = UUID.fromString(LittleActivateDoorPacket.readString((ByteBuf)buf));
        this.result = buf.readBoolean() ? new LittleDoor.DoorOpeningResult(LittleActivateDoorPacket.readNBT((ByteBuf)buf)) : LittleDoor.EMPTY_OPENING_RESULT;
        this.worldUUID = buf.readBoolean() ? UUID.fromString(LittleActivateDoorPacket.readString((ByteBuf)buf)) : null;
    }

    @SideOnly(value=Side.CLIENT)
    public void executeClient(EntityPlayer player) {
        World world = player.field_70170_p;
        if (this.worldUUID != null) {
            EntityAnimation animation = WorldAnimationHandler.findAnimation(true, this.worldUUID);
            if (animation == null) {
                return;
            }
            world = animation.fakeWorld;
        }
        try {
            LittleTile tile = LittleAction.getTile(world, this.coord);
            if (tile.isConnectedToStructure() && tile.connection.getStructure(tile.te.func_145831_w()) instanceof LittleDoor) {
                LittleDoor door = (LittleDoor)tile.connection.getStructureWithoutLoading();
                door.activate(null, tile, this.uuid, false);
            }
        }
        catch (LittleActionException e) {
            e.printStackTrace();
        }
    }

    public void executeServer(EntityPlayer player) {
        EntityAnimation animation = null;
        try {
            LittleTile tile;
            World world = player.field_70170_p;
            if (this.worldUUID != null) {
                animation = WorldAnimationHandler.findAnimation(false, this.worldUUID);
                if (animation == null) {
                    return;
                }
                world = animation.fakeWorld;
            }
            if ((tile = LittleAction.getTile(world, this.coord)).isConnectedToStructure() && tile.connection.getStructure(tile.te.func_145831_w()) instanceof LittleDoor) {
                LittleDoor door = (LittleDoor)tile.connection.getStructureWithoutLoading();
                LittleDoor.DoorActivationResult activationResult = door.activate(player, tile, this.uuid, true);
                if (activationResult == null) {
                    if (door instanceof IAnimatedStructure && ((IAnimatedStructure)((Object)door)).isAnimated()) {
                        PacketHandler.sendPacketToPlayer((CreativeCorePacket)new LittleEntityRequestPacket(((IAnimatedStructure)((Object)door)).getAnimation().func_110124_au(), ((IAnimatedStructure)((Object)door)).getAnimation().func_189511_e(new NBTTagCompound()), false), (EntityPlayerMP)((EntityPlayerMP)player));
                    } else {
                        PacketHandler.sendPacketToPlayer((CreativeCorePacket)new LittleResetAnimationPacket(this.uuid), (EntityPlayerMP)((EntityPlayerMP)player));
                        LittleAction.sendBlockResetToClient(world, (EntityPlayerMP)player, door);
                    }
                    return;
                }
                if (activationResult.animation != null && !activationResult.result.equals(this.result)) {
                    System.out.println("Different door opening results client: " + this.result + ", server: " + activationResult.result + ". Send animation data to " + player.getDisplayNameString());
                    PacketHandler.sendPacketToPlayer((CreativeCorePacket)new LittleEntityRequestPacket(activationResult.animation.func_110124_au(), activationResult.animation.func_189511_e(new NBTTagCompound()), false), (EntityPlayerMP)((EntityPlayerMP)player));
                }
            }
        }
        catch (LittleActionException e) {
            if (animation != null) {
                PacketHandler.sendPacketToPlayer((CreativeCorePacket)new LittleEntityRequestPacket(animation.func_110124_au(), animation.func_189511_e(new NBTTagCompound()), false), (EntityPlayerMP)((EntityPlayerMP)player));
            }
            PacketHandler.sendPacketToPlayer((CreativeCorePacket)new LittleResetAnimationPacket(this.uuid), (EntityPlayerMP)((EntityPlayerMP)player));
        }
    }
}

