/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.world.CreativeWorld;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.world.WorldAnimationHandler;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class LittleBlockUpdatePacket
extends CreativeCorePacket {
    public UUID uuid;
    public IBlockState state;
    public BlockPos pos;
    public SPacketUpdateTileEntity packet;

    public LittleBlockUpdatePacket(World world, BlockPos pos, @Nullable TileEntity te) {
        this.pos = pos;
        this.state = world.func_180495_p(pos);
        if (te != null) {
            this.packet = te.func_189518_D_();
        }
        if (world instanceof CreativeWorld) {
            this.uuid = ((CreativeWorld)world).parent.func_110124_au();
        }
    }

    public LittleBlockUpdatePacket() {
    }

    public void writeBytes(ByteBuf buf) {
        LittleBlockUpdatePacket.writePos((ByteBuf)buf, (BlockPos)this.pos);
        LittleBlockUpdatePacket.writeState((ByteBuf)buf, (IBlockState)this.state);
        if (this.packet != null) {
            buf.writeBoolean(true);
            LittleBlockUpdatePacket.writePacket((ByteBuf)buf, (Packet)this.packet);
        } else {
            buf.writeBoolean(false);
        }
        if (this.uuid != null) {
            buf.writeBoolean(true);
            LittleBlockUpdatePacket.writeString((ByteBuf)buf, (String)this.uuid.toString());
        } else {
            buf.writeBoolean(false);
        }
    }

    public void readBytes(ByteBuf buf) {
        this.pos = LittleBlockUpdatePacket.readPos((ByteBuf)buf);
        this.state = LittleBlockUpdatePacket.readState((ByteBuf)buf);
        if (buf.readBoolean()) {
            this.packet = (SPacketUpdateTileEntity)LittleBlockUpdatePacket.readPacket((ByteBuf)buf);
        }
        this.uuid = buf.readBoolean() ? UUID.fromString(LittleBlockUpdatePacket.readString((ByteBuf)buf)) : null;
    }

    public void executeClient(EntityPlayer player) {
        World world = player.field_70170_p;
        if (this.uuid != null) {
            EntityAnimation animation = WorldAnimationHandler.findAnimation(true, this.uuid);
            if (animation == null) {
                return;
            }
            world = animation.fakeWorld;
        }
        if (world instanceof WorldClient) {
            ((WorldClient)world).func_180503_b(this.pos, this.state);
        } else {
            world.func_180501_a(this.pos, this.state, 3);
        }
    }

    public void executeServer(EntityPlayer player) {
    }
}

