/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.world.WorldAnimationHandler;
import com.google.common.base.Predicate;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class LittleEntityRequestPacket
extends CreativeCorePacket {
    public UUID uuid;
    public NBTTagCompound nbt;
    public boolean enteredAsChild;

    public LittleEntityRequestPacket() {
    }

    public LittleEntityRequestPacket(UUID uuid, NBTTagCompound nbt, boolean enteredAsChild) {
        this.uuid = uuid;
        this.nbt = nbt;
        this.enteredAsChild = enteredAsChild;
    }

    public void writeBytes(ByteBuf buf) {
        LittleEntityRequestPacket.writeString((ByteBuf)buf, (String)this.uuid.toString());
        LittleEntityRequestPacket.writeNBT((ByteBuf)buf, (NBTTagCompound)this.nbt);
        buf.writeBoolean(this.enteredAsChild);
    }

    public void readBytes(ByteBuf buf) {
        this.uuid = UUID.fromString(LittleEntityRequestPacket.readString((ByteBuf)buf));
        this.nbt = LittleEntityRequestPacket.readNBT((ByteBuf)buf);
        this.enteredAsChild = buf.readBoolean();
    }

    public void executeClient(EntityPlayer player) {
        EntityAnimation animation = WorldAnimationHandler.findAnimation(true, this.uuid);
        if (animation != null) {
            this.updateAnimation(animation);
            return;
        }
        for (Entity entity : player.field_70170_p.func_175644_a(EntityAnimation.class, (Predicate)new Predicate<EntityAnimation>(){

            public boolean apply(EntityAnimation input) {
                return true;
            }
        })) {
            if (!(entity instanceof EntityAnimation) || !entity.func_110124_au().equals(this.uuid)) continue;
            animation = (EntityAnimation)entity;
            this.updateAnimation(animation);
            if (!animation.isDoorAdded()) {
                animation.addDoor();
            }
            return;
        }
        System.out.println("Entity not found!");
    }

    public void updateAnimation(EntityAnimation animation) {
        animation.field_70128_L = false;
        if (!this.enteredAsChild || animation.enteredAsChild != this.enteredAsChild) {
            animation.func_70020_e(this.nbt);
            animation.updateTickState();
        }
    }

    public void executeServer(EntityPlayer player) {
    }
}

