/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tileentity;

import com.creativemd.creativecore.common.tileentity.TileEntityCreative;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.creativecore.common.utils.mc.TickUtils;
import com.creativemd.creativecore.common.world.CreativeWorld;
import com.creativemd.creativecore.common.world.IOrientatedWorld;
import com.creativemd.littletiles.client.render.cache.BlockLayerRenderBuffer;
import com.creativemd.littletiles.client.render.cache.RenderCubeLayerCache;
import com.creativemd.littletiles.client.render.cache.RenderingThread;
import com.creativemd.littletiles.client.render.world.LittleChunkDispatcher;
import com.creativemd.littletiles.common.api.te.ILittleTileTE;
import com.creativemd.littletiles.common.block.BlockTile;
import com.creativemd.littletiles.common.mod.chiselsandbits.ChiselsAndBitsManager;
import com.creativemd.littletiles.common.mod.coloredlights.ColoredLightsManager;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.LittleTileColored;
import com.creativemd.littletiles.common.tile.combine.BasicCombiner;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.registry.LittleTileRegistry;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTilesRendered;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTilesTicking;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTilesTickingRendered;
import com.creativemd.littletiles.common.tileentity.TileList;
import com.creativemd.littletiles.common.util.compression.LittleNBTCompressionTools;
import com.creativemd.littletiles.common.util.grid.IGridBased;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.vec.LittleBlockTransformer;
import elucent.albedo.event.GatherLightsEvent;
import elucent.albedo.lighting.ILightProvider;
import elucent.albedo.lighting.Light;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="elucent.albedo.lighting.ILightProvider", modid="albedo")
public class TileEntityLittleTiles
extends TileEntityCreative
implements ILittleTileTE,
ILightProvider,
Iterable<LittleTile>,
IGridBased {
    protected TileList tiles;
    protected LittleGridContext context = LittleGridContext.getMin();
    private boolean hasLoaded = false;
    @SideOnly(value=Side.CLIENT)
    public int renderIndex;
    @SideOnly(value=Side.CLIENT)
    public boolean hasLightChanged;
    @SideOnly(value=Side.CLIENT)
    public boolean hasNeighbourChanged;
    public SideSolidCache sideCache = new SideSolidCache();
    @SideOnly(value=Side.CLIENT)
    public RenderChunk lastRenderedChunk;
    @SideOnly(value=Side.CLIENT)
    public BlockLayerRenderBuffer buffer;
    @SideOnly(value=Side.CLIENT)
    private RenderCubeLayerCache cubeCache;
    @SideOnly(value=Side.CLIENT)
    public AtomicBoolean inRenderingQueue;
    @SideOnly(value=Side.CLIENT)
    public boolean buildingCache;
    @SideOnly(value=Side.CLIENT)
    public boolean rebuildRenderingCache;
    @SideOnly(value=Side.CLIENT)
    private double cachedRenderDistance;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB cachedRenderBoundingBox;
    @SideOnly(value=Side.CLIENT)
    private boolean requireRenderingBoundingBoxUpdate;

    protected void assign(TileEntityLittleTiles te) {
        try {
            for (Field field : TileEntityLittleTiles.class.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                field.set(this, field.get(te));
            }
            for (LittleTile tile : this.tiles) {
                tile.te = this;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    private void init() {
        this.tiles = new TileList(this, this.isClientSide());
    }

    public void func_145834_a(World worldIn) {
        super.func_145834_a(worldIn);
        if (this.tiles == null) {
            this.init();
        }
    }

    protected void func_190201_b(World worldIn) {
        super.func_190201_b(worldIn);
        if (this.tiles == null) {
            this.init();
        }
    }

    @Override
    public Iterator<LittleTile> iterator() {
        return this.tiles.iterator();
    }

    public List<LittleTile> tickingTiles() {
        return this.tiles.tickingTiles();
    }

    @SideOnly(value=Side.CLIENT)
    public List<LittleTile> renderTiles() {
        return this.tiles.renderTiles();
    }

    @Override
    public LittleGridContext getContext() {
        return this.context;
    }

    @Override
    public void convertToSmallest() {
        int size = LittleGridContext.minSize;
        for (LittleTile tile : this.tiles) {
            size = Math.max(size, tile.getSmallestContext(this.context));
        }
        if (size < this.context.size) {
            this.convertTo(LittleGridContext.get(size));
        }
    }

    @Override
    public void convertTo(LittleGridContext newContext) {
        for (LittleTile tile : this.tiles) {
            tile.convertTo(this.context, newContext);
        }
        this.context = newContext;
    }

    public boolean contains(LittleTile tile) {
        return this.tiles.contains(tile);
    }

    public int size() {
        return this.tiles.size();
    }

    public boolean hasLoaded() {
        return this.hasLoaded;
    }

    public void setLoaded() {
        this.hasLoaded = true;
    }

    public boolean shouldCheckForCollision() {
        return this.tiles.checkCollision();
    }

    @SideOnly(value=Side.CLIENT)
    public void updateQuadCache(Object chunk) {
        if (chunk instanceof RenderChunk) {
            this.lastRenderedChunk = (RenderChunk)chunk;
        }
        if (this.renderIndex != LittleChunkDispatcher.currentRenderIndex) {
            this.getCubeCache().clearCache();
        }
        boolean doesNeedUpdate = this.getCubeCache().doesNeedUpdate() || this.hasNeighbourChanged || this.hasLightChanged;
        this.hasLightChanged = false;
        this.hasNeighbourChanged = false;
        if (doesNeedUpdate) {
            this.addToRenderUpdate();
        }
    }

    public RenderCubeLayerCache getCubeCache() {
        if (this.cubeCache == null) {
            this.cubeCache = new RenderCubeLayerCache();
        }
        return this.cubeCache;
    }

    public void updateLighting() {
        this.field_145850_b.func_175664_x(this.func_174877_v());
    }

    protected void customTilesUpdate() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean rendered = this.tiles.hasRendered();
        boolean ticking = this.tiles.hasTicking();
        if (ticking != this.isTicking() || rendered != this.isRendered()) {
            TileEntityLittleTiles newTe = rendered ? (ticking ? new TileEntityLittleTilesTickingRendered() : new TileEntityLittleTilesRendered()) : (ticking ? new TileEntityLittleTilesTicking() : new TileEntityLittleTiles());
            newTe.assign(this);
            this.field_145850_b.func_180501_a(this.field_174879_c, BlockTile.getState(ticking, rendered), 2);
            this.field_145850_b.func_175690_a(this.field_174879_c, (TileEntity)newTe);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void onNeighbourChangedClient() {
        this.addToRenderUpdate();
        this.hasNeighbourChanged = true;
    }

    public void onNeighbourChanged() {
        if (this.isClientSide()) {
            this.onNeighbourChangedClient();
        }
        this.notifyStructure();
    }

    public void notifyStructure() {
        for (LittleStructure structure : this.tiles.structures(4096)) {
            structure.neighbourChanged();
        }
    }

    public void updateTiles() {
        this.notifyStructure();
        this.sideCache.reset();
        if (this.field_145850_b != null) {
            this.updateBlock();
            this.updateNeighbour();
            this.updateLighting();
        }
        if (this.isClientSide()) {
            this.updateCustomRenderer();
        }
        if (!this.field_145850_b.field_72995_K && this.tiles.isEmpty()) {
            this.field_145850_b.func_175698_g(this.func_174877_v());
        }
        if (this.field_145850_b instanceof CreativeWorld) {
            ((CreativeWorld)this.field_145850_b).hasChanged = true;
        }
        this.customTilesUpdate();
    }

    public void updateTiles(Consumer<TileList> action) {
        action.accept(this.tiles);
        this.updateTiles();
    }

    public void updateTilesSecretly(Consumer<TileList> action) {
        action.accept(this.tiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    public void updateCustomRenderer() {
        this.updateRenderBoundingBox();
        this.updateRenderDistance();
        if (this.inRenderingQueue == null) {
            this.createRenderFields();
        }
        AtomicBoolean atomicBoolean = this.inRenderingQueue;
        synchronized (atomicBoolean) {
            if (!this.inRenderingQueue.get() || !this.buildingCache) {
                this.getCubeCache().clearCache();
            }
            this.addToRenderUpdate();
        }
    }

    private synchronized void createRenderFields() {
        this.inRenderingQueue = new AtomicBoolean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    public void addToRenderUpdate() {
        if (this.inRenderingQueue == null) {
            this.createRenderFields();
        }
        AtomicBoolean atomicBoolean = this.inRenderingQueue;
        synchronized (atomicBoolean) {
            if (this.inRenderingQueue.compareAndSet(false, true)) {
                RenderingThread.addCoordToUpdate(this);
            } else if (this.buildingCache) {
                this.rebuildRenderingCache = true;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void resetRenderingState() {
        this.inRenderingQueue.set(false);
        this.buildingCache = false;
        this.rebuildRenderingCache = false;
    }

    public boolean convertBlockToVanilla() {
        LittleTile firstTile = null;
        if (this.tiles.isEmpty()) {
            this.field_145850_b.func_175698_g(this.field_174879_c);
            return true;
        }
        if (this.field_145850_b instanceof IOrientatedWorld) {
            return false;
        }
        if (this.tiles.size() == 1) {
            if (!this.tiles.first().canBeConvertedToVanilla() || !this.tiles.first().doesFillEntireBlock()) {
                return false;
            }
            firstTile = this.tiles.first();
        } else {
            boolean[][][] filled = new boolean[this.context.size][this.context.size][this.context.size];
            for (LittleTile tile : this.tiles) {
                if (firstTile == null) {
                    if (tile.canBeConvertedToVanilla()) {
                        return false;
                    }
                    firstTile = tile;
                } else if (!firstTile.canBeCombined(tile) || !tile.canBeCombined(firstTile)) {
                    return false;
                }
                tile.fillInSpace(filled);
            }
            for (int x = 0; x < filled.length; ++x) {
                for (int y = 0; y < filled[x].length; ++y) {
                    for (int z = 0; z < filled[x][y].length; ++z) {
                        if (filled[x][y][z]) continue;
                        return false;
                    }
                }
            }
        }
        this.field_145850_b.func_175656_a(this.field_174879_c, firstTile.getBlockState());
        return true;
    }

    public boolean isBoxFilled(LittleBox box) {
        LittleVec size = box.getSize();
        boolean[][][] filled = new boolean[size.x][size.y][size.z];
        for (LittleTile tile : this.tiles) {
            tile.fillInSpace(box, filled);
        }
        for (int x = 0; x < filled.length; ++x) {
            for (int y = 0; y < filled[x].length; ++y) {
                for (int z = 0; z < filled[x][y].length; ++z) {
                    if (filled[x][y][z]) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void updateNeighbour() {
        this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q(), true);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 && this.tiles != null && this.tiles.hasRendered();
    }

    @SideOnly(value=Side.CLIENT)
    public void updateRenderDistance() {
        this.cachedRenderDistance = 0.0;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        if (this.cachedRenderDistance == 0.0) {
            double renderDistance = 262144.0;
            for (LittleTile tile : this.tiles.renderTiles()) {
                renderDistance = Math.max(renderDistance, tile.getMaxRenderDistanceSquared());
            }
            this.cachedRenderDistance = renderDistance;
        }
        return this.cachedRenderDistance;
    }

    public boolean hasFastRenderer() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateRenderBoundingBox() {
        this.requireRenderingBoundingBoxUpdate = true;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.requireRenderingBoundingBoxUpdate || this.cachedRenderBoundingBox == null) {
            double minX = Double.MAX_VALUE;
            double minY = Double.MAX_VALUE;
            double minZ = Double.MAX_VALUE;
            double maxX = -1.7976931348623157E308;
            double maxY = -1.7976931348623157E308;
            double maxZ = -1.7976931348623157E308;
            boolean found = false;
            for (LittleTile tile : this.tiles) {
                if (!tile.needCustomRendering()) continue;
                AxisAlignedBB box = tile.getRenderBoundingBox().func_186670_a(this.field_174879_c);
                minX = Math.min(box.field_72340_a, minX);
                minY = Math.min(box.field_72338_b, minY);
                minZ = Math.min(box.field_72339_c, minZ);
                maxX = Math.max(box.field_72336_d, maxX);
                maxY = Math.max(box.field_72337_e, maxY);
                maxZ = Math.max(box.field_72334_f, maxZ);
                found = true;
            }
            this.cachedRenderBoundingBox = found ? new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ) : new AxisAlignedBB(this.field_174879_c);
            this.requireRenderingBoundingBoxUpdate = false;
        }
        return this.cachedRenderBoundingBox;
    }

    public AxisAlignedBB getSelectionBox() {
        int minX = this.context.size;
        int minY = this.context.size;
        int minZ = this.context.size;
        int maxX = 0;
        int maxY = 0;
        int maxZ = 0;
        for (LittleTile tile : this.tiles) {
            LittleBox box = tile.getCompleteBox();
            minX = Math.min(box.minX, minX);
            minY = Math.min(box.minY, minY);
            minZ = Math.min(box.minZ, minZ);
            maxX = Math.max(box.maxX, maxX);
            maxY = Math.max(box.maxY, maxY);
            maxZ = Math.max(box.maxZ, maxZ);
        }
        return new LittleBox(minX, minY, minZ, maxX, maxY, maxZ).getBox(this.context, this.field_174879_c);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing facing, LittleBox.LittleTileFace face, LittleTile rendered) {
        face.ensureContext(this.context);
        for (LittleTile tile : this.tiles) {
            if (tile == rendered || !tile.doesProvideSolidFace(facing) && !tile.canBeRenderCombined(rendered)) continue;
            tile.fillFace(face);
        }
        return !face.isFilled();
    }

    public List<LittleBox> cutOut(LittleBox box, List<LittleBox> cutout) {
        ArrayList<LittleBox> cutting = new ArrayList<LittleBox>();
        for (LittleTile tile : this.tiles) {
            tile.getCuttingBoxes(cutting);
        }
        return box.cutOut(cutting, cutout);
    }

    public boolean isSpaceForLittleTileStructure(LittleBox box, Predicate<LittleTile> predicate) {
        for (LittleTile tile : this.tiles) {
            if (predicate != null && !predicate.test(tile) || !tile.isChildOfStructure() && tile.canBeSplitted() || !tile.intersectsWith(box)) continue;
            return false;
        }
        return true;
    }

    public boolean isSpaceForLittleTileStructure(LittleBox box) {
        return this.isSpaceForLittleTileStructure(box, null);
    }

    public boolean isSpaceForLittleTile(LittleBox box, Predicate<LittleTile> predicate) {
        for (LittleTile tile : this.tiles) {
            if (predicate != null && !predicate.test(tile) || !tile.intersectsWith(box)) continue;
            return false;
        }
        return true;
    }

    public boolean isSpaceForLittleTile(LittleBox box) {
        return this.isSpaceForLittleTile(box, null);
    }

    public boolean isSpaceForLittleTileIgnore(LittleBox box, LittleTile ignoreTile) {
        for (LittleTile tile : this.tiles) {
            if (ignoreTile == tile || !tile.intersectsWith(box)) continue;
            return false;
        }
        return true;
    }

    public LittleTile getIntersectingTile(LittleBox box, LittleTile ignoreTile) {
        for (LittleTile tile : this.tiles) {
            if (ignoreTile == tile || !tile.intersectsWith(box)) continue;
            return tile;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (this.tiles == null) {
            this.init();
        }
        if (!this.tiles.isEmpty()) {
            this.tiles.clear();
        }
        this.context = LittleGridContext.get(nbt);
        if (nbt.func_74764_b("tilesCount")) {
            int count = nbt.func_74762_e("tilesCount");
            for (int i = 0; i < count; ++i) {
                NBTTagCompound tileNBT = new NBTTagCompound();
                tileNBT = nbt.func_74775_l("t" + i);
                LittleTile tile = LittleTileRegistry.loadTile(this, this.field_145850_b, tileNBT);
                if (tile == null) continue;
                this.tiles.add(tile);
            }
        } else {
            this.tiles.addAll((Collection<? extends LittleTile>)LittleNBTCompressionTools.readTiles(nbt.func_150295_c("tiles", 10), this));
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.updateBlock();
            this.customTilesUpdate();
        }
        this.deleteTempWorld();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.context.set(nbt);
        nbt.func_74782_a("tiles", (NBTBase)LittleNBTCompressionTools.writeTiles(this.tiles));
        return nbt;
    }

    public void getDescriptionNBT(NBTTagCompound nbt) {
        this.context.set(nbt);
        int i = 0;
        for (LittleTile tile : this.tiles) {
            NBTTagCompound tileNBT = new NBTTagCompound();
            NBTTagCompound packet = new NBTTagCompound();
            tile.saveTile(tileNBT);
            if (tile.supportsUpdatePacket()) {
                if (tile.requiresCompleteUpdate()) {
                    tile.setCompleteUpdate(false);
                } else {
                    tileNBT.func_74782_a("update", (NBTBase)tile.getUpdateNBT());
                }
            }
            nbt.func_74782_a("t" + i, (NBTBase)tileNBT);
            ++i;
        }
        nbt.func_74768_a("tilesCount", this.tiles.size());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdatePacket(net, pkt.func_148857_g());
        super.onDataPacket(net, pkt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleUpdatePacket(NetworkManager net, NBTTagCompound nbt) {
        LittleGridContext context = LittleGridContext.get(nbt);
        if (context != this.context) {
            this.convertTo(context);
        }
        ArrayList<LittleTile> exstingTiles = new ArrayList<LittleTile>(this.tiles);
        ArrayList<LittleTile> tilesToAdd = new ArrayList<LittleTile>();
        int count = nbt.func_74762_e("tilesCount");
        for (int i = 0; i < count; ++i) {
            boolean isIdentical;
            NBTTagCompound tileNBT = new NBTTagCompound();
            tileNBT = nbt.func_74775_l("t" + i);
            LittleTile tile = null;
            if (tileNBT.func_74764_b("box")) {
                tile = this.getTile(this.getContext(), LittleBox.createBox(tileNBT.func_74759_k("box")).getIdentifier());
            }
            if (!exstingTiles.contains(tile)) {
                tile = null;
            }
            boolean bl = isIdentical = tile != null ? tile.isIdenticalToNBT(tileNBT) : false;
            if (isIdentical) {
                if (tile.supportsUpdatePacket() && tileNBT.func_74764_b("update")) {
                    tile.receivePacket(tileNBT.func_74775_l("update"), net);
                } else {
                    tile.loadTile(this, tileNBT);
                }
                exstingTiles.remove(tile);
                continue;
            }
            LittleStructure structure = null;
            LittleTile newTile = LittleTileRegistry.loadTile(this, this.field_145850_b, tileNBT);
            if (tile != null && tile.isConnectedToStructure()) {
                structure = tile.connection.getStructure(this.field_145850_b);
                structure.replace(tile, newTile);
            }
            tilesToAdd.add(newTile);
        }
        TileList tileList = this.tiles;
        synchronized (tileList) {
            this.tiles.removeAll(exstingTiles);
            this.tiles.addAll((Collection<? extends LittleTile>)tilesToAdd);
        }
        this.updateTiles();
    }

    public LittleTile getTile(LittleGridContext context, int[] identifier) {
        for (LittleTile tile : this.tiles) {
            if (!tile.is(context, identifier)) continue;
            return tile;
        }
        return null;
    }

    public RayTraceResult rayTrace(EntityPlayer player) {
        Object hit = null;
        Vec3d pos = player.func_174824_e(TickUtils.getPartialTickTime());
        double d0 = player.field_71075_bZ.field_75098_d ? 5.0 : 4.5;
        Vec3d look = player.func_70676_i(TickUtils.getPartialTickTime());
        Vec3d vec32 = pos.func_72441_c(look.field_72450_a * d0, look.field_72448_b * d0, look.field_72449_c * d0);
        return this.rayTrace(pos, vec32);
    }

    public RayTraceResult rayTrace(Vec3d pos, Vec3d look) {
        RayTraceResult hit = null;
        for (LittleTile tile : this.tiles) {
            RayTraceResult Temphit = tile.rayTrace(pos, look);
            if (Temphit == null || hit != null && !(hit.field_72307_f.func_72438_d(pos) > Temphit.field_72307_f.func_72438_d(pos))) continue;
            hit = Temphit;
        }
        return hit;
    }

    public LittleTile getFocusedTile(EntityPlayer player, float partialTickTime) {
        if (!this.isClientSide()) {
            return null;
        }
        Vec3d pos = player.func_174824_e(partialTickTime);
        double d0 = player.field_71075_bZ.field_75098_d ? 5.0 : 4.5;
        Vec3d look = player.func_70676_i(partialTickTime);
        Vec3d vec32 = pos.func_72441_c(look.field_72450_a * d0, look.field_72448_b * d0, look.field_72449_c * d0);
        if (this.field_145850_b != player.field_70170_p && this.field_145850_b instanceof CreativeWorld) {
            pos = ((CreativeWorld)this.field_145850_b).getOrigin().transformPointToFakeWorld(pos);
            vec32 = ((CreativeWorld)this.field_145850_b).getOrigin().transformPointToFakeWorld(vec32);
        }
        return this.getFocusedTile(pos, vec32);
    }

    public LittleTile getFocusedTile(Vec3d pos, Vec3d look) {
        LittleTile tileFocus = null;
        RayTraceResult hit = null;
        double distance = 0.0;
        for (LittleTile tile : this.tiles) {
            RayTraceResult Temphit = tile.rayTrace(pos, look);
            if (Temphit == null || hit != null && !(distance > Temphit.field_72307_f.func_72438_d(pos))) continue;
            distance = Temphit.field_72307_f.func_72438_d(pos);
            hit = Temphit;
            tileFocus = tile;
        }
        return tileFocus;
    }

    public void onLoad() {
        this.setLoaded();
    }

    public boolean isTicking() {
        return false;
    }

    public boolean isRendered() {
        return false;
    }

    public IBlockState getBlockTileState() {
        return BlockTile.getState(this);
    }

    public boolean combineTiles(LittleStructure structure) {
        boolean changed = BasicCombiner.combineTiles(this.tiles, structure);
        this.convertToSmallest();
        if (changed) {
            this.updateTiles();
        }
        return changed;
    }

    public boolean combineTiles() {
        boolean changed = BasicCombiner.combineTiles(this.tiles);
        this.convertToSmallest();
        if (changed) {
            this.updateTiles();
        }
        return changed;
    }

    @Override
    @Optional.Method(modid="chiselsandbits")
    public Object getVoxelBlob(boolean force) throws Exception {
        return ChiselsAndBitsManager.getVoxelBlob(this, force);
    }

    @Override
    @Nullable
    public IBlockState getState(AxisAlignedBB box, boolean realistic) {
        if (this.tiles == null) {
            return null;
        }
        if (realistic) {
            box = box.func_72321_a(0.0, -this.context.pixelSize, 0.0);
            for (LittleTile tile : this.tiles) {
                if (!tile.getSelectedBox(this.func_174877_v()).func_72326_a(box)) continue;
                return tile.getBlockState();
            }
            return null;
        }
        box = box.func_72321_a(0.0, -1.0, 0.0);
        LittleTile highest = null;
        for (LittleTile tile : this.tiles) {
            if (highest != null && tile.getMaxY() <= highest.getMaxY() || !tile.getSelectedBox(this.func_174877_v()).func_72326_a(box)) continue;
            highest = tile;
        }
        return highest != null ? highest.getBlockState() : null;
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="albedo")
    public void gatherLights(GatherLightsEvent event, Entity entity) {
        if (ColoredLightsManager.isInstalled()) {
            AxisAlignedBB box = null;
            int color = -1;
            for (LittleTile tile : this.tiles) {
                if (tile.getBlock() != ColoredLightsManager.getInvertedColorsBlock()) continue;
                int tileColor = ColoredLightsManager.getColorFromBlock(tile.getBlockState());
                if (tile instanceof LittleTileColored) {
                    tileColor = ColorUtils.blend((int)tileColor, (int)((LittleTileColored)tile).color);
                }
                if (box == null) {
                    box = tile.getCompleteBox().getBox(this.context, this.field_174879_c);
                    color = tileColor;
                    continue;
                }
                box = box.func_111270_a(tile.getCompleteBox().getBox(this.context, this.field_174879_c));
                color = ColorUtils.blend((int)color, (int)tileColor);
            }
            if (box != null) {
                event.add(new Light.Builder().pos(box.func_189972_c()).color(color, false).radius(15.0f).build());
            }
        }
    }

    public boolean isEmpty() {
        return this.tiles.isEmpty();
    }

    public LittleTile first() {
        return this.tiles.isEmpty() ? null : this.tiles.get(0);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.field_145850_b.field_72995_K) {
            this.tiles = null;
            this.buffer = null;
            this.cubeCache = null;
            this.sideCache = null;
            this.lastRenderedChunk = null;
            this.cachedRenderBoundingBox = null;
        }
    }

    public void func_189667_a(Rotation rotationIn) {
        LittleBlockTransformer.rotateTE(this, RotationUtils.getRotation((Rotation)rotationIn), RotationUtils.getRotationCount((Rotation)rotationIn), true);
        this.updateTiles();
    }

    public void func_189668_a(Mirror mirrorIn) {
        LittleBlockTransformer.flipTE(this, RotationUtils.getMirrorAxis((Mirror)mirrorIn), true);
        this.updateTiles();
    }

    public String toString() {
        return this.field_174879_c.toString();
    }

    public void tick() {
        for (LittleTile tile : this.tiles.tickingTiles()) {
            tile.updateEntity();
        }
        for (LittleStructure structure : this.tiles.structures(1024)) {
            structure.tick();
        }
    }

    public Iterable<LittleStructure> structures(int attribute) {
        return this.tiles.structures(attribute);
    }

    public class SideSolidCache {
        SideState DOWN;
        SideState UP;
        SideState NORTH;
        SideState SOUTH;
        SideState WEST;
        SideState EAST;

        public void reset() {
            this.DOWN = null;
            this.UP = null;
            this.NORTH = null;
            this.SOUTH = null;
            this.WEST = null;
            this.EAST = null;
        }

        protected SideState calculate(EnumFacing facing) {
            LittleBox box;
            switch (facing) {
                case EAST: {
                    box = new LittleBox(TileEntityLittleTiles.this.context.size - 1, 0, 0, TileEntityLittleTiles.this.context.size, TileEntityLittleTiles.this.context.size, TileEntityLittleTiles.this.context.size);
                    break;
                }
                case WEST: {
                    box = new LittleBox(0, 0, 0, 1, TileEntityLittleTiles.this.context.size, TileEntityLittleTiles.this.context.size);
                    break;
                }
                case UP: {
                    box = new LittleBox(0, TileEntityLittleTiles.this.context.size - 1, 0, TileEntityLittleTiles.this.context.size, TileEntityLittleTiles.this.context.size, TileEntityLittleTiles.this.context.size);
                    break;
                }
                case DOWN: {
                    box = new LittleBox(0, 0, 0, TileEntityLittleTiles.this.context.size, 1, TileEntityLittleTiles.this.context.size);
                    break;
                }
                case SOUTH: {
                    box = new LittleBox(0, 0, TileEntityLittleTiles.this.context.size - 1, TileEntityLittleTiles.this.context.size, TileEntityLittleTiles.this.context.size, TileEntityLittleTiles.this.context.size);
                    break;
                }
                case NORTH: {
                    box = new LittleBox(0, 0, 0, TileEntityLittleTiles.this.context.size, TileEntityLittleTiles.this.context.size, 1);
                    break;
                }
                default: {
                    box = null;
                }
            }
            return this.calculateState(facing, box);
        }

        protected SideState calculateState(EnumFacing facing, LittleBox box) {
            LittleVec size = box.getSize();
            boolean[][][] filled = new boolean[size.x][size.y][size.z];
            boolean translucent = false;
            boolean noclip = false;
            for (LittleTile tile : TileEntityLittleTiles.this.tiles) {
                if (!tile.fillInSpace(box, filled)) continue;
                if (!tile.doesProvideSolidFace(facing)) {
                    translucent = true;
                }
                if (!tile.hasNoCollision()) continue;
                noclip = true;
            }
            for (int x = 0; x < filled.length; ++x) {
                for (int y = 0; y < filled[x].length; ++y) {
                    for (int z = 0; z < filled[x][y].length; ++z) {
                        if (filled[x][y][z]) continue;
                        return SideState.EMPTY;
                    }
                }
            }
            return SideState.getState(false, noclip, translucent);
        }

        public SideState get(EnumFacing facing) {
            SideState result;
            switch (facing) {
                case DOWN: {
                    result = this.DOWN;
                    break;
                }
                case UP: {
                    result = this.UP;
                    break;
                }
                case NORTH: {
                    result = this.NORTH;
                    break;
                }
                case SOUTH: {
                    result = this.SOUTH;
                    break;
                }
                case WEST: {
                    result = this.WEST;
                    break;
                }
                case EAST: {
                    result = this.EAST;
                    break;
                }
                default: {
                    result = SideState.EMPTY;
                }
            }
            if (result == null) {
                result = this.calculate(facing);
                this.set(facing, result);
            }
            return result;
        }

        public void set(EnumFacing facing, SideState value) {
            switch (facing) {
                case DOWN: {
                    this.DOWN = value;
                    break;
                }
                case UP: {
                    this.UP = value;
                    break;
                }
                case NORTH: {
                    this.NORTH = value;
                    break;
                }
                case SOUTH: {
                    this.SOUTH = value;
                    break;
                }
                case WEST: {
                    this.WEST = value;
                    break;
                }
                case EAST: {
                    this.EAST = value;
                }
            }
        }
    }

    public static enum SideState {
        EMPTY{

            @Override
            public boolean doesBlockCollision() {
                return false;
            }

            @Override
            public boolean doesBlockLight() {
                return false;
            }

            @Override
            public boolean isFilled() {
                return false;
            }
        }
        ,
        SEETHROUGH{

            @Override
            public boolean doesBlockCollision() {
                return true;
            }

            @Override
            public boolean doesBlockLight() {
                return false;
            }

            @Override
            public boolean isFilled() {
                return true;
            }
        }
        ,
        NOCLIP{

            @Override
            public boolean doesBlockCollision() {
                return false;
            }

            @Override
            public boolean doesBlockLight() {
                return true;
            }

            @Override
            public boolean isFilled() {
                return true;
            }
        }
        ,
        SEETHROUGH_NOCLIP{

            @Override
            public boolean doesBlockCollision() {
                return false;
            }

            @Override
            public boolean doesBlockLight() {
                return false;
            }

            @Override
            public boolean isFilled() {
                return true;
            }
        }
        ,
        SOLID{

            @Override
            public boolean doesBlockCollision() {
                return true;
            }

            @Override
            public boolean doesBlockLight() {
                return true;
            }

            @Override
            public boolean isFilled() {
                return true;
            }
        };


        public abstract boolean isFilled();

        public abstract boolean doesBlockCollision();

        public abstract boolean doesBlockLight();

        public static SideState getState(boolean empty, boolean noclip, boolean translucent) {
            if (empty) {
                return EMPTY;
            }
            if (noclip && translucent) {
                return SEETHROUGH_NOCLIP;
            }
            if (noclip) {
                return NOCLIP;
            }
            if (translucent) {
                return SEETHROUGH;
            }
            return SOLID;
        }
    }
}

