/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.animation;

import com.creativemd.creativecore.common.gui.controls.gui.timeline.IAnimationHandler;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.relative.StructureAbsolute;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.util.animation.AnimationState;
import com.creativemd.littletiles.common.util.animation.AnimationTimeline;
import com.creativemd.littletiles.common.util.animation.event.AnimationEvent;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Vector3d;

public class AnimationGuiHandler
implements IAnimationHandler {
    public double offX;
    public double offY;
    public double offZ;
    public double rotX;
    public double rotY;
    public double rotZ;
    public int offset;
    private int setDuration = 0;
    private int lastTick = -1;
    private StructureAbsolute center = null;
    private boolean loop = true;
    private boolean playing = false;
    private int tick = 0;
    private AnimationTimeline timeline;
    private AnimationState state = new AnimationState();
    public List<AnimationGuiHolder> subHolders = new ArrayList<AnimationGuiHolder>();
    private List<AnimationEvent> events;
    private boolean eventsChanged = false;

    public AnimationGuiHandler(int offset, AnimationGuiHandler copy) {
        this.offset = offset;
        this.lastTick = copy.lastTick;
        this.loop = copy.loop;
        this.playing = copy.playing;
        this.tick = copy.tick;
    }

    public AnimationGuiHandler() {
    }

    public void takeInitialState(EntityAnimation animation) {
        this.offX = animation.initalOffX;
        this.offY = animation.initalOffY;
        this.offZ = animation.initalOffZ;
        this.rotX = animation.initalRotX;
        this.rotY = animation.initalRotY;
        this.rotZ = animation.initalRotZ;
    }

    public boolean hasTimeline() {
        return this.timeline != null;
    }

    public void setCenter(StructureAbsolute center) {
        this.center = center;
    }

    public void loop(boolean loop) {
        this.loop = loop;
        for (AnimationGuiHolder holder : this.subHolders) {
            holder.handler.loop(loop);
        }
    }

    public void play() {
        this.playing = true;
        for (AnimationGuiHolder holder : this.subHolders) {
            holder.handler.play();
        }
    }

    public void pause() {
        this.playing = false;
        for (AnimationGuiHolder holder : this.subHolders) {
            holder.handler.pause();
        }
    }

    public void stop() {
        this.playing = false;
        this.set(0);
        for (AnimationGuiHolder holder : this.subHolders) {
            holder.handler.stop();
        }
    }

    public void set(int tick) {
        this.tick = tick;
        for (AnimationGuiHolder holder : this.subHolders) {
            holder.handler.set(tick);
        }
    }

    public int get() {
        return this.tick;
    }

    public void tick(LittlePreviews previews, LittleStructure structure, EntityAnimation animation) {
        if (this.timeline == null) {
            return;
        }
        if (this.playing) {
            for (AnimationEvent event : this.events) {
                if (event.getTick() != this.tick) continue;
                event.runGui(this);
            }
            if (this.tick > this.timeline.duration) {
                if (this.loop) {
                    this.tick = 0;
                }
            } else {
                ++this.tick;
            }
        }
        if (this.center != null) {
            animation.setCenter(this.center);
            this.center = null;
        }
        boolean hasChanged = false;
        if (this.eventsChanged) {
            for (AnimationGuiHolder holder : this.subHolders) {
                holder.handler.stop();
                if (holder.animation == null) continue;
                holder.handler.updateTick(holder.animation);
                holder.handler.updateTick(holder.animation);
            }
            this.subHolders.clear();
            for (AnimationEvent event : this.events) {
                event.prepareInGui(previews, structure, animation, this);
            }
            hasChanged = true;
            this.eventsChanged = false;
        }
        for (AnimationGuiHolder holder : this.subHolders) {
            holder.handler.tick(holder.previews, holder.structure, holder.animation);
        }
        if (hasChanged) {
            this.updateTimeline();
        }
        if (animation != null) {
            this.updateTick(animation);
        }
    }

    public void updateTick(EntityAnimation animation) {
        animation.origin.tick();
        if (this.tick == this.lastTick) {
            return;
        }
        this.lastTick = this.tick;
        if (this.timeline != null) {
            this.timeline.tick(Math.min(this.tick, this.timeline.duration), this.state);
        } else {
            this.state.clear();
        }
        Vector3d offset = this.state.getOffset();
        Vector3d rotation = this.state.getRotation();
        animation.moveAndRotateAnimation(offset.x - animation.origin.offX() + this.offX, offset.y - animation.origin.offY() + this.offY, offset.z - animation.origin.offZ() + this.offZ, rotation.x - animation.origin.rotX() + this.rotX, rotation.y - animation.origin.rotY() + -this.rotY, rotation.z - animation.origin.rotZ() + this.rotZ);
    }

    public int getMaxDuration() {
        int duration = this.setDuration;
        for (AnimationGuiHolder holder : this.subHolders) {
            duration = Math.max(holder.handler.getMaxDuration(), duration);
        }
        return duration;
    }

    public void updateTimeline() {
        this.syncTimelineDuration(this.getMaxDuration());
    }

    public void syncTimelineDuration(int duration) {
        this.timeline.duration = duration;
        for (AnimationGuiHolder holder : this.subHolders) {
            holder.handler.syncTimelineDuration(duration);
        }
    }

    public void setTimeline(AnimationTimeline timeline, List<AnimationEvent> events) {
        this.timeline = timeline;
        if (this.timeline != null) {
            this.timeline.offset(this.offset);
            this.setDuration = this.timeline.duration;
            this.updateTimeline();
        } else {
            this.setDuration = 0;
        }
        this.state.clear();
        this.events = events == null ? new ArrayList<AnimationEvent>() : new ArrayList<AnimationEvent>(events);
        this.eventsChanged = true;
    }

    public static class AnimationGuiHolder {
        public final LittlePreviews previews;
        public final AnimationGuiHandler handler;
        public final LittleStructure structure;
        @Nullable
        public final EntityAnimation animation;

        public AnimationGuiHolder(LittlePreviews previews, AnimationGuiHandler handler, LittleStructure structure, @Nullable EntityAnimation animation) {
            this.previews = previews;
            this.handler = handler;
            this.structure = structure;
            this.animation = animation;
            if (animation != null) {
                handler.takeInitialState(animation);
            }
        }
    }
}

