/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.world;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.math.box.OrientatedBoundingBox;
import com.creativemd.creativecore.common.world.IOrientatedWorld;
import com.creativemd.littletiles.client.world.LittleAnimationHandlerClient;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.packet.LittleEntityRequestPacket;
import com.creativemd.littletiles.common.world.LittleAnimationHandler;
import com.creativemd.littletiles.server.world.LittleAnimationHandlerServer;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldAnimationHandler {
    @SideOnly(value=Side.CLIENT)
    public static LittleAnimationHandler client;
    public static LinkedHashMap<World, LittleAnimationHandler> worlds;
    private static Field wasPushedByDoor;

    @SideOnly(value=Side.CLIENT)
    private static void createClientHandler() {
        client = new LittleAnimationHandlerClient((World)Minecraft.func_71410_x().field_71441_e);
    }

    @SideOnly(value=Side.CLIENT)
    public static LittleAnimationHandler getHandlerClient() {
        if (client == null) {
            WorldAnimationHandler.createClientHandler();
        }
        return client;
    }

    public static LittleAnimationHandler getHandler(World world) {
        LittleAnimationHandler handler;
        if (world.field_72995_K) {
            return WorldAnimationHandler.getHandlerClient();
        }
        if (world instanceof IOrientatedWorld) {
            world = ((IOrientatedWorld)world).getRealWorld();
        }
        if ((handler = worlds.get(world)) == null) {
            handler = new LittleAnimationHandlerServer(world);
            worlds.put(world, handler);
        }
        return handler;
    }

    public static EntityAnimation findAnimation(boolean client, UUID uuid) {
        if (client) {
            return WorldAnimationHandler.findAnimationClient(uuid);
        }
        return WorldAnimationHandler.findAnimationServer(uuid);
    }

    @SideOnly(value=Side.CLIENT)
    public static EntityAnimation findAnimationClient(UUID uuid) {
        return WorldAnimationHandler.getHandlerClient().findAnimation(uuid);
    }

    public static EntityAnimation findAnimationServer(UUID uuid) {
        for (LittleAnimationHandler handler : worlds.values()) {
            EntityAnimation animation = handler.findAnimation(uuid);
            if (animation == null) continue;
            return animation;
        }
        return null;
    }

    @SubscribeEvent
    public static void unloadWorld(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            client = null;
        } else {
            worlds.remove(event.getWorld());
        }
    }

    @SubscribeEvent
    public static void trackEntity(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof EntityAnimation && ((EntityAnimation)event.getTarget()).controller.activator() != event.getEntityPlayer()) {
            EntityAnimation animation = (EntityAnimation)event.getTarget();
            PacketHandler.sendPacketToPlayer((CreativeCorePacket)new LittleEntityRequestPacket(animation.func_110124_au(), animation.func_189511_e(new NBTTagCompound()), animation.enteredAsChild), (EntityPlayerMP)((EntityPlayerMP)event.getEntityPlayer()));
        }
    }

    public static void setPushedByDoor(EntityPlayerMP player) {
        try {
            wasPushedByDoor.setInt(player, 10);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public static boolean checkIfEmpty(List<AxisAlignedBB> boxes, EntityPlayerMP player) {
        try {
            if (wasPushedByDoor.getInt(player) > 0) {
                return true;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        if (boxes.isEmpty()) {
            return true;
        }
        for (int i = 0; i < boxes.size(); ++i) {
            if (boxes.get(i) instanceof OrientatedBoundingBox) continue;
            return false;
        }
        return true;
    }

    static {
        worlds = new LinkedHashMap();
        wasPushedByDoor = ReflectionHelper.findField(EntityPlayerMP.class, (String[])new String[]{"wasPushedByDoor"});
    }
}

