/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.summoner.entity;

import java.util.UUID;
import net.daveyx0.multimob.entity.IMultiMob;
import net.daveyx0.multimob.entity.ai.EntityAIBackOffFromEntity;
import net.daveyx0.multimob.message.MMMessageRegistry;
import net.daveyx0.multimob.message.MessageMMParticle;
import net.daveyx0.multimob.util.EntityUtil;
import net.daveyx0.summoner.common.capabilities.CapabilitySummonableEntity;
import net.daveyx0.summoner.common.capabilities.ISummonableEntity;
import net.daveyx0.summoner.core.SummonGroup;
import net.daveyx0.summoner.core.SummonGroupRegistry;
import net.daveyx0.summoner.core.TheSummonerLootTables;
import net.daveyx0.summoner.entity.EntitySummoningIllager;
import net.daveyx0.summoner.entity.ai.EntityAINearestAttackableTargetExceptSummons;
import net.daveyx0.summoner.entity.ai.EntityAISummonFollowOwner;
import net.daveyx0.summoner.message.MessageSummonable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityVex;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntitySummoner
extends EntitySummoningIllager
implements IMultiMob {
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS).func_186741_a(true);
    private static final DataParameter<Boolean> IS_BOSS = EntityDataManager.func_187226_a(EntitySummoner.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> INVINSIBLE_TIMER = EntityDataManager.func_187226_a(EntitySummoner.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> WAVE = EntityDataManager.func_187226_a(EntitySummoner.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SHOULD_SPAWN_WAVE = EntityDataManager.func_187226_a(EntitySummoner.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntitySummoner(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.95f);
        this.field_70728_aV = 10;
        this.bossInfo.func_186758_d(false);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIBackOffFromEntity((EntityCreature)this, 9.0, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AISummonSpell());
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntitySummoner.class}));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTargetExceptSummons<EntityPlayer>((EntityCreature)this, EntityPlayer.class, true).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTargetExceptSummons<EntityVillager>((EntityCreature)this, EntityVillager.class, false).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, new EntityAINearestAttackableTargetExceptSummons<EntityIronGolem>((EntityCreature)this, EntityIronGolem.class, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(24.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(0.0);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.isInvinsible() && !this.isBoss()) {
            this.setInvinsibleTimer(this.getInvinsibleTimer() - 1);
        }
        if (this.isBoss() && !this.shouldSpawnWave() && this.field_70173_aa % 20 == 0 && !this.hasSummonedEntitiesLeft()) {
            this.setWave(this.getWave() + 1);
            if (this.getWave() >= SummonGroupRegistry.BOSSSUMMONGROUPS.size()) {
                this.setInvinsibleTimer(0);
                this.setSpawnWave(false);
                EnumParticleTypes particle = EnumParticleTypes.WATER_SPLASH;
                for (int i = 0; i < 8; ++i) {
                    float f = 0.01745278f;
                    double d = this.field_70165_t - Math.sin(this.field_70177_z * f) / 3.0;
                    double d1 = this.field_70163_u + this.field_70146_Z.nextDouble() / 3.0;
                    double d2 = this.field_70161_v + Math.cos(this.field_70177_z * f) / 3.0;
                    this.field_70170_p.func_175688_a(particle, d, d1 + 1.8, d2, 0.0, 0.0, 0.0, new int[0]);
                }
            } else {
                this.bossInfo.func_186758_d(true);
                this.func_70606_j(10 * SummonGroupRegistry.BOSSSUMMONGROUPS.size() - (this.getWave() - 1) * 10);
                this.setSpawnWave(true);
            }
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (hand == EnumHand.MAIN_HAND && itemstack.func_77973_b() == Items.field_151061_bv) {
            if (!player.func_184812_l_()) {
                itemstack.func_190918_g(1);
            }
            this.bossInfo.func_186758_d(true);
            this.setBoss(true);
            this.setInvinsibleTimer(1000);
            this.field_70728_aV = 100;
            this.setWave(1);
            this.setSpawnWave(true);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(10 * SummonGroupRegistry.BOSSSUMMONGROUPS.size()));
            this.func_70606_j(10 * SummonGroupRegistry.BOSSSUMMONGROUPS.size());
            this.func_184185_a(SoundEvents.field_187855_gD, 1.0f, 1.0f);
            MMMessageRegistry.getNetwork().sendToAll((IMessage)new MessageMMParticle(EnumParticleTypes.ENCHANTMENT_TABLE.func_179348_c(), 50, (float)this.field_70165_t + 0.5f, (float)this.field_70163_u + 0.5f, (float)this.field_70161_v + 0.5f, 0.0, 0.0, 0.0, 0));
        }
        return super.func_184645_a(player, hand);
    }

    public void setBossBarVisible(boolean b) {
        this.bossInfo.func_186758_d(b);
    }

    public boolean func_85031_j(Entity p_85031_1_) {
        if (this.isInvinsible()) {
            return false;
        }
        return super.func_85031_j(p_85031_1_);
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.isInvinsible()) {
            return false;
        }
        return super.func_70097_a(p_70097_1_, p_70097_2_);
    }

    public boolean func_184222_aU() {
        return !this.isBoss();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_BOSS, (Object)false);
        this.field_70180_af.func_187214_a(INVINSIBLE_TIMER, (Object)0);
        this.field_70180_af.func_187214_a(WAVE, (Object)0);
        this.field_70180_af.func_187214_a(SHOULD_SPAWN_WAVE, (Object)false);
    }

    public void setWave(int state) {
        this.field_70180_af.func_187227_b(WAVE, (Object)state);
    }

    public int getWave() {
        return (Integer)this.field_70180_af.func_187225_a(WAVE);
    }

    protected ResourceLocation func_184647_J() {
        if (this.isBoss()) {
            return TheSummonerLootTables.ENTITIES_SUMMONER_BOSS;
        }
        return TheSummonerLootTables.ENTITIES_SUMMONER;
    }

    @Override
    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    @Override
    protected SoundEvent getSpellSound() {
        return SoundEvents.field_191244_bn;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_191243_bm;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_191245_bo;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_191246_bp;
    }

    public boolean hasSummonedEntitiesLeft() {
        for (Entity entity : this.field_70170_p.field_72996_f) {
            ISummonableEntity summonable;
            if (!CapabilitySummonableEntity.EventHandler.isEntitySuitableForSummon(entity) || (summonable = (ISummonableEntity)EntityUtil.getCapability((Entity)entity, CapabilitySummonableEntity.SUMMONABLE_ENTITY_CAPABILITY, null)) == null || !summonable.isSummonedEntity() || !summonable.getSummonerId().equals(this.func_110124_au())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Wave", this.getWave());
        compound.func_74768_a("Invinsible", this.getInvinsibleTimer());
        compound.func_74757_a("Boss", this.isBoss());
        compound.func_74757_a("Spawn", this.shouldSpawnWave());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setWave(compound.func_74762_e("Wave"));
        this.setInvinsibleTimer(compound.func_74762_e("Invinsible"));
        this.setBoss(compound.func_74767_n("Boss"));
        this.setSpawnWave(compound.func_74767_n("Spawn"));
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public EntityLivingBase setBoss(boolean b) {
        this.field_70180_af.func_187227_b(IS_BOSS, (Object)b);
        return this;
    }

    public boolean isBoss() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_BOSS);
    }

    public void setInvinsibleTimer(int b) {
        this.field_70180_af.func_187227_b(INVINSIBLE_TIMER, (Object)b);
    }

    public void setSpawnWave(boolean b) {
        this.field_70180_af.func_187227_b(SHOULD_SPAWN_WAVE, (Object)b);
    }

    public boolean shouldSpawnWave() {
        return (Boolean)this.field_70180_af.func_187225_a(SHOULD_SPAWN_WAVE);
    }

    public int getInvinsibleTimer() {
        return (Integer)this.field_70180_af.func_187225_a(INVINSIBLE_TIMER);
    }

    public boolean isInvinsible() {
        return (Integer)this.field_70180_af.func_187225_a(INVINSIBLE_TIMER) > 0;
    }

    protected float func_70647_i() {
        if (this.isBoss()) {
            return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 0.5f;
        }
        return super.func_70647_i();
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    class AISummonSpell
    extends EntitySummoningIllager.AIUseSummon {
        private AISummonSpell() {
            super(EntitySummoner.this);
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            EntitySummoner.this.setInvinsibleTimer(200);
        }

        @Override
        public boolean func_75250_a() {
            if (EntitySummoner.this.isBoss() && !EntitySummoner.this.shouldSpawnWave()) {
                return false;
            }
            if (!super.func_75250_a()) {
                return false;
            }
            int i = EntitySummoner.this.field_70170_p.func_72872_a(EntityVex.class, EntitySummoner.this.func_174813_aQ().func_186662_g(16.0)).size();
            return EntitySummoner.this.field_70146_Z.nextInt(8) + 1 > i;
        }

        @Override
        protected int getCastingTime() {
            return 100;
        }

        @Override
        protected int getCastingInterval() {
            return 340;
        }

        @Override
        protected void castSpell() {
            SummonGroup group = this.getSummonGroup();
            for (int i = 0; i < group.getAmountToSummon(); ++i) {
                BlockPos blockpos = new BlockPos((Entity)EntitySummoner.this).func_177982_a(-2 + EntitySummoner.this.field_70146_Z.nextInt(5), 1, -2 + EntitySummoner.this.field_70146_Z.nextInt(5));
                EntityLiving entity = group.getEntityFromIndex(i, EntitySummoner.this.field_70170_p, (EntityLivingBase)EntitySummoner.this);
                entity.func_184221_a(UUID.randomUUID());
                if (entity == null) continue;
                entity.func_174828_a(blockpos, 0.0f, 0.0f);
                MMMessageRegistry.getNetwork().sendToAll((IMessage)new MessageMMParticle(EnumParticleTypes.ENCHANTMENT_TABLE.func_179348_c(), 50, (float)blockpos.func_177958_n() + 0.5f, (float)blockpos.func_177956_o() + 0.5f, (float)blockpos.func_177952_p() + 0.5f, 0.0, 0.0, 0.0, 0));
                EntitySummoner.this.field_70170_p.func_72838_d((Entity)entity);
                entity.func_96094_a(EntitySummoner.this.func_70005_c_() + "'s entity");
                if (EntityUtil.getCapability((Entity)entity, CapabilitySummonableEntity.SUMMONABLE_ENTITY_CAPABILITY, null) == null) continue;
                ISummonableEntity summonable = (ISummonableEntity)EntityUtil.getCapability((Entity)entity, CapabilitySummonableEntity.SUMMONABLE_ENTITY_CAPABILITY, null);
                summonable.setSummoner(EntitySummoner.this.func_110124_au());
                summonable.setSummonedEntity(true);
                summonable.setFollowing(true);
                if (EntitySummoner.this.isBoss()) {
                    summonable.setTimeLimit(-1);
                } else {
                    summonable.setTimeLimit(500);
                }
                MMMessageRegistry.getNetwork().sendToAllAround((IMessage)new MessageSummonable(entity.func_110124_au().toString(), summonable.getSummonerId().toString(), summonable.isFollowing(), summonable.getTimeLimit()), new NetworkRegistry.TargetPoint(EntitySummoner.this.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 255.0));
                CapabilitySummonableEntity.EventHandler.updateEntityTargetAI(entity);
                entity.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAISummonFollowOwner(entity, 1.2, 8.0f, 2.0f));
            }
            EntitySummoner.this.setSpawnWave(false);
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.field_191248_br;
        }

        @Override
        protected SummonGroup getSummonGroup() {
            if (EntitySummoner.this.isBoss()) {
                return SummonGroupRegistry.getBossGroupFromId(EntitySummoner.this.getWave());
            }
            return SummonGroupRegistry.getRandomGroup();
        }
    }
}

