/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.summoner.entity;

import javax.annotation.Nullable;
import net.daveyx0.multimob.util.EntityUtil;
import net.daveyx0.summoner.common.capabilities.CapabilitySummonableEntity;
import net.daveyx0.summoner.common.capabilities.ISummonableEntity;
import net.daveyx0.summoner.core.SummonGroup;
import net.daveyx0.summoner.core.SummonGroupRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.AbstractIllager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntitySummoningIllager
extends AbstractIllager {
    private static final DataParameter<Byte> SPELL = EntityDataManager.func_187226_a(EntitySummoningIllager.class, (DataSerializer)DataSerializers.field_187191_a);
    protected int spellTicks;
    private SummonGroup activeSpell = SummonGroupRegistry.getFromId(0);

    public EntitySummoningIllager(World p_i47506_1_) {
        super(p_i47506_1_);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SPELL, (Object)0);
    }

    public void func_70636_d() {
        super.func_70636_d();
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.spellTicks = compound.func_74762_e("SpellTicks");
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("SpellTicks", this.spellTicks);
    }

    @SideOnly(value=Side.CLIENT)
    public AbstractIllager.IllagerArmPose func_193077_p() {
        return this.isSpellcasting() ? AbstractIllager.IllagerArmPose.SPELLCASTING : AbstractIllager.IllagerArmPose.CROSSED;
    }

    public boolean isSpellcasting() {
        if (this.field_70170_p.field_72995_K) {
            return (Byte)this.field_70180_af.func_187225_a(SPELL) > 0;
        }
        return this.spellTicks > 0;
    }

    public void setSummonType(SummonGroup spellType) {
        this.activeSpell = spellType;
        this.field_70180_af.func_187227_b(SPELL, (Object)((byte)spellType.id));
    }

    protected SummonGroup getSummonType() {
        return !this.field_70170_p.field_72995_K ? this.activeSpell : SummonGroupRegistry.getFromId(((Byte)this.field_70180_af.func_187225_a(SPELL)).byteValue());
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.spellTicks > 0) {
            --this.spellTicks;
            if (this.spellTicks <= 0) {
                this.setSummonType(SummonGroupRegistry.getFromId(0));
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.isSpellcasting()) {
            SummonGroup entityspellcasterillager$spelltype = this.getSummonType();
            double d0 = entityspellcasterillager$spelltype.particleSpeed[0];
            double d1 = entityspellcasterillager$spelltype.particleSpeed[1];
            double d2 = entityspellcasterillager$spelltype.particleSpeed[2];
            float f = this.field_70761_aq * ((float)Math.PI / 180) + MathHelper.func_76134_b((float)((float)this.field_70173_aa * 0.6662f)) * 0.25f;
            float f1 = MathHelper.func_76134_b((float)f);
            float f2 = MathHelper.func_76126_a((float)f);
            this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t + (double)f1 * 0.6, this.field_70163_u + 1.8, this.field_70161_v + (double)f2 * 0.6, d0, d1, d2, new int[0]);
            this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t - (double)f1 * 0.6, this.field_70163_u + 1.8, this.field_70161_v - (double)f2 * 0.6, d0, d1, d2, new int[0]);
        }
    }

    protected int getSpellTicks() {
        return this.spellTicks;
    }

    protected abstract SoundEvent getSpellSound();

    public abstract class AIUseSummon
    extends EntityAIBase {
        protected int spellWarmup;
        protected int spellCooldown;
        protected int maxAmountOfSummons = 6;

        public boolean func_75250_a() {
            if (EntitySummoningIllager.this.func_70638_az() == null) {
                return false;
            }
            if (EntitySummoningIllager.this.isSpellcasting()) {
                return false;
            }
            if (EntitySummoningIllager.this.field_70173_aa >= this.spellCooldown) {
                int currentSummonAmount = 0;
                for (Entity entity : EntitySummoningIllager.this.field_70170_p.field_72996_f) {
                    ISummonableEntity summonable;
                    if (!CapabilitySummonableEntity.EventHandler.isEntitySuitableForSummon(entity) || (summonable = (ISummonableEntity)EntityUtil.getCapability((Entity)entity, CapabilitySummonableEntity.SUMMONABLE_ENTITY_CAPABILITY, null)) == null || !summonable.isSummonedEntity() || !summonable.getSummonerId().equals(EntitySummoningIllager.this.func_110124_au()) || ++currentSummonAmount <= this.maxAmountOfSummons) continue;
                    this.spellCooldown = EntitySummoningIllager.this.field_70173_aa + this.getCastingInterval();
                    return false;
                }
                return true;
            }
            return false;
        }

        public boolean func_75253_b() {
            return EntitySummoningIllager.this.func_70638_az() != null && this.spellWarmup > 0;
        }

        public void func_75249_e() {
            this.spellWarmup = this.getCastWarmupTime();
            EntitySummoningIllager.this.spellTicks = this.getCastingTime();
            this.spellCooldown = EntitySummoningIllager.this.field_70173_aa + this.getCastingInterval();
            SoundEvent soundevent = this.getSpellPrepareSound();
            if (soundevent != null) {
                EntitySummoningIllager.this.func_184185_a(soundevent, 1.0f, 1.0f);
            }
            EntitySummoningIllager.this.setSummonType(this.getSummonGroup());
        }

        public void func_75246_d() {
            --this.spellWarmup;
            if (this.spellWarmup == 0) {
                this.castSpell();
                EntitySummoningIllager.this.func_184185_a(EntitySummoningIllager.this.getSpellSound(), 1.0f, 1.0f);
            }
        }

        protected abstract void castSpell();

        protected int getCastWarmupTime() {
            return 20;
        }

        protected abstract int getCastingTime();

        protected abstract int getCastingInterval();

        @Nullable
        protected abstract SoundEvent getSpellPrepareSound();

        protected abstract SummonGroup getSummonGroup();
    }

    public class AICastingApell
    extends EntityAIBase {
        public AICastingApell() {
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            return EntitySummoningIllager.this.getSpellTicks() > 0;
        }

        public void func_75249_e() {
            super.func_75249_e();
            EntitySummoningIllager.this.field_70699_by.func_75499_g();
        }

        public void func_75251_c() {
            super.func_75251_c();
            EntitySummoningIllager.this.setSummonType(SummonGroupRegistry.getFromId(0));
        }

        public void func_75246_d() {
            if (EntitySummoningIllager.this.func_70638_az() != null) {
                EntitySummoningIllager.this.func_70671_ap().func_75651_a((Entity)EntitySummoningIllager.this.func_70638_az(), (float)EntitySummoningIllager.this.func_184649_cE(), (float)EntitySummoningIllager.this.func_70646_bf());
            }
        }
    }
}

