/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.summoner.item;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.daveyx0.multimob.message.MMMessageRegistry;
import net.daveyx0.multimob.message.MessageMMParticle;
import net.daveyx0.multimob.util.EntityUtil;
import net.daveyx0.summoner.common.capabilities.CapabilitySummonableEntity;
import net.daveyx0.summoner.common.capabilities.ISummonableEntity;
import net.daveyx0.summoner.entity.ai.EntityAISummonFollowOwner;
import net.daveyx0.summoner.message.MessageSummonable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSummonerOrb
extends Item {
    public int type = 0;

    public ItemSummonerOrb(String itemName, int type) {
        this.func_77625_d(1);
        this.func_77656_e(64);
        ItemSummonerOrb.setItemName(this, itemName);
        this.func_77637_a(CreativeTabs.field_78026_f);
        this.type = type;
    }

    public static void setItemName(Item item, String itemName) {
        item.setRegistryName(itemName);
        item.func_77655_b(item.getRegistryName().toString());
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b() == Items.field_151079_bi;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        NBTTagCompound nbttagcompound;
        if (this.type == 1) {
            tooltip.add("\u00a71Increased Durability");
            tooltip.add("\u00a71No Summon Time Limit");
        }
        if ((nbttagcompound = stack.func_77978_p()) != null && nbttagcompound.func_74764_b("EntityName")) {
            if (nbttagcompound.func_74779_i("EntityName") != null && !nbttagcompound.func_74779_i("EntityName").isEmpty()) {
                tooltip.add("Name: " + nbttagcompound.func_74779_i("EntityName"));
                ResourceLocation registryName = new ResourceLocation(nbttagcompound.func_74779_i("RegistryNameDomain"), nbttagcompound.func_74779_i("RegistryNamePath"));
                tooltip.add("Type: " + registryName.toString());
            } else {
                tooltip.add("empty");
            }
        } else {
            tooltip.add("empty");
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        NBTTagCompound nbttagcompound = player.func_184614_ca().func_77978_p();
        EntityLiving summonedEntity = ItemSummonerOrb.getEntityWithData(nbttagcompound, worldIn, (EntityLivingBase)player);
        if (summonedEntity != null) {
            summonedEntity.func_184221_a(UUID.randomUUID());
            if (!worldIn.field_72995_K) {
                summonedEntity.func_70012_b((double)pos.func_177958_n(), (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p(), player.field_70177_z, player.field_70125_A);
                summonedEntity.func_70034_d(player.field_70759_as);
                MMMessageRegistry.getNetwork().sendToAll((IMessage)new MessageMMParticle(EnumParticleTypes.ENCHANTMENT_TABLE.func_179348_c(), 50, (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f, 0.0, 0.0, 0.0, 0));
                worldIn.func_72838_d((Entity)summonedEntity);
                if (this.type == 1) {
                    player.func_184614_ca().func_77972_a(2, (EntityLivingBase)player);
                } else {
                    player.func_184614_ca().func_77972_a(8, (EntityLivingBase)player);
                }
                summonedEntity.func_96094_a(player.func_70005_c_() + "'s " + player.func_184614_ca().func_77978_p().func_74779_i("EntityName"));
                if (EntityUtil.getCapability((Entity)summonedEntity, CapabilitySummonableEntity.SUMMONABLE_ENTITY_CAPABILITY, null) != null) {
                    ISummonableEntity summonable = (ISummonableEntity)EntityUtil.getCapability((Entity)summonedEntity, CapabilitySummonableEntity.SUMMONABLE_ENTITY_CAPABILITY, null);
                    summonable.setSummoner(player.func_110124_au());
                    summonable.setSummonedEntity(true);
                    summonable.setFollowing(true);
                    if (this.type == 1) {
                        summonable.setTimeLimit(-1);
                    } else {
                        summonable.setTimeLimit(2000);
                    }
                    MMMessageRegistry.getNetwork().sendToAllAround((IMessage)new MessageSummonable(summonedEntity.func_110124_au().toString(), summonable.getSummonerId().toString(), summonable.isFollowing(), summonable.getTimeLimit()), new NetworkRegistry.TargetPoint(player.field_71093_bK, summonedEntity.field_70165_t, summonedEntity.field_70163_u, summonedEntity.field_70161_v, 255.0));
                    CapabilitySummonableEntity.EventHandler.updateEntityTargetAI(summonedEntity);
                    summonedEntity.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAISummonFollowOwner(summonedEntity, 1.2, 8.0f, 2.0f));
                }
            }
            summonedEntity.func_184185_a(SoundEvents.field_191244_bn, 1.0f, 1.0f);
            ItemSummonerOrb.setEntityData(player.func_184614_ca(), null, player);
            return EnumActionResult.PASS;
        }
        return EnumActionResult.PASS;
    }

    public static EntityLiving getEntityWithData(NBTTagCompound nbttagcompound, World world, EntityLivingBase owner) {
        ResourceLocation registryName;
        if (nbttagcompound == null) {
            return null;
        }
        EntityLiving entityLiving = null;
        if (nbttagcompound.func_74764_b("RegistryNameDomain") && ForgeRegistries.ENTITIES.containsKey(registryName = new ResourceLocation(nbttagcompound.func_74779_i("RegistryNameDomain"), nbttagcompound.func_74779_i("RegistryNamePath")))) {
            EntityEntry entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(registryName);
            try {
                entityLiving = (EntityLiving)entry.getEntityClass().getConstructor(World.class).newInstance(world);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (entityLiving != null) {
            nbttagcompound.func_74778_a("Owner", owner.func_110124_au().toString());
            nbttagcompound.func_74778_a("OwnerUUID", owner.func_110124_au().toString());
            nbttagcompound.func_74757_a("Tame", true);
            nbttagcompound.func_74757_a("Tamed", true);
            entityLiving.func_70020_e(nbttagcompound);
        }
        return entityLiving;
    }

    public static void setEntityData(ItemStack stack, EntityLiving entity, EntityPlayer player) {
        if (entity == null) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            stack.func_77982_d(nbttagcompound);
        } else if (EntityRegistry.getEntry(entity.getClass()) != null) {
            NBTTagCompound nbttagcompound = entity.func_189511_e(new NBTTagCompound());
            nbttagcompound.func_74757_a("PersistenceRequired", true);
            nbttagcompound.func_82580_o("Dimension");
            nbttagcompound.func_82580_o("Pos");
            nbttagcompound.func_82580_o("Motion");
            nbttagcompound.func_82580_o("Rotation");
            nbttagcompound.func_82580_o("FallDistance");
            nbttagcompound.func_82580_o("Fire");
            nbttagcompound.func_82580_o("NoAI");
            if (entity.func_110143_aJ() < entity.func_110138_aP()) {
                nbttagcompound.func_82580_o("Health");
            }
            nbttagcompound.func_82580_o("HurtTime");
            nbttagcompound.func_82580_o("HurtByTimestamp");
            nbttagcompound.func_82580_o("DeathTime");
            nbttagcompound.func_74778_a("RegistryNameDomain", EntityRegistry.getEntry(entity.getClass()).getRegistryName().func_110624_b());
            nbttagcompound.func_74778_a("RegistryNamePath", EntityRegistry.getEntry(entity.getClass()).getRegistryName().func_110623_a());
            if (EntityRegistry.getEntry(entity.getClass()).getEgg() != null && EntityRegistry.getEntry(entity.getClass()).getEgg().field_75611_b != 0) {
                NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("display");
                if (!nbttagcompound.func_150297_b("display", 10)) {
                    nbttagcompound.func_74782_a("display", (NBTBase)nbttagcompound1);
                }
                nbttagcompound1.func_74768_a("color", EntityRegistry.getEntry(entity.getClass()).getEgg().field_75611_b);
            }
            String name = entity.func_70005_c_();
            String message = "";
            if (name.contains("'s ")) {
                String[] names = name.split("'s ");
                name = names[1];
                message = "Spirit Returned: " + name;
            } else {
                message = "Spirit Captured: " + name;
            }
            nbttagcompound.func_74778_a("EntityName", name);
            if (!player.func_130014_f_().field_72995_K) {
                player.func_146105_b((ITextComponent)new TextComponentString(message), false);
            }
            nbttagcompound.func_186854_a("UUID", UUID.randomUUID());
            if (nbttagcompound.func_74764_b("ForgeData")) {
                ArrayList<String> keysToRemove = new ArrayList<String>();
                NBTTagCompound customEntityData = nbttagcompound.func_74775_l("ForgeData");
                for (String string : customEntityData.func_150296_c()) {
                    if (!string.contains("Potion Core")) continue;
                    keysToRemove.add(string);
                }
                if (keysToRemove != null && !keysToRemove.isEmpty()) {
                    for (String key : keysToRemove) {
                        customEntityData.func_82580_o(key);
                    }
                }
            }
            stack.func_77982_d(nbttagcompound);
        } else {
            return;
        }
    }

    public static int getIdForAttributeFromMod(NBTTagList tagList, String string) {
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound nbt = tagList.func_150305_b(i);
            if (!nbt.func_74779_i("Name").contains(string)) continue;
            return i;
        }
        return -1;
    }

    public static NBTTagCompound getEntityNBT(EntityLiving entity) {
        if (entity != null && EntityRegistry.getEntry(entity.getClass()) != null) {
            NBTTagCompound nbttagcompound = entity.func_189511_e(new NBTTagCompound());
            nbttagcompound.func_74757_a("PersistenceRequired", true);
            nbttagcompound.func_82580_o("Dimension");
            nbttagcompound.func_82580_o("Pos");
            nbttagcompound.func_82580_o("Motion");
            nbttagcompound.func_82580_o("Rotation");
            nbttagcompound.func_82580_o("FallDistance");
            nbttagcompound.func_82580_o("Fire");
            nbttagcompound.func_82580_o("UUID");
            nbttagcompound.func_82580_o("NoAI");
            nbttagcompound.func_82580_o("HurtTime");
            nbttagcompound.func_82580_o("HurtByTimestamp");
            nbttagcompound.func_82580_o("DeathTime");
            nbttagcompound.func_74778_a("RegistryNameDomain", EntityRegistry.getEntry(entity.getClass()).getRegistryName().func_110624_b());
            nbttagcompound.func_74778_a("RegistryNamePath", EntityRegistry.getEntry(entity.getClass()).getRegistryName().func_110623_a());
            return nbttagcompound;
        }
        return new NBTTagCompound();
    }

    public static NBTTagCompound getEntityNBT(String resourceDomain, String resourcePath) {
        ResourceLocation registryName = new ResourceLocation(resourceDomain, resourcePath);
        EntityEntry entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(registryName);
        if (entry != null) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74757_a("PersistenceRequired", true);
            nbttagcompound.func_82580_o("Dimension");
            nbttagcompound.func_82580_o("Pos");
            nbttagcompound.func_82580_o("Motion");
            nbttagcompound.func_82580_o("Rotation");
            nbttagcompound.func_82580_o("FallDistance");
            nbttagcompound.func_82580_o("Fire");
            nbttagcompound.func_82580_o("UUID");
            nbttagcompound.func_82580_o("NoAI");
            nbttagcompound.func_82580_o("HurtTime");
            nbttagcompound.func_82580_o("HurtByTimestamp");
            nbttagcompound.func_82580_o("DeathTime");
            nbttagcompound.func_74778_a("RegistryNameDomain", resourceDomain);
            nbttagcompound.func_74778_a("RegistryNamePath", resourcePath);
            return nbttagcompound;
        }
        return new NBTTagCompound();
    }

    public static int getColor(ItemStack stack) {
        NBTTagCompound nbttagcompound1;
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound != null && (nbttagcompound1 = nbttagcompound.func_74775_l("display")) != null && nbttagcompound1.func_150297_b("color", 3)) {
            return nbttagcompound1.func_74762_e("color");
        }
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.type == 1;
    }
}

