/*
 * Decompiled with CFR 0.152.
 */
package com.elseytd.theaurorian.Entities.Hostile;

import com.elseytd.theaurorian.TAConfig;
import com.elseytd.theaurorian.TAItems;
import com.elseytd.theaurorian.TAParticles;
import com.elseytd.theaurorian.TAUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFindEntityNearestPlayer;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class AurorianSlime_Entity
extends EntityLiving
implements IMob {
    public static final String EntityName = "aurorianslime";
    public static final ResourceLocation LOOT = new ResourceLocation("theaurorian", "entities/aurorianslime");
    public float squishAmount;
    public float squishFactor;
    public float prevSquishFactor;
    private boolean wasOnGround;
    public int maxNearby = 5 * TAConfig.Config_RunestoneDungeonMobDensity;

    public AurorianSlime_Entity(World worldIn) {
        super(worldIn);
        this.field_70131_O = 0.75f;
        this.field_70765_h = new SlimeMoveHelper(this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AISlimeFloat(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AISlimeAttack(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AISlimeFaceRandom(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AISlimeHop(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIFindEntityNearestPlayer((EntityLiving)this));
    }

    protected void setSlimeSize(int size, boolean resetHealth) {
        this.func_70105_a(0.51000005f * (float)size, 0.51000005f * (float)size);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        if (resetHealth) {
            this.func_70606_j(this.func_110138_aP());
        }
        this.field_70728_aV = 3;
    }

    public boolean func_70601_bi() {
        List<EntityLivingBase> entities = TAUtil.Entity.getEntitiesAround(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0, 6.0, false);
        int maxcount = this.maxNearby;
        int count = 0;
        for (EntityLivingBase e : entities) {
            if (!(e instanceof AurorianSlime_Entity)) continue;
            ++count;
        }
        return count <= maxcount && super.func_70601_bi();
    }

    public int func_70641_bl() {
        return 6;
    }

    public static void registerFixesSlime(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, AurorianSlime_Entity.class);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("wasOnGround", this.wasOnGround);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.wasOnGround = compound.func_74767_n("wasOnGround");
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (ForgeHooks.onLivingFall((EntityLivingBase)this, (float)distance, (float)damageMultiplier) == null) {
            return;
        }
        super.func_180430_e(0.0f, 0.0f);
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.field_70128_L = true;
        }
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.prevSquishFactor = this.squishFactor;
        super.func_70071_h_();
        if (this.field_70122_E && !this.wasOnGround) {
            int i = 1;
            for (int j = 0; j < i * 8; ++j) {
                if (!this.field_70170_p.field_72995_K) continue;
                TAParticles.spawnParticle(TAParticles.Particles.AURORIANSLIME, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
            }
            this.func_184185_a(this.getSquishSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            this.squishAmount = -0.5f;
        } else if (!this.field_70122_E && this.wasOnGround) {
            this.squishAmount = 1.0f;
        }
        this.wasOnGround = this.field_70122_E;
        this.alterSquishAmount();
    }

    protected void alterSquishAmount() {
        this.squishAmount *= 0.6f;
    }

    protected int getJumpDelay() {
        return this.field_70146_Z.nextInt(20) + 10;
    }

    protected AurorianSlime_Entity createInstance() {
        return new AurorianSlime_Entity(this.field_70170_p);
    }

    public void func_70100_b_(EntityPlayer entityIn) {
        double i = 2.0;
        if (this.func_70685_l((Entity)entityIn) && this.func_70068_e((Entity)entityIn) < 0.6 * i * 0.6 * i && entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.getAttackStrength())) {
            this.func_184185_a(SoundEvents.field_187870_fk, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            this.func_174815_a((EntityLivingBase)this, (Entity)entityIn);
        }
    }

    public float func_70047_e() {
        return 0.625f * this.field_70131_O;
    }

    protected int getAttackStrength() {
        return 2;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187898_fy;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187896_fx;
    }

    protected SoundEvent getSquishSound() {
        return SoundEvents.field_187900_fz;
    }

    protected SoundEvent getJumpSound() {
        return SoundEvents.field_189110_fE;
    }

    protected Item func_146068_u() {
        return TAItems.aurorianslimeball;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public int func_70646_bf() {
        return 0;
    }

    protected boolean makesSoundOnJump() {
        return true;
    }

    protected void func_70664_aZ() {
        this.field_70181_x = 0.42f;
        this.field_70160_al = true;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        this.setSlimeSize(1, true);
        return super.func_180482_a(difficulty, livingdata);
    }

    static class SlimeMoveHelper
    extends EntityMoveHelper {
        private float yRot;
        private int jumpDelay;
        private final AurorianSlime_Entity slime;
        private boolean isAggressive;

        public SlimeMoveHelper(AurorianSlime_Entity slimeIn) {
            super((EntityLiving)slimeIn);
            this.slime = slimeIn;
            this.yRot = 180.0f * slimeIn.field_70177_z / (float)Math.PI;
        }

        public void setDirection(float p_179920_1_, boolean p_179920_2_) {
            this.yRot = p_179920_1_;
            this.isAggressive = p_179920_2_;
        }

        public void setSpeed(double speedIn) {
            this.field_75645_e = speedIn;
            this.field_188491_h = EntityMoveHelper.Action.MOVE_TO;
        }

        public void func_75641_c() {
            this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, this.yRot, 90.0f);
            this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z;
            if (this.field_188491_h != EntityMoveHelper.Action.MOVE_TO) {
                this.field_75648_a.func_191989_p(0.0f);
            } else {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
                if (this.field_75648_a.field_70122_E) {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.slime.getJumpDelay();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.slime.func_70683_ar().func_75660_a();
                        this.slime.func_184185_a(this.slime.getJumpSound(), this.slime.func_70599_aP(), ((this.slime.func_70681_au().nextFloat() - this.slime.func_70681_au().nextFloat()) * 0.2f + 1.0f) * 0.8f);
                    } else {
                        this.slime.field_70702_br = 0.0f;
                        this.slime.field_191988_bg = 0.0f;
                        this.field_75648_a.func_70659_e(0.0f);
                    }
                } else {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                }
            }
        }
    }

    static class AISlimeHop
    extends EntityAIBase {
        private final AurorianSlime_Entity slime;

        public AISlimeHop(AurorianSlime_Entity slimeIn) {
            this.slime = slimeIn;
            this.func_75248_a(5);
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            ((SlimeMoveHelper)this.slime.func_70605_aq()).setSpeed(1.5);
        }
    }

    static class AISlimeFloat
    extends EntityAIBase {
        private final AurorianSlime_Entity slime;

        public AISlimeFloat(AurorianSlime_Entity slimeIn) {
            this.slime = slimeIn;
            this.func_75248_a(5);
            ((PathNavigateGround)slimeIn.func_70661_as()).func_179693_d(true);
        }

        public boolean func_75250_a() {
            return this.slime.func_70090_H() || this.slime.func_180799_ab();
        }

        public void func_75246_d() {
            if (this.slime.func_70681_au().nextFloat() < 0.8f) {
                this.slime.func_70683_ar().func_75660_a();
            }
            ((SlimeMoveHelper)this.slime.func_70605_aq()).setSpeed(1.2);
        }
    }

    static class AISlimeFaceRandom
    extends EntityAIBase {
        private final AurorianSlime_Entity slime;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public AISlimeFaceRandom(AurorianSlime_Entity slimeIn) {
            this.slime = slimeIn;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return this.slime.func_70638_az() == null && (this.slime.field_70122_E || this.slime.func_70090_H() || this.slime.func_180799_ab() || this.slime.func_70644_a(MobEffects.field_188424_y));
        }

        public void func_75246_d() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = 40 + this.slime.func_70681_au().nextInt(60);
                this.chosenDegrees = this.slime.func_70681_au().nextInt(360);
            }
            ((SlimeMoveHelper)this.slime.func_70605_aq()).setDirection(this.chosenDegrees, false);
        }
    }

    static class AISlimeAttack
    extends EntityAIBase {
        private final AurorianSlime_Entity slime;
        private int growTieredTimer;

        public AISlimeAttack(AurorianSlime_Entity slimeIn) {
            this.slime = slimeIn;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.slime.func_70638_az();
            if (entitylivingbase == null) {
                return false;
            }
            if (!entitylivingbase.func_70089_S()) {
                return false;
            }
            return !(entitylivingbase instanceof EntityPlayer) || !((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a;
        }

        public void func_75249_e() {
            this.growTieredTimer = 300;
            super.func_75249_e();
        }

        public boolean func_75253_b() {
            EntityLivingBase entitylivingbase = this.slime.func_70638_az();
            if (entitylivingbase == null) {
                return false;
            }
            if (!entitylivingbase.func_70089_S()) {
                return false;
            }
            if (entitylivingbase instanceof EntityPlayer && ((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a) {
                return false;
            }
            return --this.growTieredTimer > 0;
        }

        public void func_75246_d() {
            this.slime.func_70625_a((Entity)this.slime.func_70638_az(), 10.0f, 10.0f);
            ((SlimeMoveHelper)this.slime.func_70605_aq()).setDirection(this.slime.field_70177_z, true);
        }
    }
}

