/*
 * Decompiled with CFR 0.152.
 */
package com.elseytd.theaurorian.Entities.Passive;

import com.elseytd.theaurorian.Blocks.TABlock_DungeonStone;
import com.elseytd.theaurorian.Blocks.TABlock_DungeonStoneLamp;
import com.elseytd.theaurorian.Blocks.TABlock_DungeonStoneSmooth;
import com.elseytd.theaurorian.TABlocks;
import com.elseytd.theaurorian.TAConfig;
import com.elseytd.theaurorian.TAItems;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIMoveToBlock;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityJumpHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDesert;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AurorianRabbit_Entity
extends EntityAnimal {
    public static final String EntityName = "aurorianrabbit";
    public static final ResourceLocation LOOT = new ResourceLocation("theaurorian", "entities/aurorianrabbit");
    private static final Set<Item> BREEDING_ITEMS = Sets.newHashSet((Object[])new Item[]{TAItems.silkberry});
    private int jumpTicks;
    private int jumpDuration;
    private boolean wasOnGround;
    private int currentMoveTypeDuration;
    private int carrotTicks;

    public AurorianRabbit_Entity(World worldIn) {
        super(worldIn);
        this.field_175506_bl = TABlocks.auroriangrass;
        this.func_70105_a(0.4f, 0.5f);
        this.field_70767_i = new RabbitJumpHelper(this);
        this.field_70765_h = new RabbitMoveHelper(this);
        this.setMovementSpeed(0.0);
    }

    public boolean func_70601_bi() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        Block downblock = this.field_70170_p.func_180495_p(new BlockPos(i, j, k).func_177977_b()).func_177230_c();
        return super.func_70601_bi() && !(downblock instanceof TABlock_DungeonStone) && !(downblock instanceof TABlock_DungeonStoneSmooth) && !(downblock instanceof TABlock_DungeonStoneLamp) && this.field_71093_bK == TAConfig.Config_AurorianDimID;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIPanic(this, 2.2));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 0.8));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.0, (Item)TAItems.silkberry, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 8.0f, 2.2, 2.2));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityWolf.class, 10.0f, 2.2, 2.2));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityMob.class, 4.0f, 2.2, 2.2));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIRaidFarm(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f));
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    protected float func_175134_bD() {
        if (!(this.field_70123_F || this.field_70765_h.func_75640_a() && !(this.field_70765_h.func_179919_e() <= this.field_70163_u + 0.5))) {
            Path path = this.field_70699_by.func_75505_d();
            if (path != null && path.func_75873_e() < path.func_75874_d()) {
                Vec3d vec3d = path.func_75878_a((Entity)this);
                if (vec3d.field_72448_b > this.field_70163_u + 0.5) {
                    return 0.5f;
                }
            }
            return this.field_70765_h.func_75638_b() <= 0.6 ? 0.2f : 0.3f;
        }
        return 0.5f;
    }

    protected void func_70664_aZ() {
        double d1;
        super.func_70664_aZ();
        double d0 = this.field_70765_h.func_75638_b();
        if (d0 > 0.0 && (d1 = this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y) < 0.010000000000000002) {
            this.func_191958_b(0.0f, 0.0f, 1.0f, 0.1f);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float setJumpCompletion(float p_175521_1_) {
        return this.jumpDuration == 0 ? 0.0f : ((float)this.jumpTicks + p_175521_1_) / (float)this.jumpDuration;
    }

    public void setMovementSpeed(double newSpeed) {
        this.func_70661_as().func_75489_a(newSpeed);
        this.field_70765_h.func_75642_a(this.field_70765_h.func_179917_d(), this.field_70765_h.func_179919_e(), this.field_70765_h.func_179918_f(), newSpeed);
    }

    public void func_70637_d(boolean jumping) {
        super.func_70637_d(jumping);
        if (jumping) {
            this.func_184185_a(this.getJumpSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) * 0.8f);
        }
    }

    public void startJumping() {
        this.func_70637_d(true);
        this.jumpDuration = 10;
        this.jumpTicks = 0;
    }

    public void func_70619_bc() {
        if (this.currentMoveTypeDuration > 0) {
            --this.currentMoveTypeDuration;
        }
        if (this.carrotTicks > 0) {
            this.carrotTicks -= this.field_70146_Z.nextInt(3);
            if (this.carrotTicks < 0) {
                this.carrotTicks = 0;
            }
        }
        if (this.field_70122_E) {
            RabbitJumpHelper entityrabbit$rabbitjumphelper;
            if (!this.wasOnGround) {
                this.func_70637_d(false);
                this.checkLandingDelay();
            }
            if (!(entityrabbit$rabbitjumphelper = (RabbitJumpHelper)this.field_70767_i).getIsJumping()) {
                if (this.field_70765_h.func_75640_a() && this.currentMoveTypeDuration == 0) {
                    Path path = this.field_70699_by.func_75505_d();
                    Vec3d vec3d = new Vec3d(this.field_70765_h.func_179917_d(), this.field_70765_h.func_179919_e(), this.field_70765_h.func_179918_f());
                    if (path != null && path.func_75873_e() < path.func_75874_d()) {
                        vec3d = path.func_75878_a((Entity)this);
                    }
                    this.calculateRotationYaw(vec3d.field_72450_a, vec3d.field_72449_c);
                    this.startJumping();
                }
            } else if (!entityrabbit$rabbitjumphelper.canJump()) {
                this.enableJumpControl();
            }
        }
        this.wasOnGround = this.field_70122_E;
    }

    public void func_174830_Y() {
    }

    private void calculateRotationYaw(double x, double z) {
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)(z - this.field_70161_v), (double)(x - this.field_70165_t)) * 57.29577951308232) - 90.0f;
    }

    private void enableJumpControl() {
        ((RabbitJumpHelper)this.field_70767_i).setCanJump(true);
    }

    private void disableJumpControl() {
        ((RabbitJumpHelper)this.field_70767_i).setCanJump(false);
    }

    private void updateMoveTypeDuration() {
        this.currentMoveTypeDuration = this.field_70765_h.func_75638_b() < 2.2 ? 10 : 1;
    }

    private void checkLandingDelay() {
        this.updateMoveTypeDuration();
        this.disableJumpControl();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.jumpTicks != this.jumpDuration) {
            ++this.jumpTicks;
        } else if (this.jumpDuration != 0) {
            this.jumpTicks = 0;
            this.jumpDuration = 0;
            this.func_70637_d(false);
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
    }

    public static void registerFixesRabbit(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, AurorianRabbit_Entity.class);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("MoreCarrotTicks", this.carrotTicks);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.carrotTicks = compound.func_74762_e("MoreCarrotTicks");
    }

    protected SoundEvent getJumpSound() {
        return SoundEvents.field_187824_en;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187816_ej;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187822_em;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187820_el;
    }

    public boolean func_70652_k(Entity entityIn) {
        return entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 3.0f);
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.NEUTRAL;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return this.func_180431_b(source) ? false : super.func_70097_a(source, amount);
    }

    private boolean isRabbitBreedingItem(Item itemIn) {
        return BREEDING_ITEMS.contains(itemIn);
    }

    public boolean func_70877_b(ItemStack stack) {
        return this.isRabbitBreedingItem(stack.func_77973_b());
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        int i = this.getRandomRabbitType();
        boolean flag = false;
        if (livingdata instanceof RabbitTypeData) {
            i = ((RabbitTypeData)livingdata).typeData;
            flag = true;
        } else {
            livingdata = new RabbitTypeData(i);
        }
        if (flag) {
            this.func_70873_a(-24000);
        }
        return livingdata;
    }

    private int getRandomRabbitType() {
        Biome biome = this.field_70170_p.func_180494_b(new BlockPos((Entity)this));
        int i = this.field_70146_Z.nextInt(100);
        if (biome.func_150559_j()) {
            return i < 80 ? 1 : 3;
        }
        if (biome instanceof BiomeDesert) {
            return 4;
        }
        return i < 50 ? 0 : (i < 90 ? 5 : 2);
    }

    private boolean isCarrotEaten() {
        return this.carrotTicks == 0;
    }

    protected void createEatingParticles() {
        this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_DUST, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)TABlocks.silkberryplant.func_176223_P())});
        this.carrotTicks = 40;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 1) {
            this.func_174808_Z();
            this.jumpDuration = 10;
            this.jumpTicks = 0;
        } else {
            super.func_70103_a(id);
        }
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return new AurorianRabbit_Entity(this.field_70170_p);
    }

    public static class RabbitTypeData
    implements IEntityLivingData {
        public int typeData;

        public RabbitTypeData(int type) {
            this.typeData = type;
        }
    }

    static class RabbitMoveHelper
    extends EntityMoveHelper {
        private final AurorianRabbit_Entity rabbit;
        private double nextJumpSpeed;

        public RabbitMoveHelper(AurorianRabbit_Entity rabbit) {
            super((EntityLiving)rabbit);
            this.rabbit = rabbit;
        }

        public void func_75641_c() {
            if (this.rabbit.field_70122_E && !this.rabbit.field_70703_bu && !((RabbitJumpHelper)this.rabbit.field_70767_i).getIsJumping()) {
                this.rabbit.setMovementSpeed(0.0);
            } else if (this.func_75640_a()) {
                this.rabbit.setMovementSpeed(this.nextJumpSpeed);
            }
            super.func_75641_c();
        }

        public void func_75642_a(double x, double y, double z, double speedIn) {
            if (this.rabbit.func_70090_H()) {
                speedIn = 1.5;
            }
            super.func_75642_a(x, y, z, speedIn);
            if (speedIn > 0.0) {
                this.nextJumpSpeed = speedIn;
            }
        }
    }

    public class RabbitJumpHelper
    extends EntityJumpHelper {
        private final AurorianRabbit_Entity rabbit;
        private boolean canJump;

        public RabbitJumpHelper(AurorianRabbit_Entity rabbit) {
            super((EntityLiving)rabbit);
            this.rabbit = rabbit;
        }

        public boolean getIsJumping() {
            return this.field_75662_b;
        }

        public boolean canJump() {
            return this.canJump;
        }

        public void setCanJump(boolean canJumpIn) {
            this.canJump = canJumpIn;
        }

        public void func_75661_b() {
            if (this.field_75662_b) {
                this.rabbit.startJumping();
                this.field_75662_b = false;
            }
        }
    }

    static class AIRaidFarm
    extends EntityAIMoveToBlock {
        private final AurorianRabbit_Entity rabbit;
        private boolean wantsToRaid;
        private boolean canRaid;

        public AIRaidFarm(AurorianRabbit_Entity rabbitIn) {
            super((EntityCreature)rabbitIn, (double)0.7f, 16);
            this.rabbit = rabbitIn;
        }

        public boolean func_75250_a() {
            if (this.field_179496_a <= 0) {
                if (!ForgeEventFactory.getMobGriefingEvent((World)this.rabbit.field_70170_p, (Entity)this.rabbit)) {
                    return false;
                }
                this.canRaid = false;
                this.wantsToRaid = this.rabbit.isCarrotEaten();
                this.wantsToRaid = true;
            }
            return super.func_75250_a();
        }

        public boolean func_75253_b() {
            return this.canRaid && super.func_75253_b();
        }

        public void func_75246_d() {
            super.func_75246_d();
            this.rabbit.func_70671_ap().func_75650_a((double)this.field_179494_b.func_177958_n() + 0.5, (double)(this.field_179494_b.func_177956_o() + 1), (double)this.field_179494_b.func_177952_p() + 0.5, 10.0f, (float)this.rabbit.func_70646_bf());
            if (this.func_179487_f()) {
                this.canRaid = false;
                this.field_179496_a = 10;
            }
        }

        protected boolean func_179488_a(World worldIn, BlockPos pos) {
            Block block = worldIn.func_180495_p(pos).func_177230_c();
            if (block == Blocks.field_150458_ak && this.wantsToRaid && !this.canRaid) {
                pos = pos.func_177984_a();
                IBlockState iblockstate = worldIn.func_180495_p(pos);
                block = iblockstate.func_177230_c();
            }
            return false;
        }
    }

    static class AIPanic
    extends EntityAIPanic {
        private final AurorianRabbit_Entity rabbit;

        public AIPanic(AurorianRabbit_Entity rabbit, double speedIn) {
            super((EntityCreature)rabbit, speedIn);
            this.rabbit = rabbit;
        }

        public void func_75246_d() {
            super.func_75246_d();
            this.rabbit.setMovementSpeed(this.field_75265_b);
        }
    }
}

