/*
 * Decompiled with CFR 0.152.
 */
package com.elseytd.theaurorian.Misc;

import com.elseytd.theaurorian.TABlocks;
import com.elseytd.theaurorian.TAConfig;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class GenerationHelper {
    public static boolean isNearStructure(IChunkSpecific structure, World worldIn, BlockPos pos, int range, int searchdistance) {
        int chunkX = worldIn.func_175726_f((BlockPos)pos).field_76635_g;
        int chunkZ = worldIn.func_175726_f((BlockPos)pos).field_76647_h;
        if (worldIn.field_73011_w.getDimension() == TAConfig.Config_AurorianDimID) {
            for (int x = -(searchdistance / 2); x < searchdistance / 2; ++x) {
                for (int z = -(searchdistance / 2); z < searchdistance / 2; ++z) {
                    int blocksaway;
                    if (!structure.isValidChunkForGen(chunkX + x, chunkZ + z, 0, 0) || (blocksaway = (int)pos.func_185332_f((chunkX + x) * 16, pos.func_177956_o(), (chunkZ + z) * 16)) > range) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static ChunkPos getNearestStructure(IChunkSpecific structure, EntityPlayer player, int distance) {
        int playerchunkX = player.field_70176_ah;
        int playerchunkZ = player.field_70164_aj;
        ChunkPos closest = null;
        int closestdist = 0;
        if (player.field_71093_bK == TAConfig.Config_AurorianDimID) {
            for (int x = -(distance / 2); x < distance / 2; ++x) {
                for (int z = -(distance / 2); z < distance / 2; ++z) {
                    if (!structure.isValidChunkForGen(playerchunkX + x, playerchunkZ + z, 0, 0)) continue;
                    int blocksaway = (int)player.func_70011_f((double)((playerchunkX + x) * 16), player.field_70163_u, (double)((playerchunkZ + z) * 16));
                    if (closest != null && blocksaway >= closestdist) continue;
                    closest = new ChunkPos(playerchunkX + x, playerchunkZ + z);
                    closestdist = blocksaway;
                }
            }
        }
        return closest;
    }

    public static void populateChestsInChunk(Chunk c, Random rand, ResourceLocation loot, boolean ignorechestempty) {
        Map entry = c.func_177434_r();
        for (TileEntity e : entry.values()) {
            if (e == null || !(e instanceof TileEntityChest)) continue;
            TileEntityChest chest = (TileEntityChest)e;
            if (ignorechestempty) {
                chest.func_189404_a(loot, rand.nextLong());
                continue;
            }
            if (!chest.func_191420_l()) continue;
            chest.func_189404_a(loot, rand.nextLong());
        }
    }

    public static void populateChestsInChunkAtHeight(Chunk c, int y, Random rand, ResourceLocation loot, boolean ignorechestempty) {
        Map entry = c.func_177434_r();
        for (TileEntity e : entry.values()) {
            TileEntityChest chest;
            if (e == null || !(e instanceof TileEntityChest) || (chest = (TileEntityChest)e).func_174877_v().func_177956_o() != y) continue;
            if (ignorechestempty) {
                chest.func_189404_a(loot, rand.nextLong());
                continue;
            }
            if (!chest.func_191420_l()) continue;
            chest.func_189404_a(loot, rand.nextLong());
        }
    }

    public static void populateChestsInChunk(Chunk c, Random rand, ResourceLocation loot) {
        GenerationHelper.populateChestsInChunk(c, rand, loot, false);
    }

    public static boolean isTerrainFlat(World worldIn, BlockPos pos, int maximumDifference) {
        int low = 255;
        int high = 0;
        for (int x = 0; x <= 16; ++x) {
            block1: for (int z = 0; z <= 16; ++z) {
                for (int y = 190; y >= 60; --y) {
                    if (worldIn.func_180495_p(new BlockPos(pos.func_177958_n() + x, y, pos.func_177952_p() + z)).func_177230_c() != TABlocks.auroriangrass) continue;
                    if (y >= high) {
                        high = y;
                    }
                    if (y > low) continue block1;
                    low = y;
                    continue block1;
                }
            }
        }
        return high - low <= maximumDifference;
    }

    public static interface IChunkSpecific {
        public boolean isValidChunkForGen(int var1, int var2, int var3, int var4);
    }
}

