/*
 * Decompiled with CFR 0.152.
 */
package com.elseytd.theaurorian;

import com.elseytd.theaurorian.TAConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class TAUtil {
    public static boolean randomChanceOf(double percent) {
        Random r = new Random();
        double gen = r.nextDouble();
        return gen <= percent;
    }

    public static class AurorianSteel {
        public static int maxlevelbase = TAConfig.Config_AurorianSteel_BaseMaxLevel;
        public static float maxlevelmultiplier = TAConfig.Config_AurorianSteel_BaseMaxLevelMultiplier;

        @SideOnly(value=Side.CLIENT)
        public static String getAurorianSteelTooltip() {
            return I18n.func_135052_a((String)"string.theaurorian.tooltip.auroriansteeltools", (Object[])new Object[0]);
        }

        public static void handleAurorianSteelDurability(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
            float levelmultiplier;
            int itemlevel = AurorianSteel.getLevel(stack);
            if (itemlevel >= Math.round((float)maxlevelbase * (levelmultiplier = AurorianSteel.getMultiplier(stack))) - 1) {
                if (stack.func_77948_v()) {
                    Map enchs = EnchantmentHelper.func_82781_a((ItemStack)stack);
                    block4: for (Map.Entry e : enchs.entrySet()) {
                        if (((Enchantment)e.getKey()).func_77325_b() <= 1 || (Integer)e.getValue() >= ((Enchantment)e.getKey()).func_77325_b()) continue;
                        switch (TAConfig.Config_AurorianSteel_Enchants_WhitelistBlacklist) {
                            default: {
                                enchs.put(e.getKey(), (Integer)e.getValue() + 1);
                                EnchantmentHelper.func_82782_a((Map)enchs, (ItemStack)stack);
                                AurorianSteel.setMultiplier(stack, levelmultiplier * maxlevelmultiplier);
                                AurorianSteel.setLevel(stack, 0);
                                return;
                            }
                            case 1: {
                                for (String enchreg : TAConfig.Config_AurorianSteel_Enchants) {
                                    if (!enchreg.equals(((Enchantment)e.getKey()).getRegistryName().toString()) && !((Enchantment)e.getKey()).getRegistryName().func_110624_b().equals(enchreg)) continue;
                                    enchs.put(e.getKey(), (Integer)e.getValue() + 1);
                                    EnchantmentHelper.func_82782_a((Map)enchs, (ItemStack)stack);
                                    AurorianSteel.setMultiplier(stack, levelmultiplier * maxlevelmultiplier);
                                    AurorianSteel.setLevel(stack, 0);
                                    return;
                                }
                                continue block4;
                            }
                            case 2: {
                                for (String enchreg : TAConfig.Config_AurorianSteel_Enchants) {
                                    if (!enchreg.equals(((Enchantment)e.getKey()).getRegistryName().toString()) && !((Enchantment)e.getKey()).getRegistryName().func_110624_b().equals(enchreg)) continue;
                                    return;
                                }
                                enchs.put(e.getKey(), (Integer)e.getValue() + 1);
                                EnchantmentHelper.func_82782_a((Map)enchs, (ItemStack)stack);
                                AurorianSteel.setMultiplier(stack, levelmultiplier * maxlevelmultiplier);
                                AurorianSteel.setLevel(stack, 0);
                                return;
                            }
                        }
                    }
                }
            } else {
                AurorianSteel.setLevel(stack, itemlevel + 1);
            }
        }

        public static float getMultiplier(ItemStack stack) {
            AurorianSteel.checkNbt(stack);
            return stack.func_77978_p().func_74760_g("upgrademultiplier");
        }

        public static void setMultiplier(ItemStack stack, float amt) {
            NBTTagCompound nbt = AurorianSteel.checkNbt(stack);
            nbt.func_74776_a("upgrademultiplier", amt);
        }

        public static int getLevel(ItemStack stack) {
            AurorianSteel.checkNbt(stack);
            return stack.func_77978_p().func_74762_e("currentupgradelevel");
        }

        public static void setLevel(ItemStack stack, int amt) {
            NBTTagCompound nbt = AurorianSteel.checkNbt(stack);
            nbt.func_74768_a("currentupgradelevel", amt);
        }

        public static NBTTagCompound checkNbt(ItemStack stack) {
            NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
            if (!nbt.func_74764_b("currentupgradelevel")) {
                nbt.func_74768_a("currentupgradelevel", 0);
                stack.func_77982_d(nbt);
            }
            if (!nbt.func_74764_b("upgrademultiplier")) {
                nbt.func_74776_a("upgrademultiplier", 1.0f);
                stack.func_77982_d(nbt);
            }
            return nbt;
        }
    }

    public static class Moonstone {
        @SideOnly(value=Side.CLIENT)
        public static String getMoonstoneTooltip() {
            return I18n.func_135052_a((String)"string.theaurorian.tooltip.moonstonetools", (Object[])new Object[0]);
        }

        public static void handleMoonstoneDurability(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
            if (entityLiving.field_71093_bK == TAConfig.Config_AurorianDimID || entityLiving.field_71093_bK == 0 && !entityLiving.field_70170_p.func_72935_r()) {
                if (TAUtil.randomChanceOf(0.5)) {
                    stack.func_77972_a(1, entityLiving);
                }
            } else {
                if (TAUtil.randomChanceOf(0.5)) {
                    stack.func_77972_a(1, entityLiving);
                }
                stack.func_77972_a(1, entityLiving);
            }
        }
    }

    public static class LocalOreDictionary {
        public static List<ItemStack> Ores = null;

        public static List<ItemStack> populateOrelist() {
            String[] names = OreDictionary.getOreNames();
            ArrayList<ItemStack> ores = new ArrayList<ItemStack>();
            for (String s : names) {
                if (!s.startsWith("ore")) continue;
                ores.addAll((Collection<ItemStack>)OreDictionary.getOres((String)s));
            }
            return ores;
        }

        public static boolean isOre(ItemStack itemIn) {
            for (ItemStack i : Ores) {
                if (!ItemStack.func_179545_c((ItemStack)i, (ItemStack)itemIn)) continue;
                return true;
            }
            return false;
        }

        public static ItemStack getTypeFromOre(ItemStack itemIn, String type) {
            NonNullList nuggets = new ArrayList();
            for (int i : OreDictionary.getOreIDs((ItemStack)itemIn)) {
                String orename = OreDictionary.getOreName((int)i);
                String nuggetnamewouldbe = type + orename.substring(3);
                nuggets = OreDictionary.getOres((String)nuggetnamewouldbe);
                if (nuggets == null || nuggets.isEmpty()) continue;
                return (ItemStack)nuggets.get(0);
            }
            return null;
        }
    }

    public static class Debugging {
        public static void renderAABBBounds(World worldIn, AxisAlignedBB aabb) {
            if (worldIn.field_72995_K) {
                for (double ix = aabb.field_72340_a; ix <= aabb.field_72336_d; ix += 1.0) {
                    for (double iy = aabb.field_72338_b; iy <= aabb.field_72337_e; iy += 1.0) {
                        for (double iz = aabb.field_72339_c; iz <= aabb.field_72334_f; iz += 1.0) {
                            EnumParticleTypes particle = EnumParticleTypes.CLOUD;
                            if (ix == aabb.field_72340_a || ix == aabb.field_72336_d) {
                                worldIn.func_175688_a(particle, ix, iy, iz, 0.0, 0.0, 0.0, new int[0]);
                            }
                            if (iy == aabb.field_72338_b || iy == aabb.field_72337_e) {
                                worldIn.func_175688_a(particle, ix, iy, iz, 0.0, 0.0, 0.0, new int[0]);
                            }
                            if (iz != aabb.field_72339_c && iz != aabb.field_72334_f) continue;
                            worldIn.func_175688_a(particle, ix, iy, iz, 0.0, 0.0, 0.0, new int[0]);
                        }
                    }
                }
            }
        }
    }

    public static class Entity {
        public static boolean isLookingAt(EntityLivingBase looker, EntityLivingBase target, double accuracy) {
            Vec3d lookvec = target.func_70676_i(1.0f).func_72432_b();
            Vec3d vec = new Vec3d(looker.field_70165_t - target.field_70165_t, looker.func_174813_aQ().field_72338_b + (double)looker.func_70047_e() - (target.field_70163_u + (double)target.func_70047_e()), looker.field_70161_v - target.field_70161_v);
            double leng = vec.func_72433_c();
            double mult = lookvec.func_72430_b(vec = vec.func_72432_b());
            return mult > 1.0 - accuracy / leng ? target.func_70685_l((net.minecraft.entity.Entity)looker) : false;
        }

        public static List<EntityLivingBase> getEntitiesAround(World worldIn, double x, double y, double z, double distance, boolean debugRender) {
            return Entity.getEntitiesAround(worldIn, x, y, z, distance, distance, debugRender);
        }

        public static List<EntityLivingBase> getEntitiesAround(World worldIn, double x, double y, double z, double distance, double height, boolean debugRender) {
            AxisAlignedBB aabb = new AxisAlignedBB(x - distance, y - height, z - distance, x + distance, y + height, z + distance);
            if (debugRender) {
                Debugging.renderAABBBounds(worldIn, aabb);
            }
            return worldIn.func_72872_a(EntityLivingBase.class, aabb);
        }
    }
}

