/*
 * Decompiled with CFR 0.152.
 */
package com.elseytd.theaurorian.World.Structures;

import com.elseytd.theaurorian.Misc.GenerationHelper;
import com.elseytd.theaurorian.TABlocks;
import com.elseytd.theaurorian.TAConfig;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;

public class TAWorldGenerator_MoonTemple
extends WorldGenerator
implements GenerationHelper.IChunkSpecific {
    private static final ResourceLocation MOONTEMPLE_LOOTTABLE_LOW = new ResourceLocation("theaurorian", "chests/moontemplelow");
    private static final ResourceLocation MOONTEMPLE_LOOTTABLE_MED = new ResourceLocation("theaurorian", "chests/moontemplemed");
    private static final ResourceLocation MOONTEMPLE_TERRAIN = new ResourceLocation("theaurorian", "moontemple/moontemple_terrain");
    private static final ResourceLocation MOONTEMPLE_COURTYARD = new ResourceLocation("theaurorian", "moontemple/moontemplev2_courtyard");
    private static final ResourceLocation MOONTEMPLE_COURTYARD_LEFT = new ResourceLocation("theaurorian", "moontemple/moontemplev2_courtyardl");
    private static final ResourceLocation MOONTEMPLE_COURTYARD_RIGHT = new ResourceLocation("theaurorian", "moontemple/moontemplev2_courtyardr");
    private static final ResourceLocation MOONTEMPLE_CONNECTOR = new ResourceLocation("theaurorian", "moontemple/moontemplev2_center");
    private static final ResourceLocation MOONTEMPLE_TOWER_LEFT = new ResourceLocation("theaurorian", "moontemple/moontemplev2_left");
    private static final ResourceLocation MOONTEMPLE_TOWER_RIGHT = new ResourceLocation("theaurorian", "moontemple/moontemplev2_right");
    private static final ResourceLocation MOONTEMPLE_ROOM = new ResourceLocation("theaurorian", "moontemple/moontemplev2_room");
    private static final ResourceLocation MOONTEMPLE_ISLAND = new ResourceLocation("theaurorian", "moontemple/moontemple_island");
    private static final ResourceLocation MOONTEMPLE_PATH_TURN = new ResourceLocation("theaurorian", "moontemple/moontemple_path_turn");
    private static final ResourceLocation MOONTEMPLE_PATH_STRAIGHT = new ResourceLocation("theaurorian", "moontemple/moontemple_path_straight");
    public static int CHUNKS_BETWEEN_TEMPLES = TAConfig.Config_DungeonDensity * 2;
    public static boolean GENERATE_TEMPLES = TAConfig.Config_GenerateMoonTemple;
    public static boolean GENERATE_TEMPLES_PATH = TAConfig.Config_GenerateMoonTemplePath;

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        int height;
        Chunk c = worldIn.func_175726_f(position);
        if (this.generateTemple(worldIn, c, height = 200, rand)) {
            Chunk c1 = worldIn.func_72964_e(c.field_76635_g + 1, c.field_76647_h + 1);
            Chunk c2 = worldIn.func_72964_e(c.field_76635_g + 1, c.field_76647_h);
            Chunk c3 = worldIn.func_72964_e(c.field_76635_g, c.field_76647_h + 1);
            this.populateChests(c, height, height + 12, MOONTEMPLE_LOOTTABLE_LOW, rand);
            this.populateChests(c, height + 12, height + 30, MOONTEMPLE_LOOTTABLE_MED, rand);
            this.populateChests(c1, height, height + 12, MOONTEMPLE_LOOTTABLE_LOW, rand);
            this.populateChests(c1, height + 12, height + 30, MOONTEMPLE_LOOTTABLE_MED, rand);
            this.populateChests(c2, height, height + 12, MOONTEMPLE_LOOTTABLE_LOW, rand);
            this.populateChests(c2, height + 12, height + 30, MOONTEMPLE_LOOTTABLE_MED, rand);
            this.populateChests(c3, height, height + 12, MOONTEMPLE_LOOTTABLE_LOW, rand);
            this.populateChests(c3, height + 12, height + 30, MOONTEMPLE_LOOTTABLE_MED, rand);
        }
        return true;
    }

    private void populateChests(Chunk c, int heightmin, int heightmax, ResourceLocation loot, Random r) {
        for (int y = heightmin; y <= heightmax; ++y) {
            GenerationHelper.populateChestsInChunkAtHeight(c, y, r, loot, false);
        }
    }

    @Override
    public boolean isValidChunkForGen(int chunkX, int chunkZ, int offsetX, int offsetZ) {
        return (chunkX + offsetX + TAConfig.Config_DungeonDensity / 2) % CHUNKS_BETWEEN_TEMPLES == 0 && (chunkZ + offsetZ + TAConfig.Config_DungeonDensity / 2) % CHUNKS_BETWEEN_TEMPLES == 0;
    }

    public boolean generateTemple(World world, Chunk c, int height, Random rand) {
        Template temple_courtyard;
        Template temple_tower;
        Template temple_terrain;
        boolean populateChests = false;
        int chunkX = c.field_76635_g;
        int chunkZ = c.field_76647_h;
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        int y = height;
        PlacementSettings settings = new PlacementSettings().func_186220_a(Rotation.NONE).func_186225_a((Block)TABlocks.aurorianstone);
        if (this.isValidChunkForGen(chunkX, chunkZ, 0, 0)) {
            Template temple_connector = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), MOONTEMPLE_CONNECTOR);
            temple_connector.func_186253_b(world, new BlockPos(x, y, z), settings);
            temple_terrain = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), MOONTEMPLE_TERRAIN);
            temple_terrain.func_186253_b(world, new BlockPos(x, y - 12, z), settings);
            populateChests = true;
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, -1, 0)) {
            temple_tower = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), MOONTEMPLE_TOWER_LEFT);
            temple_tower.func_186253_b(world, new BlockPos(x, y, z), settings);
            temple_terrain = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), MOONTEMPLE_TERRAIN);
            temple_terrain.func_186253_b(world, new BlockPos(x, y - 12, z), settings);
            populateChests = true;
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 1, 0)) {
            temple_tower = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), MOONTEMPLE_TOWER_RIGHT);
            temple_tower.func_186253_b(world, new BlockPos(x, y, z), settings);
            temple_terrain = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), MOONTEMPLE_TERRAIN);
            temple_terrain.func_186253_b(world, new BlockPos(x, y - 12, z), settings);
            populateChests = true;
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 0, 1)) {
            temple_courtyard = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), MOONTEMPLE_COURTYARD);
            temple_courtyard.func_186253_b(world, new BlockPos(x, y, z), settings);
            temple_terrain = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), MOONTEMPLE_TERRAIN);
            temple_terrain.func_186253_b(world, new BlockPos(x, y - 12, z), settings);
            populateChests = true;
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, -1, 1)) {
            temple_courtyard = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), MOONTEMPLE_COURTYARD_LEFT);
            temple_courtyard.func_186253_b(world, new BlockPos(x, y, z), settings);
            populateChests = true;
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 1, 1)) {
            temple_courtyard = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), MOONTEMPLE_COURTYARD_RIGHT);
            temple_courtyard.func_186253_b(world, new BlockPos(x, y, z), settings);
            populateChests = true;
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 0, -1)) {
            Template temple_room = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), MOONTEMPLE_ROOM);
            temple_room.func_186253_b(world, new BlockPos(x, y, z), settings);
            temple_terrain = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), MOONTEMPLE_TERRAIN);
            temple_terrain.func_186253_b(world, new BlockPos(x, y - 12, z), settings);
            populateChests = true;
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, -1, -3)) {
            this.genIsland(world, x, y, z, rand);
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 1, -3)) {
            this.genIsland(world, x, y, z, rand);
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, -1, 3)) {
            this.genIsland(world, x, y, z, rand);
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 1, 3)) {
            this.genIsland(world, x, y, z, rand);
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, -3, -1)) {
            this.genIsland(world, x, y, z, rand);
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, -3, 1)) {
            this.genIsland(world, x, y, z, rand);
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 3, -1)) {
            this.genIsland(world, x, y, z, rand);
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 3, 1)) {
            this.genIsland(world, x, y, z, rand);
        }
        if (GENERATE_TEMPLES_PATH) {
            this.genSpiralPath(world, chunkX, chunkZ, x, y, z);
        }
        return populateChests;
    }

    public void genIsland(World world, int x, int y, int z, Random rand) {
        PlacementSettings settings = new PlacementSettings().func_186220_a(Rotation.NONE).func_186225_a(Blocks.field_150350_a);
        Template temple_island = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), MOONTEMPLE_ISLAND);
        temple_island.func_189962_a(world, new BlockPos(x, y - 27 + rand.nextInt(10), z), settings, 3);
    }

    public void genSpiralPath(World world, int chunkX, int chunkZ, int x, int y, int z) {
        Template path_straight;
        Template path_corner;
        PlacementSettings settings = new PlacementSettings().func_186220_a(Rotation.NONE).func_186225_a(Blocks.field_150350_a);
        PlacementSettings settingsrotated90 = new PlacementSettings().func_186220_a(Rotation.COUNTERCLOCKWISE_90).func_186225_a(Blocks.field_150350_a);
        PlacementSettings settingsrotated90c = new PlacementSettings().func_186220_a(Rotation.CLOCKWISE_90).func_186225_a(Blocks.field_150350_a);
        PlacementSettings settingsrotated180 = new PlacementSettings().func_186220_a(Rotation.CLOCKWISE_180).func_186225_a(Blocks.field_150350_a);
        int height = y - 1;
        int yoffset = 7;
        if (this.isValidChunkForGen(chunkX, chunkZ, 0, 2)) {
            path_corner = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), MOONTEMPLE_PATH_TURN);
            path_corner.func_186253_b(world, new BlockPos(x, height - yoffset, z), settings);
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 1, 2)) {
            path_straight = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), MOONTEMPLE_PATH_STRAIGHT);
            path_straight.func_186253_b(world, new BlockPos(x, height - yoffset * 2, z), settings);
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 2, 2)) {
            path_corner = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), MOONTEMPLE_PATH_TURN);
            path_corner.func_186253_b(world, new BlockPos(x, height - yoffset * 3, z + 15), settingsrotated90);
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 2, 1)) {
            path_straight = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), MOONTEMPLE_PATH_STRAIGHT);
            path_straight.func_186253_b(world, new BlockPos(x, height - yoffset * 4, z + 15), settingsrotated90);
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 2, 0)) {
            path_straight = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), MOONTEMPLE_PATH_STRAIGHT);
            path_straight.func_186253_b(world, new BlockPos(x, height - yoffset * 5, z + 15), settingsrotated90);
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 2, -1)) {
            path_straight = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), MOONTEMPLE_PATH_STRAIGHT);
            path_straight.func_186253_b(world, new BlockPos(x, height - yoffset * 6, z + 15), settingsrotated90);
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 2, -2)) {
            path_corner = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), MOONTEMPLE_PATH_TURN);
            path_corner.func_186253_b(world, new BlockPos(x + 15, height - yoffset * 7, z + 15), settingsrotated180);
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 1, -2)) {
            path_straight = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), MOONTEMPLE_PATH_STRAIGHT);
            path_straight.func_186253_b(world, new BlockPos(x + 15, height - yoffset * 8, z + 15), settingsrotated180);
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 0, -2)) {
            path_straight = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), MOONTEMPLE_PATH_STRAIGHT);
            path_straight.func_186253_b(world, new BlockPos(x + 15, height - yoffset * 9, z + 15), settingsrotated180);
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, -1, -2)) {
            path_straight = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), MOONTEMPLE_PATH_STRAIGHT);
            path_straight.func_186253_b(world, new BlockPos(x + 15, height - yoffset * 10, z + 15), settingsrotated180);
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, -2, -2)) {
            path_corner = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), MOONTEMPLE_PATH_TURN);
            path_corner.func_186253_b(world, new BlockPos(x + 15, height - yoffset * 11, z), settingsrotated90c);
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, -2, -1)) {
            path_straight = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), MOONTEMPLE_PATH_STRAIGHT);
            path_straight.func_186253_b(world, new BlockPos(x + 15, height - yoffset * 12, z), settingsrotated90c);
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, -2, 0)) {
            path_straight = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), MOONTEMPLE_PATH_STRAIGHT);
            path_straight.func_186253_b(world, new BlockPos(x + 15, height - yoffset * 13, z), settingsrotated90c);
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, -2, 1)) {
            path_straight = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), MOONTEMPLE_PATH_STRAIGHT);
            path_straight.func_186253_b(world, new BlockPos(x + 15, height - yoffset * 14, z), settingsrotated90c);
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, -2, 2)) {
            path_corner = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), MOONTEMPLE_PATH_TURN);
            path_corner.func_186253_b(world, new BlockPos(x, height - yoffset * 15, z), settings);
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, -1, 2)) {
            path_straight = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), MOONTEMPLE_PATH_STRAIGHT);
            path_straight.func_186253_b(world, new BlockPos(x, height - yoffset * 16, z), settings);
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 0, 2)) {
            path_straight = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), MOONTEMPLE_PATH_STRAIGHT);
            path_straight.func_186253_b(world, new BlockPos(x, height - yoffset * 17, z), settings);
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 1, 2)) {
            path_straight = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), MOONTEMPLE_PATH_STRAIGHT);
            path_straight.func_186253_b(world, new BlockPos(x, height - yoffset * 18, z), settings);
        }
    }
}

