/*
 * Decompiled with CFR 0.152.
 */
package com.elseytd.theaurorian.World.Structures;

import com.elseytd.theaurorian.Misc.GenerationHelper;
import com.elseytd.theaurorian.TABlocks;
import com.elseytd.theaurorian.TAConfig;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;

public class TAWorldGenerator_Runestone_Tower
extends WorldGenerator
implements GenerationHelper.IChunkSpecific {
    private static final ResourceLocation RUNESTONETOWER_LOOTTABLELOW = new ResourceLocation("theaurorian", "chests/runestonetowerlow");
    private static final ResourceLocation RUNESTONETOWER_LOOTTABLEMED = new ResourceLocation("theaurorian", "chests/runestonetowermed");
    private static final ResourceLocation RUNESTONETOWER_LOOTTABLEHIGH = new ResourceLocation("theaurorian", "chests/runestonetowerhigh");
    private static final ResourceLocation RUNESTONETOWER_TERRAIN_TL = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_terrain_tl");
    private static final ResourceLocation RUNESTONETOWER_TERRAIN_TR = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_terrain_tr");
    private static final ResourceLocation RUNESTONETOWER_TERRAIN_BL = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_terrain_bl");
    private static final ResourceLocation RUNESTONETOWER_TERRAIN_BR = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_terrain_br");
    private static final ResourceLocation RUNESTONETOWER_BASE_TL = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_base_tlv2");
    private static final ResourceLocation RUNESTONETOWER_BASE_TR = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_base_trv2");
    private static final ResourceLocation RUNESTONETOWER_BASE_BL = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_base_blv2");
    private static final ResourceLocation RUNESTONETOWER_BASE_BR = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_base_brv2");
    private static final ResourceLocation RUNESTONETOWER_FLOOR_TL = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_floor_tlv2");
    private static final ResourceLocation RUNESTONETOWER_FLOOR_TR = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_floor_trv2");
    private static final ResourceLocation RUNESTONETOWER_FLOOR_BL = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_floor_blv2");
    private static final ResourceLocation RUNESTONETOWER_FLOOR_BR = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_floor_brv2");
    private static final ResourceLocation RUNESTONETOWER_FLOOR2_TL = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_floor_2_tlv2");
    private static final ResourceLocation RUNESTONETOWER_FLOOR2_TR = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_floor_2_trv2");
    private static final ResourceLocation RUNESTONETOWER_FLOOR2_BL = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_floor_2_blv2");
    private static final ResourceLocation RUNESTONETOWER_FLOOR2_BR = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_floor_2_brv2");
    private static final ResourceLocation RUNESTONETOWER_TOP_TL = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_top_tlv2");
    private static final ResourceLocation RUNESTONETOWER_TOP_TR = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_top_trv2");
    private static final ResourceLocation RUNESTONETOWER_TOP_BL = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_top_blv2");
    private static final ResourceLocation RUNESTONETOWER_TOP_BR = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_top_brv2");
    public static int FLOOR_COUNT = TAConfig.Config_RunestoneDungeonFloors;
    public static int CHUNKS_BETWEEN_TOWERS = TAConfig.Config_DungeonDensity;
    public static boolean GENERATE_TOWERS = TAConfig.Config_GenerateRunestoneDungeon;

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        Chunk c = worldIn.func_175726_f(position);
        this.generateTower(worldIn, c, rand);
        return true;
    }

    @Override
    public boolean isValidChunkForGen(int chunkX, int chunkZ, int offsetX, int offsetZ) {
        return (chunkX + offsetX) % CHUNKS_BETWEEN_TOWERS == 0 && (chunkZ + offsetZ) % CHUNKS_BETWEEN_TOWERS == 0;
    }

    private int getDungeonBaseHeight(World world, int x, int z, int part) {
        int x1 = x;
        int i = world.func_72800_K();
        int z1 = z;
        switch (part) {
            case 1: {
                x1 += 30;
                break;
            }
            case 2: {
                x1 += 30;
                z1 += 17;
                break;
            }
            case 3: {
                x1 += 15;
                break;
            }
            case 4: {
                x1 += 15;
                z1 += 15;
            }
        }
        Block blk = world.func_180495_p(new BlockPos(x1, i, z1)).func_177230_c();
        while (blk == Blocks.field_150350_a || blk == TABlocks.silentwoodleaves || blk == TABlocks.silentwoodlog || blk instanceof BlockBush && i > 0) {
            blk = world.func_180495_p(new BlockPos(x1, --i, z1)).func_177230_c();
        }
        return i + 1;
    }

    private void populateFloorChests(Chunk c, int heightmin, int heightmax, ResourceLocation loot, Random r) {
        Chunk c1 = c.func_177412_p().func_72964_e(c.field_76635_g + 1, c.field_76647_h + 1);
        Chunk c2 = c.func_177412_p().func_72964_e(c.field_76635_g + 1, c.field_76647_h);
        Chunk c3 = c.func_177412_p().func_72964_e(c.field_76635_g, c.field_76647_h + 1);
        for (int y = heightmin; y <= heightmax; ++y) {
            GenerationHelper.populateChestsInChunkAtHeight(c, y, r, loot, false);
            GenerationHelper.populateChestsInChunkAtHeight(c1, y, r, loot, false);
            GenerationHelper.populateChestsInChunkAtHeight(c2, y, r, loot, false);
            GenerationHelper.populateChestsInChunkAtHeight(c3, y, r, loot, false);
        }
    }

    private boolean generateTower(World world, Chunk c, Random r) {
        if (FLOOR_COUNT % 2 != 0) {
            ++FLOOR_COUNT;
        }
        boolean gen = false;
        int chunkX = c.field_76635_g;
        int chunkZ = c.field_76647_h;
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        int y = 86;
        PlacementSettings settings = new PlacementSettings().func_186220_a(Rotation.NONE).func_186225_a((Block)TABlocks.aurorianstone);
        PlacementSettings settingsrotated = new PlacementSettings().func_186220_a(Rotation.CLOCKWISE_180).func_186225_a((Block)TABlocks.aurorianstone);
        Template floor_tl = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), RUNESTONETOWER_FLOOR_TL);
        Template floor_br = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), RUNESTONETOWER_FLOOR_BR);
        Template floor_tr = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), RUNESTONETOWER_FLOOR_TR);
        Template floor_bl = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), RUNESTONETOWER_FLOOR_BL);
        Template floor2_tl = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), RUNESTONETOWER_FLOOR2_TL);
        Template floor2_br = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), RUNESTONETOWER_FLOOR2_BR);
        Template floor2_tr = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), RUNESTONETOWER_FLOOR2_TR);
        Template floor2_bl = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), RUNESTONETOWER_FLOOR2_BL);
        if (this.isValidChunkForGen(chunkX, chunkZ, 1, -1)) {
            Template terrain_tl = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), RUNESTONETOWER_TERRAIN_TL);
            Template base_tl = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), RUNESTONETOWER_BASE_TL);
            Template top_tl = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), RUNESTONETOWER_TOP_TL);
            Template top_br = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), RUNESTONETOWER_TOP_BR);
            for (int i = y = this.getDungeonBaseHeight(world, x + 1, z, 1); i >= 50; --i) {
                terrain_tl.func_186253_b(world, new BlockPos(x + 1, i - 1, z), settings);
            }
            base_tl.func_186253_b(world, new BlockPos(x + 1, y, z), settings);
            boolean alt = true;
            int floor = 1;
            while (floor <= FLOOR_COUNT) {
                if (alt) {
                    floor_tl.func_186253_b(world, new BlockPos(x + 1, y + 6 * floor, z), settings);
                    ++floor;
                    alt = !alt;
                    continue;
                }
                floor2_br.func_186253_b(world, new BlockPos(x + 1 + 14, y + 6 * floor, z + 14), settingsrotated);
                ++floor;
                ++floor;
                alt = !alt;
            }
            int bossfloorlevel = y + 6 * floor;
            if (alt) {
                top_tl.func_186253_b(world, new BlockPos(x + 1, bossfloorlevel, z), settings);
            } else {
                top_br.func_186253_b(world, new BlockPos(x + 1 + 14, bossfloorlevel, z + 14), settingsrotated);
            }
            this.populateFloorChests(c, y, y + 6 * floor / 2, RUNESTONETOWER_LOOTTABLELOW, r);
            this.populateFloorChests(c, y + 6 * floor / 2, bossfloorlevel, RUNESTONETOWER_LOOTTABLEMED, r);
            this.populateFloorChests(c, bossfloorlevel, bossfloorlevel + 15, RUNESTONETOWER_LOOTTABLEHIGH, r);
            gen = true;
        } else if (this.isValidChunkForGen(chunkX, chunkZ, 1, 0)) {
            Template terrain_tr = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), RUNESTONETOWER_TERRAIN_TR);
            Template base_tr = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), RUNESTONETOWER_BASE_TR);
            Template top_tr = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), RUNESTONETOWER_TOP_TR);
            Template top_bl = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), RUNESTONETOWER_TOP_BL);
            for (int i = y = this.getDungeonBaseHeight(world, x + 1, z - 1, 2); i >= 50; --i) {
                terrain_tr.func_186253_b(world, new BlockPos(x + 1, i - 1, z + 1), settings);
            }
            base_tr.func_186253_b(world, new BlockPos(x + 1, y, z + 1), settings);
            boolean alt = true;
            int floor = 1;
            while (floor <= FLOOR_COUNT) {
                if (alt) {
                    floor_tr.func_186253_b(world, new BlockPos(x + 1, y + 6 * floor, z + 1), settings);
                    ++floor;
                    alt = !alt;
                    continue;
                }
                floor2_bl.func_186253_b(world, new BlockPos(x + 1 + 14, y + 6 * floor, z + 1 + 14), settingsrotated);
                ++floor;
                ++floor;
                alt = !alt;
            }
            int bossfloorlevel = y + 6 * floor;
            if (alt) {
                top_tr.func_186253_b(world, new BlockPos(x + 1, bossfloorlevel, z + 1), settings);
            } else {
                top_bl.func_186253_b(world, new BlockPos(x + 1 + 14, bossfloorlevel, z + 1 + 14), settingsrotated);
            }
            this.populateFloorChests(c, y, y + 6 * floor / 2, RUNESTONETOWER_LOOTTABLELOW, r);
            this.populateFloorChests(c, y + 6 * floor / 2, bossfloorlevel, RUNESTONETOWER_LOOTTABLEMED, r);
            this.populateFloorChests(c, bossfloorlevel, bossfloorlevel + 15, RUNESTONETOWER_LOOTTABLEHIGH, r);
            gen = true;
        } else if (this.isValidChunkForGen(chunkX, chunkZ, 0, -1)) {
            Template terrain_bl = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), RUNESTONETOWER_TERRAIN_BL);
            Template base_bl = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), RUNESTONETOWER_BASE_BL);
            Template top_bl = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), RUNESTONETOWER_TOP_BL);
            Template top_tr = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), RUNESTONETOWER_TOP_TR);
            for (int i = y = this.getDungeonBaseHeight(world, x, z, 3); i >= 50; --i) {
                terrain_bl.func_186253_b(world, new BlockPos(x, i - 1, z), settings);
            }
            base_bl.func_186253_b(world, new BlockPos(x, y, z), settings);
            boolean alt = true;
            int floor = 1;
            while (floor <= FLOOR_COUNT) {
                if (alt) {
                    floor_bl.func_186253_b(world, new BlockPos(x, y + 6 * floor, z), settings);
                    ++floor;
                    alt = !alt;
                    continue;
                }
                floor2_tr.func_186253_b(world, new BlockPos(x + 14, y + 6 * floor, z + 14), settingsrotated);
                ++floor;
                ++floor;
                alt = !alt;
            }
            int bossfloorlevel = y + 6 * floor;
            if (alt) {
                top_bl.func_186253_b(world, new BlockPos(x, bossfloorlevel, z), settings);
            } else {
                top_tr.func_186253_b(world, new BlockPos(x + 14, bossfloorlevel, z + 14), settingsrotated);
            }
            this.populateFloorChests(c, y, y + 6 * floor / 2, RUNESTONETOWER_LOOTTABLELOW, r);
            this.populateFloorChests(c, y + 6 * floor / 2, bossfloorlevel, RUNESTONETOWER_LOOTTABLEMED, r);
            this.populateFloorChests(c, bossfloorlevel, bossfloorlevel + 15, RUNESTONETOWER_LOOTTABLEHIGH, r);
            gen = true;
        } else if (this.isValidChunkForGen(chunkX, chunkZ, 0, 0)) {
            Template terrain_br = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), RUNESTONETOWER_TERRAIN_BR);
            Template base_br = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), RUNESTONETOWER_BASE_BR);
            Template top_br = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), RUNESTONETOWER_TOP_BR);
            Template top_tl = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), RUNESTONETOWER_TOP_TL);
            for (int i = y = this.getDungeonBaseHeight(world, x, z + 1, 4); i >= 50; --i) {
                terrain_br.func_186253_b(world, new BlockPos(x, i, z + 1), settings);
            }
            base_br.func_186253_b(world, new BlockPos(x, y, z + 1), settings);
            boolean alt = true;
            int floor = 1;
            while (floor <= FLOOR_COUNT) {
                if (alt) {
                    floor_br.func_186253_b(world, new BlockPos(x, y + 6 * floor, z + 1), settings);
                    ++floor;
                    alt = !alt;
                    continue;
                }
                floor2_tl.func_186253_b(world, new BlockPos(x + 14, y + 6 * floor, z + 1 + 14), settingsrotated);
                ++floor;
                ++floor;
                alt = !alt;
            }
            int bossfloorlevel = y + 6 * floor;
            if (alt) {
                top_br.func_186253_b(world, new BlockPos(x, bossfloorlevel, z + 1), settings);
            } else {
                top_tl.func_186253_b(world, new BlockPos(x + 14, bossfloorlevel, z + 1 + 14), settingsrotated);
            }
            this.populateFloorChests(c, y, y + 6 * floor / 2, RUNESTONETOWER_LOOTTABLELOW, r);
            this.populateFloorChests(c, y + 6 * floor / 2, bossfloorlevel, RUNESTONETOWER_LOOTTABLEMED, r);
            this.populateFloorChests(c, bossfloorlevel, bossfloorlevel + 15, RUNESTONETOWER_LOOTTABLEHIGH, r);
            gen = true;
        }
        return gen;
    }
}

