/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.transport.pipe;

import buildcraft.api.transport.pipe.EnumPipeColourType;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.PipeApi;
import buildcraft.api.transport.pipe.PipeBehaviour;
import buildcraft.api.transport.pipe.PipeFaceTex;
import buildcraft.api.transport.pipe.PipeFlowType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public final class PipeDefinition {
    public final ResourceLocation identifier;
    public final IPipeCreator logicConstructor;
    public final IPipeLoader logicLoader;
    public final PipeFlowType flowType;
    public final String[] textures;
    @Deprecated
    public final int itemTextureTop;
    @Deprecated
    public final int itemTextureCenter;
    @Deprecated
    public final int itemTextureBottom;
    public final PipeFaceTex itemModelTop;
    public final PipeFaceTex itemModelCenter;
    public final PipeFaceTex itemModelBottom;
    public final boolean canBeColoured;
    private EnumPipeColourType colourType;

    public PipeDefinition(PipeDefinitionBuilder builder) {
        this.identifier = builder.identifier;
        this.textures = new String[builder.textureSuffixes.length];
        for (int i = 0; i < this.textures.length; ++i) {
            this.textures[i] = builder.texturePrefix + builder.textureSuffixes[i];
        }
        this.logicConstructor = builder.logicConstructor;
        this.logicLoader = builder.logicLoader;
        this.flowType = builder.flowType;
        this.itemTextureTop = builder.itemTextureTop;
        this.itemTextureCenter = builder.itemTextureCenter;
        this.itemTextureBottom = builder.itemTextureBottom;
        this.itemModelBottom = builder.itemModelBottom;
        this.itemModelCenter = builder.itemModelCenter;
        this.itemModelTop = builder.itemModelTop;
        this.canBeColoured = builder.canBeColoured;
        this.colourType = builder.colourType;
    }

    @Nonnull
    public EnumPipeColourType getColourType() {
        if (this.colourType != null) {
            return this.colourType;
        }
        if (this.flowType.fallbackColourType != null) {
            return this.flowType.fallbackColourType;
        }
        return EnumPipeColourType.TRANSLUCENT;
    }

    public void setColourType(@Nullable EnumPipeColourType colourType) {
        this.colourType = colourType;
    }

    public static class PipeDefinitionBuilder {
        public ResourceLocation identifier;
        public String texturePrefix;
        public String[] textureSuffixes = new String[]{""};
        public IPipeCreator logicConstructor;
        public IPipeLoader logicLoader;
        public PipeFlowType flowType;
        @Deprecated
        public int itemTextureTop = 0;
        @Deprecated
        public int itemTextureCenter = 0;
        @Deprecated
        public int itemTextureBottom = 0;
        public PipeFaceTex itemModelTop = PipeFaceTex.get(0);
        public PipeFaceTex itemModelCenter = PipeFaceTex.get(0);
        public PipeFaceTex itemModelBottom = PipeFaceTex.get(0);
        public boolean canBeColoured;
        public EnumPipeColourType colourType;

        public PipeDefinitionBuilder() {
        }

        public PipeDefinitionBuilder(ResourceLocation identifier, IPipeCreator logicConstructor, IPipeLoader logicLoader, PipeFlowType flowType) {
            this.identifier = identifier;
            this.logicConstructor = logicConstructor;
            this.logicLoader = logicLoader;
            this.flowType = flowType;
        }

        public PipeDefinitionBuilder idTexPrefix(String both) {
            return this.id(both).texPrefix(both);
        }

        public PipeDefinitionBuilder idTex(String both) {
            return this.id(both).tex(both, new String[0]);
        }

        private static String getActiveModId() {
            ModContainer mod = Loader.instance().activeModContainer();
            if (mod == null) {
                throw new IllegalStateException("Cannot interact with PipeDefinition outside of an actively scoped mod!");
            }
            return mod.getModId();
        }

        public PipeDefinitionBuilder id(String post) {
            this.identifier = new ResourceLocation(PipeDefinitionBuilder.getActiveModId(), post);
            return this;
        }

        public PipeDefinitionBuilder tex(String prefix, String ... suffixes) {
            return this.texPrefix(prefix).texSuffixes(suffixes);
        }

        public PipeDefinitionBuilder texPrefix(String prefix) {
            return this.texPrefixDirect(PipeDefinitionBuilder.getActiveModId() + ":pipes/" + prefix);
        }

        public PipeDefinitionBuilder texPrefixDirect(String prefix) {
            this.texturePrefix = prefix;
            return this;
        }

        public PipeDefinitionBuilder texSuffixes(String ... suffixes) {
            this.textureSuffixes = suffixes == null || suffixes.length == 0 ? new String[]{""} : suffixes;
            return this;
        }

        public PipeDefinitionBuilder itemTex(int all) {
            this.itemModelCenter = this.itemModelBottom = PipeFaceTex.get(all);
            this.itemModelTop = this.itemModelBottom;
            this.itemTextureTop = all;
            this.itemTextureCenter = all;
            this.itemTextureBottom = all;
            return this;
        }

        public PipeDefinitionBuilder itemTex(int top, int center, int bottom) {
            this.itemModelBottom = PipeFaceTex.get(bottom);
            this.itemModelCenter = PipeFaceTex.get(center);
            this.itemModelTop = PipeFaceTex.get(top);
            this.itemTextureTop = top;
            this.itemTextureCenter = center;
            this.itemTextureBottom = bottom;
            return this;
        }

        public PipeDefinitionBuilder logic(IPipeCreator creator, IPipeLoader loader) {
            this.logicConstructor = creator;
            this.logicLoader = loader;
            return this;
        }

        public PipeDefinitionBuilder disableColouring() {
            this.canBeColoured = false;
            return this;
        }

        public PipeDefinitionBuilder enableColouring(EnumPipeColourType type) {
            this.canBeColoured = true;
            this.colourType = type;
            return this;
        }

        public PipeDefinitionBuilder enableColouring() {
            return this.enableColouring(null);
        }

        public PipeDefinitionBuilder enableTranslucentColouring() {
            return this.enableColouring(EnumPipeColourType.TRANSLUCENT);
        }

        public PipeDefinitionBuilder enableBorderColouring() {
            return this.enableColouring(EnumPipeColourType.BORDER_OUTER);
        }

        public PipeDefinitionBuilder enableInnerBorderColouring() {
            return this.enableColouring(EnumPipeColourType.BORDER_INNER);
        }

        public PipeDefinitionBuilder enableCustomColouring() {
            return this.enableColouring(EnumPipeColourType.CUSTOM);
        }

        public PipeDefinitionBuilder flowItem() {
            return this.flow(PipeApi.flowItems);
        }

        public PipeDefinitionBuilder flowFluid() {
            return this.flow(PipeApi.flowFluids);
        }

        public PipeDefinitionBuilder flowPower() {
            return this.flow(PipeApi.flowPower);
        }

        public PipeDefinitionBuilder flow(PipeFlowType flow) {
            this.flowType = flow;
            return this;
        }

        public PipeDefinition define() {
            PipeDefinition def = new PipeDefinition(this);
            PipeApi.pipeRegistry.registerPipe(def);
            return def;
        }
    }

    @FunctionalInterface
    public static interface IPipeLoader {
        public PipeBehaviour loadBehaviour(IPipe var1, NBTTagCompound var2);
    }

    @FunctionalInterface
    public static interface IPipeCreator {
        public PipeBehaviour createBehaviour(IPipe var1);
    }
}

