/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.item;

import buildcraft.api.core.BCLog;
import buildcraft.api.core.InvalidInputDataException;
import buildcraft.api.schematics.ISchematicBlock;
import buildcraft.api.schematics.SchematicBlockContext;
import buildcraft.builders.snapshot.SchematicBlockManager;
import buildcraft.lib.inventory.InventoryWrapper;
import buildcraft.lib.item.ItemBC_Neptune;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.misc.SoundUtil;
import buildcraft.lib.misc.StackUtil;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSchematicSingle
extends ItemBC_Neptune {
    public static final int DAMAGE_CLEAN = 0;
    public static final int DAMAGE_USED = 1;
    public static final String NBT_KEY = "schematic";

    public ItemSchematicSingle(String id) {
        super(id);
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    public int getItemStackLimit(ItemStack stack) {
        return stack.func_77952_i() == 0 ? 16 : super.getItemStackLimit(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addModelVariants(TIntObjectHashMap<ModelResourceLocation> variants) {
        this.addVariant(variants, 0, "clean");
        this.addVariant(variants, 1, "used");
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = StackUtil.asNonNull(player.func_184586_b(hand));
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (player.func_70093_af()) {
            NBTTagCompound itemData = NBTUtilBC.getItemData(stack);
            itemData.func_82580_o(NBT_KEY);
            if (itemData.func_82582_d()) {
                stack.func_77982_d(null);
            }
            stack.func_77964_b(0);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (world.field_72995_K) {
            return EnumActionResult.PASS;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            NBTTagCompound itemData = NBTUtilBC.getItemData(StackUtil.asNonNull(stack));
            itemData.func_82580_o(NBT_KEY);
            if (itemData.func_82582_d()) {
                stack.func_77982_d(null);
            }
            stack.func_77964_b(0);
            return EnumActionResult.SUCCESS;
        }
        int damage = stack.func_77952_i();
        if (damage != 1) {
            IBlockState state = world.func_180495_p(pos);
            ISchematicBlock schematicBlock = SchematicBlockManager.getSchematicBlock(new SchematicBlockContext(world, pos, pos, state, state.func_177230_c()));
            if (schematicBlock.isAir()) {
                return EnumActionResult.FAIL;
            }
            NBTUtilBC.getItemData(stack).func_74782_a(NBT_KEY, (NBTBase)SchematicBlockManager.writeToNBT(schematicBlock));
            stack.func_77964_b(1);
            return EnumActionResult.SUCCESS;
        }
        BlockPos placePos = pos;
        boolean replaceable = world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos);
        if (!replaceable) {
            placePos = placePos.func_177972_a(side);
        }
        if (!world.func_190527_a(world.func_180495_p(pos).func_177230_c(), placePos, false, side, null)) {
            return EnumActionResult.FAIL;
        }
        if (replaceable && !world.func_175623_d(placePos)) {
            world.func_175698_g(placePos);
        }
        try {
            ISchematicBlock schematicBlock = ItemSchematicSingle.getSchematic(stack);
            if (schematicBlock != null && !schematicBlock.isBuilt(world, placePos) && schematicBlock.canBuild(world, placePos)) {
                List<FluidStack> requiredFluids = schematicBlock.computeRequiredFluids();
                List<ItemStack> requiredItems = schematicBlock.computeRequiredItems();
                if (requiredFluids.isEmpty()) {
                    InventoryWrapper itemTransactor = new InventoryWrapper((IInventory)player.field_71071_by);
                    if (StackUtil.mergeSameItems(requiredItems).stream().noneMatch(s -> itemTransactor.extract(extracted -> StackUtil.canMerge(s, extracted), s.func_190916_E(), s.func_190916_E(), true).func_190926_b())) {
                        if (schematicBlock.build(world, placePos)) {
                            StackUtil.mergeSameItems(requiredItems).forEach(s -> itemTransactor.extract(extracted -> StackUtil.canMerge(s, extracted), s.func_190916_E(), s.func_190916_E(), false));
                            SoundUtil.playBlockPlace(world, placePos);
                            player.func_184609_a(hand);
                            return EnumActionResult.SUCCESS;
                        }
                    } else {
                        player.func_146105_b((ITextComponent)new TextComponentString("Not enough items. Total needed: " + StackUtil.mergeSameItems(requiredItems).stream().map(s -> s.func_151000_E().func_150254_d() + " x " + s.func_190916_E()).collect(Collectors.joining(", "))), true);
                    }
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentString("Schematic requires fluids"), true);
                }
            }
        }
        catch (InvalidInputDataException e) {
            player.func_146105_b((ITextComponent)new TextComponentString("Invalid schematic: " + e.getMessage()), true);
            e.printStackTrace();
        }
        return EnumActionResult.FAIL;
    }

    public static ISchematicBlock getSchematic(@Nonnull ItemStack stack) throws InvalidInputDataException {
        if (stack.func_77973_b() instanceof ItemSchematicSingle) {
            return SchematicBlockManager.readFromNBT(NBTUtilBC.getItemData(stack).func_74775_l(NBT_KEY));
        }
        return null;
    }

    public static ISchematicBlock getSchematicSafe(@Nonnull ItemStack stack) {
        try {
            return ItemSchematicSingle.getSchematic(stack);
        }
        catch (InvalidInputDataException e) {
            BCLog.logger.warn("Invalid schematic " + e.getMessage());
            return null;
        }
    }
}

