/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.world;

import buildcraft.lib.client.guide.world.WorldInfo;
import buildcraft.lib.client.guide.world.WorldLabel;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.vecmath.Vector3f;

public class WorldState {
    private final Vector3f cameraPos;
    private final double cameraYaw;
    private final double cameraPitch;
    private final List<WorldLabel> labels;

    public WorldState(WorldInfo info) {
        byte[] schematic = info.getSchematic();
        this.labels = ImmutableList.copyOf((Object[])info.labels);
        this.cameraPos = null;
        double xDiff = (double)this.cameraPos.x - info.cameraFacing.field_72450_a;
        double yDiff = (double)this.cameraPos.y - info.cameraFacing.field_72448_b;
        double zDiff = (double)this.cameraPos.z - info.cameraFacing.field_72449_c;
        double opposite = Math.abs(yDiff);
        double adjacent = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
        this.cameraPitch = Math.atan2(adjacent, opposite);
        this.cameraYaw = Math.atan2(zDiff, xDiff) - 1.5707963267948966;
    }
}

