/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.config;

import buildcraft.api.core.BCLog;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.NodeTypes;
import buildcraft.lib.gui.config.GuiConfigManager;
import buildcraft.lib.gui.config.GuiProperty;
import buildcraft.lib.gui.config.GuiPropertyConstructor;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.TreeMap;

class GuiConfigEntry {
    final String name;
    final Map<String, GuiProperty> typeToProperty = new TreeMap<String, GuiProperty>();

    GuiConfigEntry(String name) {
        this.name = name;
    }

    GuiProperty getOrAdd(IExpressionNode value) {
        String type = NodeTypes.getName(NodeTypes.getType(value));
        GuiProperty prop = this.typeToProperty.get(type);
        if (prop == null) {
            GuiPropertyConstructor constructor = GuiConfigManager.customGuiProperties.get(type);
            if (constructor == null) {
                throw new IllegalArgumentException("No support for '" + type + "' has been added!\n\tSupported types are: " + GuiConfigManager.customGuiProperties.keySet());
            }
            prop = constructor.create(this.name);
            prop.set(value);
            this.typeToProperty.put(type, prop);
            GuiConfigManager.markDirty();
        }
        return prop;
    }

    JsonObject writeToJson() {
        JsonObject json = new JsonObject();
        for (Map.Entry<String, GuiProperty> entry : this.typeToProperty.entrySet()) {
            json.add(entry.getKey(), entry.getValue().writeToJson());
        }
        return json;
    }

    void readFromJson(JsonObject json) {
        for (Map.Entry entry : json.entrySet()) {
            String type = (String)entry.getKey();
            JsonElement elem = (JsonElement)entry.getValue();
            Class<?> clazz = NodeTypes.getType(type);
            if (clazz == null) {
                BCLog.logger.warn("[lib.gui.config] Unknown NodeType '" + type + "' - must be one of " + NodeTypes.getValidTypeNames());
                continue;
            }
            GuiProperty current = this.typeToProperty.get(type);
            if (current == null) {
                current = this.getOrAdd(NodeTypes.makeVariableNode(clazz, this.name));
            }
            current.readFromJson(elem);
        }
    }
}

