/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.marker;

import buildcraft.api.core.BCLog;
import buildcraft.lib.marker.MarkerConnection;
import buildcraft.lib.marker.MarkerSubCache;
import buildcraft.lib.misc.NBTUtilBC;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.storage.WorldSavedData;

public abstract class MarkerSavedData<S extends MarkerSubCache<C>, C extends MarkerConnection<C>>
extends WorldSavedData {
    protected static final boolean DEBUG_FULL = MarkerSubCache.DEBUG_FULL;
    protected final List<BlockPos> markerPositions = new ArrayList<BlockPos>();
    protected final List<List<BlockPos>> markerConnections = new ArrayList<List<BlockPos>>();
    private S subCache;

    public MarkerSavedData(String name) {
        super(name);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.markerPositions.clear();
        this.markerConnections.clear();
        NBTTagList positionList = (NBTTagList)nbt.func_74781_a("positions");
        for (int i = 0; i < positionList.func_74745_c(); ++i) {
            this.markerPositions.add(NBTUtilBC.readBlockPos(positionList.func_179238_g(i)));
        }
        NBTTagList connectionList = (NBTTagList)nbt.func_74781_a("connections");
        for (int i = 0; i < connectionList.func_74745_c(); ++i) {
            positionList = (NBTTagList)connectionList.func_179238_g(i);
            ArrayList<BlockPos> arrayList = new ArrayList<BlockPos>();
            this.markerConnections.add(arrayList);
            for (int j = 0; j < positionList.func_74745_c(); ++j) {
                arrayList.add(NBTUtilBC.readBlockPos(positionList.func_179238_g(j)));
            }
        }
        if (DEBUG_FULL) {
            BCLog.logger.info("[lib.marker.full] Reading from NBT (" + this.field_76190_i + ")");
            BCLog.logger.info("[lib.marker.full]  - Positions:");
            for (BlockPos blockPos : this.markerPositions) {
                BCLog.logger.info("[lib.marker.full]   - " + blockPos);
            }
            BCLog.logger.info("[lib.marker.full]  - Connections:");
            for (List list : this.markerConnections) {
                BCLog.logger.info("[lib.marker.full]   - Single Connection:");
                for (BlockPos pos : list) {
                    BCLog.logger.info("[lib.marker.full]     - " + pos);
                }
            }
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        this.markerPositions.clear();
        this.markerConnections.clear();
        this.markerPositions.addAll((Collection<BlockPos>)((MarkerSubCache)this.subCache).getAllMarkers());
        for (Object connection : ((MarkerSubCache)this.subCache).getConnections()) {
            this.markerConnections.add(new ArrayList<BlockPos>(((MarkerConnection)connection).getMarkerPositions()));
        }
        NBTTagList positionList = new NBTTagList();
        for (BlockPos p : this.markerPositions) {
            positionList.func_74742_a((NBTBase)NBTUtilBC.writeBlockPos(p));
        }
        nbt.func_74782_a("positions", (NBTBase)positionList);
        NBTTagList connectionList = new NBTTagList();
        for (List<BlockPos> connection : this.markerConnections) {
            NBTTagList inner = new NBTTagList();
            for (BlockPos p : connection) {
                inner.func_74742_a((NBTBase)NBTUtilBC.writeBlockPos(p));
            }
            connectionList.func_74742_a((NBTBase)inner);
        }
        nbt.func_74782_a("connections", (NBTBase)connectionList);
        if (DEBUG_FULL) {
            BCLog.logger.info("[lib.marker.full] Writing to NBT (" + this.field_76190_i + ")");
            BCLog.logger.info("[lib.marker.full]  - Positions:");
            for (BlockPos pos : this.markerPositions) {
                BCLog.logger.info("[lib.marker.full]   - " + pos);
            }
            BCLog.logger.info("[lib.marker.full]  - Connections:");
            for (List<BlockPos> list : this.markerConnections) {
                BCLog.logger.info("[lib.marker.full]   - Single Connection:");
                for (BlockPos pos : list) {
                    BCLog.logger.info("[lib.marker.full]     - " + pos);
                }
            }
        }
        return nbt;
    }

    public boolean func_76188_b() {
        return true;
    }

    public final void setCache(S subCache) {
        this.subCache = subCache;
    }
}

