/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.base;

import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import svenhjol.charm.base.CharmLoadingPlugin;
import svenhjol.meson.asm.ClassNameMap;
import svenhjol.meson.asm.MesonClassTransformer;

public class CharmClassTransformer
extends MesonClassTransformer {
    private static final String ASM_HOOKS = "svenhjol/charm/base/ASMHooks";
    private static int countTransformTileEntityBeacon;
    private static int countTransformISpecialArmor;
    private static int countTransformContainerRepair;

    private static byte[] transformContainerFurnace(byte[] basicClass) {
        if (!CharmClassTransformer.checkTransformers(CharmLoadingPlugin.configAsm, "ContainerFurnace")) {
            return basicClass;
        }
        CharmClassTransformer.log("Transforming ContainerFurnace");
        MesonClassTransformer.MethodSignature init = new MesonClassTransformer.MethodSignature("<init>", "<init>", "", "(Lnet/minecraft/entity/player/InventoryPlayer;Lnet/minecraft/inventory/IInventory;)V");
        byte[] transClass = basicClass;
        transClass = CharmClassTransformer.transform(transClass, Pair.of((Object)init, (Object)CharmClassTransformer.combine(node -> node.getOpcode() == 187, (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new TypeInsnNode(187, "svenhjol/charm/tweaks/inventory/SlotFurnaceInput"));
            method.instructions.insert(node, newInstructions);
            method.instructions.remove(node);
            return true;
        })));
        transClass = CharmClassTransformer.transform(transClass, Pair.of((Object)init, (Object)CharmClassTransformer.combine(node -> node.getOpcode() == 183 && node.getNext().getOpcode() == 182, (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(183, "svenhjol/charm/tweaks/inventory/SlotFurnaceInput", "<init>", "(Lnet/minecraft/inventory/IInventory;III)V", false));
            method.instructions.insert(node, newInstructions);
            method.instructions.remove(node);
            return true;
        })));
        return transClass;
    }

    private static byte[] transformTileEntityFurnace(byte[] basicClass) {
        if (!CharmClassTransformer.checkTransformers(CharmLoadingPlugin.configAsm, "TileEntityFurnace")) {
            return basicClass;
        }
        CharmClassTransformer.log("Transforming TileEntityFurnace");
        MesonClassTransformer.MethodSignature smeltItem = new MesonClassTransformer.MethodSignature("smeltItem", "func_145949_j", "o", "()V");
        MesonClassTransformer.MethodSignature isItemValidForSlot = new MesonClassTransformer.MethodSignature("isItemValidForSlot", "func_94041_b", "b", "(ILnet/minecraft/item/ItemStack;)Z");
        byte[] transClass = basicClass;
        transClass = CharmClassTransformer.transform(transClass, Pair.of((Object)smeltItem, (Object)CharmClassTransformer.combine(node -> node.getOpcode() == 58 && ((VarInsnNode)node).var == 2, (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "changeSmeltingResult", "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/item/ItemStack;)Lnet/minecraft/item/ItemStack;", false));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(58, 2));
            method.instructions.insert(node, newInstructions);
            return true;
        })));
        transClass = CharmClassTransformer.transform(transClass, Pair.of((Object)isItemValidForSlot, (Object)CharmClassTransformer.combine(node -> node.getOpcode() == 21 && ((VarInsnNode)node).var == 1, (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
            LabelNode label = new LabelNode();
            newInstructions.add((AbstractInsnNode)new JumpInsnNode(154, label));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "canSmelt", "(Lnet/minecraft/item/ItemStack;)Z", false));
            newInstructions.add((AbstractInsnNode)new InsnNode(172));
            newInstructions.add((AbstractInsnNode)label);
            method.instructions.insertBefore(node, newInstructions);
            return true;
        })));
        return transClass;
    }

    private static byte[] transformItemChorusFruit(byte[] basicClass) {
        if (!CharmClassTransformer.checkTransformers(CharmLoadingPlugin.configAsm, "ItemChorusFruit")) {
            return basicClass;
        }
        CharmClassTransformer.log("Transforming ItemChorusFruit");
        MesonClassTransformer.MethodSignature onItemUseFinish = new MesonClassTransformer.MethodSignature("onItemUseFinish", "func_77654_b", "a", "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/world/World;Lnet/minecraft/entity/EntityLivingBase;)Lnet/minecraft/item/ItemStack;");
        byte[] transClass = basicClass;
        transClass = CharmClassTransformer.transform(transClass, Pair.of((Object)onItemUseFinish, (Object)CharmClassTransformer.combine(node -> node.getOpcode() == 154, (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 3));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "onChorusFruitEaten", "(Lnet/minecraft/world/World;Lnet/minecraft/entity/EntityLivingBase;)Z", false));
            newInstructions.add((AbstractInsnNode)new JumpInsnNode(154, ((JumpInsnNode)node).label));
            method.instructions.insert(node, newInstructions);
            return true;
        })));
        return transClass;
    }

    private static byte[] transformItemToolMaterial(byte[] basicClass) {
        if (!CharmClassTransformer.checkTransformers(CharmLoadingPlugin.configAsm, "ItemToolMaterial")) {
            return basicClass;
        }
        CharmClassTransformer.log("Transforming ItemToolMaterial");
        MesonClassTransformer.MethodSignature getMaxUses = new MesonClassTransformer.MethodSignature("getMaxUses", "func_77997_a", "a", "()I");
        MesonClassTransformer.MethodSignature getEfficiency = new MesonClassTransformer.MethodSignature("getEfficiency", "func_77998_b", "b", "()F");
        MesonClassTransformer.MethodSignature getAttackDamage = new MesonClassTransformer.MethodSignature("getAttackDamage", "func_78000_c", "c", "()F");
        MesonClassTransformer.MethodSignature getHarvestLevel = new MesonClassTransformer.MethodSignature("getHarvestLevel", "func_77996_d", "d", "()I");
        MesonClassTransformer.MethodSignature getEnchantability = new MesonClassTransformer.MethodSignature("getEnchantability", "func_77995_e", "e", "()I");
        byte[] transClass = basicClass;
        transClass = CharmClassTransformer.transform(transClass, Pair.of((Object)getMaxUses, (Object)CharmClassTransformer.combine(node -> node.getOpcode() == 180, (method, node) -> {
            InsnList before = new InsnList();
            InsnList after = new InsnList();
            before.add((AbstractInsnNode)new VarInsnNode(25, 0));
            method.instructions.insertBefore(node, before);
            after.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "getToolMaterialMaxUses", "(Lnet/minecraft/item/Item$ToolMaterial;I)I", false));
            method.instructions.insert(node, after);
            return true;
        })));
        transClass = CharmClassTransformer.transform(transClass, Pair.of((Object)getEfficiency, (Object)CharmClassTransformer.combine(node -> node.getOpcode() == 180, (method, node) -> {
            InsnList before = new InsnList();
            InsnList after = new InsnList();
            before.add((AbstractInsnNode)new VarInsnNode(25, 0));
            method.instructions.insertBefore(node, before);
            after.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "getToolMaterialEfficiency", "(Lnet/minecraft/item/Item$ToolMaterial;F)F", false));
            method.instructions.insert(node, after);
            return true;
        })));
        transClass = CharmClassTransformer.transform(transClass, Pair.of((Object)getAttackDamage, (Object)CharmClassTransformer.combine(node -> node.getOpcode() == 180, (method, node) -> {
            InsnList before = new InsnList();
            InsnList after = new InsnList();
            before.add((AbstractInsnNode)new VarInsnNode(25, 0));
            method.instructions.insertBefore(node, before);
            after.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "getToolMaterialAttackDamage", "(Lnet/minecraft/item/Item$ToolMaterial;F)F", false));
            method.instructions.insert(node, after);
            return true;
        })));
        transClass = CharmClassTransformer.transform(transClass, Pair.of((Object)getHarvestLevel, (Object)CharmClassTransformer.combine(node -> node.getOpcode() == 180, (method, node) -> {
            InsnList before = new InsnList();
            InsnList after = new InsnList();
            before.add((AbstractInsnNode)new VarInsnNode(25, 0));
            method.instructions.insertBefore(node, before);
            after.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "getToolMaterialHarvestLevel", "(Lnet/minecraft/item/Item$ToolMaterial;I)I", false));
            method.instructions.insert(node, after);
            return true;
        })));
        transClass = CharmClassTransformer.transform(transClass, Pair.of((Object)getEnchantability, (Object)CharmClassTransformer.combine(node -> node.getOpcode() == 180, (method, node) -> {
            InsnList before = new InsnList();
            InsnList after = new InsnList();
            before.add((AbstractInsnNode)new VarInsnNode(25, 0));
            method.instructions.insertBefore(node, before);
            after.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "getToolMaterialEnchantability", "(Lnet/minecraft/item/Item$ToolMaterial;I)I", false));
            method.instructions.insert(node, after);
            return true;
        })));
        return transClass;
    }

    private static byte[] transformTileEntityBeacon(byte[] basicClass) {
        if (!CharmClassTransformer.checkTransformers(CharmLoadingPlugin.configAsm, "TileEntityBeacon")) {
            return basicClass;
        }
        CharmClassTransformer.log("Transforming TileEntityBeacon");
        MesonClassTransformer.MethodSignature addEffectsToPlayers = new MesonClassTransformer.MethodSignature("addEffectsToPlayers", "func_146000_x", "E", "()V");
        byte[] transClass = basicClass;
        transClass = CharmClassTransformer.transform(transClass, Pair.of((Object)addEffectsToPlayers, (Object)CharmClassTransformer.combine(node -> node.getOpcode() == 25 && ((VarInsnNode)node).var == 9 && ++countTransformTileEntityBeacon == 2, (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            newInstructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/tileentity/TileEntityBeacon", CharmClassTransformer.obf() ? "field_145850_b" : "world", "Lnet/minecraft/world/World;"));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 8));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            newInstructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/tileentity/TileEntityBeacon", CharmClassTransformer.obf() ? "field_146013_m" : "primaryEffect", "Lnet/minecraft/potion/Potion;"));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            newInstructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/tileentity/TileEntityBeacon", CharmClassTransformer.obf() ? "field_146010_n" : "secondaryEffect", "Lnet/minecraft/potion/Potion;"));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(21, 4));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(21, 3));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "addBeaconEffect", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/AxisAlignedBB;Lnet/minecraft/potion/Potion;Lnet/minecraft/potion/Potion;II)V", false));
            method.instructions.insertBefore(node, newInstructions);
            return true;
        })));
        return transClass;
    }

    private static byte[] transformTileEntityShulkerBox(byte[] basicClass) {
        if (!CharmClassTransformer.checkTransformers(CharmLoadingPlugin.configAsm, "TileEntityShulkerBox")) {
            return basicClass;
        }
        CharmClassTransformer.log("Transforming TileEntityShulkerBox");
        MesonClassTransformer.MethodSignature canInsertItem = new MesonClassTransformer.MethodSignature("canInsertItem", "func_180462_a", "a", "(ILnet/minecraft/item/ItemStack;Lnet/minecraft/util/EnumFacing;)Z");
        byte[] transClass = basicClass;
        transClass = CharmClassTransformer.transform(transClass, Pair.of((Object)canInsertItem, (Object)CharmClassTransformer.combine(node -> node.getOpcode() == 25 && ((VarInsnNode)node).var == 2, (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "canInsertItemIntoShulkerBox", "(Lnet/minecraft/item/ItemStack;)Z", false));
            newInstructions.add((AbstractInsnNode)new InsnNode(172));
            method.instructions = newInstructions;
            return true;
        })));
        return transClass;
    }

    private static byte[] transformSlotShulkerBox(byte[] basicClass) {
        if (!CharmClassTransformer.checkTransformers(CharmLoadingPlugin.configAsm, "SlotShulkerBox")) {
            return basicClass;
        }
        CharmClassTransformer.log("Transforming SlotShulkerBox");
        MesonClassTransformer.MethodSignature isItemValid = new MesonClassTransformer.MethodSignature("isItemValid", "func_180462_a", "a", "(Lnet/minecraft/item/ItemStack;)Z");
        byte[] transClass = basicClass;
        transClass = CharmClassTransformer.transform(transClass, Pair.of((Object)isItemValid, (Object)CharmClassTransformer.combine(node -> node.getOpcode() == 25 && ((VarInsnNode)node).var == 1, (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "canInsertItemIntoShulkerBox", "(Lnet/minecraft/item/ItemStack;)Z", false));
            newInstructions.add((AbstractInsnNode)new InsnNode(172));
            method.instructions = newInstructions;
            return true;
        })));
        return transClass;
    }

    private static byte[] transformItemHandlerHelper(byte[] basicClass) {
        if (!CharmClassTransformer.checkTransformers(CharmLoadingPlugin.configAsm, "ItemHandlerHelper")) {
            return basicClass;
        }
        CharmClassTransformer.log("Transforming ItemHandlerHelper");
        MesonClassTransformer.MethodSignature insertItem = new MesonClassTransformer.MethodSignature("insertItem", "insertItem", "", "(Lnet/minecraftforge/items/IItemHandler;Lnet/minecraft/item/ItemStack;Z)Lnet/minecraft/item/ItemStack;");
        byte[] transClass = basicClass;
        transClass = CharmClassTransformer.transform(transClass, Pair.of((Object)insertItem, (Object)CharmClassTransformer.combine(node -> node.getOpcode() == 25 && ((VarInsnNode)node).var == 0, (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "canInsertItemIntoShulkerBox", "(Lnet/minecraftforge/items/IItemHandler;Lnet/minecraft/item/ItemStack;)Z", false));
            LabelNode label = new LabelNode();
            newInstructions.add((AbstractInsnNode)new JumpInsnNode(154, label));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            newInstructions.add((AbstractInsnNode)new InsnNode(176));
            newInstructions.add((AbstractInsnNode)label);
            method.instructions.insertBefore(node, newInstructions);
            return true;
        })));
        return transClass;
    }

    private static byte[] transformISpecialArmor(byte[] basicClass) {
        if (!CharmClassTransformer.checkTransformers(CharmLoadingPlugin.configAsm, "ISpecialArmor")) {
            return basicClass;
        }
        CharmClassTransformer.log("Transforming ISpecialArmor");
        MesonClassTransformer.MethodSignature applyArmor = new MesonClassTransformer.MethodSignature("applyArmor", "applyArmor", "", "(Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/util/NonNullList;Lnet/minecraft/util/DamageSource;D)F");
        byte[] transClass = basicClass;
        transClass = CharmClassTransformer.transform(transClass, Pair.of((Object)applyArmor, (Object)CharmClassTransformer.combine(node -> node.getOpcode() == 25 && ((VarInsnNode)node).var == 1 && node.getNext().getOpcode() == 21 && ((VarInsnNode)node.getNext()).var == 12 && ++countTransformISpecialArmor == 2, (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(21, 12));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/util/NonNullList", "get", "(I)Ljava/lang/Object;", false));
            newInstructions.add((AbstractInsnNode)new TypeInsnNode(192, "net/minecraft/item/ItemStack"));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "canArmorBeSalvaged", "(Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/item/ItemStack;)V", false));
            method.instructions.insertBefore(node, newInstructions);
            return true;
        })));
        return transClass;
    }

    private static byte[] transformBrewingRecipeRegistry(byte[] basicClass) {
        if (!CharmClassTransformer.checkTransformers(CharmLoadingPlugin.configAsm, "BrewingRecipeRegistry")) {
            return basicClass;
        }
        CharmClassTransformer.log("Transforming BrewingRecipeRegistry");
        MesonClassTransformer.MethodSignature isValidInput = new MesonClassTransformer.MethodSignature("isValidInput", "isValidInput", "", "(Lnet/minecraft/item/ItemStack;)Z");
        byte[] transClass = basicClass;
        transClass = CharmClassTransformer.transform(transClass, Pair.of((Object)isValidInput, (Object)CharmClassTransformer.combine(node -> node.getOpcode() == 159, (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new JumpInsnNode(162, ((JumpInsnNode)node).label));
            method.instructions.insertBefore(node, newInstructions);
            method.instructions.remove(node);
            return true;
        })));
        return transClass;
    }

    private static byte[] transformContainerRepair(byte[] basicClass) {
        if (!CharmClassTransformer.checkTransformers(CharmLoadingPlugin.configAsm, "ContainerRepair")) {
            return basicClass;
        }
        CharmClassTransformer.log("Transforming ContainerRepair");
        MesonClassTransformer.MethodSignature updateRepairOutput = new MesonClassTransformer.MethodSignature("updateRepairOutput", "func_82848_d", "e", "()V");
        byte[] transClass = basicClass;
        transClass = CharmClassTransformer.transform(transClass, Pair.of((Object)updateRepairOutput, (Object)CharmClassTransformer.combine(node -> node.getOpcode() == 3 && node.getPrevious().getOpcode() == 25 && ((VarInsnNode)node.getPrevious()).var == 0 && ++countTransformContainerRepair == 2, (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new InsnNode(4));
            method.instructions.insert(node, newInstructions);
            method.instructions.remove(node);
            return true;
        })));
        return transClass;
    }

    private static byte[] transformContainerRepair2(byte[] basicClass) {
        if (!CharmClassTransformer.checkTransformers(CharmLoadingPlugin.configAsm, "ContainerRepair2")) {
            return basicClass;
        }
        CharmClassTransformer.log("Transforming ContainerRepair2");
        MesonClassTransformer.MethodSignature canTakeStack = new MesonClassTransformer.MethodSignature("canTakeStack", "func_82869_a", "a", "(Lnet/minecraft/entity/player/EntityPlayer;)Z");
        byte[] transClass = basicClass;
        transClass = CharmClassTransformer.transform(transClass, Pair.of((Object)canTakeStack, (Object)CharmClassTransformer.combine(node -> node.getOpcode() == 158, (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new JumpInsnNode(155, ((JumpInsnNode)node).label));
            method.instructions.insertBefore(node, newInstructions);
            method.instructions.remove(node);
            return true;
        })));
        return transClass;
    }

    private static byte[] transformLayerArmorBase(byte[] basicClass) {
        if (!CharmClassTransformer.checkTransformers(CharmLoadingPlugin.configAsm, "LayerArmorBase")) {
            return basicClass;
        }
        CharmClassTransformer.log("Transforming LayerArmorBase");
        MesonClassTransformer.MethodSignature renderArmorLayer = new MesonClassTransformer.MethodSignature("renderArmorLayer", "func_188361_a", "a", "(Lnet/minecraft/entity/EntityLivingBase;FFFFFFFLnet/minecraft/inventory/EntityEquipmentSlot;)V");
        byte[] transClass = basicClass;
        transClass = CharmClassTransformer.transform(transClass, Pair.of((Object)renderArmorLayer, (Object)CharmClassTransformer.combine(node -> node.getOpcode() == 58, (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 10));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "isArmorInvisible", "(Lnet/minecraft/entity/Entity;Lnet/minecraft/item/ItemStack;)Z", false));
            LabelNode label = new LabelNode();
            newInstructions.add((AbstractInsnNode)new JumpInsnNode(153, label));
            newInstructions.add((AbstractInsnNode)new InsnNode(177));
            newInstructions.add((AbstractInsnNode)label);
            method.instructions.insert(node, newInstructions);
            return true;
        })));
        return transClass;
    }

    private static byte[] transformEntityPlayer(byte[] basicClass) {
        if (!CharmClassTransformer.checkTransformers(CharmLoadingPlugin.configAsm, "EntityPlayer")) {
            return basicClass;
        }
        CharmClassTransformer.log("Transforming EntityPlayer");
        MesonClassTransformer.MethodSignature getArmorVisibility = new MesonClassTransformer.MethodSignature("getArmorVisibility", "func_82243_bO", "cW", "()F");
        byte[] transClass = basicClass;
        transClass = CharmClassTransformer.transform(transClass, Pair.of((Object)getArmorVisibility, (Object)CharmClassTransformer.combine(node -> node.getOpcode() == 132, (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 3));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "isArmorInvisible", "(Lnet/minecraft/entity/Entity;Lnet/minecraft/item/ItemStack;)Z", false));
            LabelNode label = new LabelNode();
            newInstructions.add((AbstractInsnNode)new JumpInsnNode(154, label));
            newInstructions.add((AbstractInsnNode)new IincInsnNode(1, 1));
            newInstructions.add((AbstractInsnNode)label);
            method.instructions.insertBefore(node, newInstructions);
            method.instructions.remove(node);
            return true;
        })));
        return transClass;
    }

    private static byte[] transformEntityWither(byte[] basicClass) {
        if (!CharmClassTransformer.checkTransformers(CharmLoadingPlugin.configAsm, "EntityWither")) {
            return basicClass;
        }
        CharmClassTransformer.log("Transforming EntityWither");
        MesonClassTransformer.MethodSignature canDestroyBlock = new MesonClassTransformer.MethodSignature("canDestroyBlock", "func_181033_a", "a", "(Lnet/minecraft/block/Block;)Z");
        byte[] transClass = basicClass;
        transClass = CharmClassTransformer.transform(transClass, Pair.of((Object)canDestroyBlock, (Object)CharmClassTransformer.combine(node -> node.getOpcode() == 25 && ((VarInsnNode)node).var == 0, (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "canWitherDestroyBlock", "(Lnet/minecraft/block/Block;)Lnet/minecraft/block/Block;", false));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(58, 0));
            method.instructions.insertBefore(node, newInstructions);
            return true;
        })));
        return transClass;
    }

    private static byte[] transformStructureVillagePiecesVillage(byte[] basicClass) {
        if (!CharmClassTransformer.checkTransformers(CharmLoadingPlugin.configAsm, "StructureVillagePieces")) {
            return basicClass;
        }
        CharmClassTransformer.log("Transforming StructureVillagePieces$Village");
        MesonClassTransformer.MethodSignature biomeDoor = new MesonClassTransformer.MethodSignature("biomeDoor", "func_189925_i", "i", "()Lnet/minecraft/block/BlockDoor;");
        return CharmClassTransformer.transform(basicClass, Pair.of((Object)biomeDoor, (Object)CharmClassTransformer.combine(node -> node.getOpcode() == 25, (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            newInstructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/world/gen/structure/StructureVillagePieces$Village", "startPiece", "Lnet/minecraft/world/gen/structure/StructureVillagePieces$Start;"));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "villageDoorsForBiome", "(Lnet/minecraft/world/gen/structure/StructureVillagePieces$Start;)Lnet/minecraft/block/BlockDoor;", false));
            newInstructions.add((AbstractInsnNode)new InsnNode(176));
            method.instructions = newInstructions;
            return true;
        })));
    }

    private static byte[] transformStructureStart(byte[] basicClass) {
        if (!CharmClassTransformer.checkTransformers(CharmLoadingPlugin.configAsm, "StructureStart")) {
            return basicClass;
        }
        CharmClassTransformer.log("Transforming StructureStart");
        byte[] transformClass = basicClass;
        MesonClassTransformer.MethodSignature generateStructure = new MesonClassTransformer.MethodSignature("generateStructure", "func_75068_a", "a", "(Lnet/minecraft/world/World;Ljava/util/Random;Lnet/minecraft/world/gen/structure/StructureBoundingBox;)V");
        transformClass = CharmClassTransformer.transform(transformClass, Pair.of((Object)generateStructure, (Object)CharmClassTransformer.combine(node -> node.getOpcode() == 182 && CharmClassTransformer.checkDesc(((MethodInsnNode)node).desc, "(Lnet/minecraft/world/World;Ljava/util/Random;Lnet/minecraft/world/gen/structure/StructureBoundingBox;)Z"), (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "addComponentParts", "(Lnet/minecraft/world/gen/structure/StructureComponent;Lnet/minecraft/world/World;Ljava/util/Random;Lnet/minecraft/world/gen/structure/StructureBoundingBox;)Z", false));
            method.instructions.insert(node, newInstructions);
            method.instructions.remove(node);
            return true;
        })));
        return transformClass;
    }

    static {
        CLASS_MAPPINGS = new ClassNameMap("net/minecraft/util/NonNullList", "fi", "net/minecraft/block/BlockDoor", "aqa", "net/minecraft/client/renderer/entity/layers/LayerArmorBase", "cbp", "net/minecraft/entity/Entity", "vg", "net/minecraft/entity/EntityLivingBase", "vp", "net/minecraft/entity/boss/EntityWither", "abx", "net/minecraft/entity/player/EntityPlayer", "aed", "net/minecraft/entity/player/EntityPlayer$SleepResult", "aed$a", "net/minecraft/entity/player/EntityPlayerMP", "oq", "net/minecraft/entity/player/InventoryPlayer", "aec", "net/minecraft/init/Blocks", "aox", "net/minecraft/inventory/ContainerBrewingStand", "afu", "net/minecraft/inventory/ContainerBrewingStand$Potion", "afu$c", "net/minecraft/inventory/ContainerFurnace", "agd", "net/minecraft/inventory/ContainerRepair", "afs", "net/minecraft/inventory/ContainerRepair$2", "afs$2", "net/minecraft/inventory/EntityEquipmentSlot", "vl", "net/minecraft/inventory/IInventory", "tv", "net/minecraft/inventory/SlotShulkerBox", "agq", "net/minecraft/item/Item$ToolMaterial", "ain$a", "net/minecraft/item/ItemChorusFruit", "ahk", "net/minecraft/potion/Potion", "uz", "net/minecraft/tileentity/TileEntityBeacon", "avh", "net/minecraft/tileentity/TileEntityFurnace", "avu", "net/minecraft/tileentity/TileEntityShulkerBox", "awb", "net/minecraft/util/math/AxisAlignedBB", "bhb", "net/minecraft/util/math/BlockPos", "et", "net/minecraft/world/gen/structure/MapGenVillage$Start", "bca$a", "net/minecraft/world/gen/structure/StructureBoundingBox", "bbg", "net/minecraft/world/gen/structure/StructureComponent", "bbx", "net/minecraft/world/gen/structure/StructureStart", "bby", "net/minecraft/world/gen/structure/StructureVillagePieces$Start", "bcb$k", "net/minecraft/world/gen/structure/StructureVillagePieces$Village", "bcb$n", "net/minecraft/world/World", "amu", "net/minecraft/util/DamageSource", "ur", "net/minecraft/item/ItemStack", "aip");
        transformers.put("net.minecraft.item.Item$ToolMaterial", CharmClassTransformer::transformItemToolMaterial);
        transformers.put("net.minecraftforge.items.ItemHandlerHelper", CharmClassTransformer::transformItemHandlerHelper);
        transformers.put("net.minecraftforge.common.ISpecialArmor$ArmorProperties", CharmClassTransformer::transformISpecialArmor);
        transformers.put("net.minecraftforge.common.brewing.BrewingRecipeRegistry", CharmClassTransformer::transformBrewingRecipeRegistry);
        transformers.put("net.minecraft.inventory.ContainerFurnace", CharmClassTransformer::transformContainerFurnace);
        transformers.put("net.minecraft.inventory.ContainerRepair", CharmClassTransformer::transformContainerRepair);
        transformers.put("net.minecraft.inventory.ContainerRepair$2", CharmClassTransformer::transformContainerRepair2);
        transformers.put("net.minecraft.inventory.SlotShulkerBox", CharmClassTransformer::transformSlotShulkerBox);
        transformers.put("net.minecraft.entity.boss.EntityWither", CharmClassTransformer::transformEntityWither);
        transformers.put("net.minecraft.entity.player.EntityPlayer", CharmClassTransformer::transformEntityPlayer);
        transformers.put("net.minecraft.item.ItemChorusFruit", CharmClassTransformer::transformItemChorusFruit);
        transformers.put("net.minecraft.client.renderer.entity.layers.LayerArmorBase", CharmClassTransformer::transformLayerArmorBase);
        transformers.put("net.minecraft.world.gen.structure.StructureStart", CharmClassTransformer::transformStructureStart);
        transformers.put("net.minecraft.world.gen.structure.StructureVillagePieces$Village", CharmClassTransformer::transformStructureVillagePiecesVillage);
        transformers.put("net.minecraft.tileentity.TileEntityBeacon", CharmClassTransformer::transformTileEntityBeacon);
        transformers.put("net.minecraft.tileentity.TileEntityFurnace", CharmClassTransformer::transformTileEntityFurnace);
        transformers.put("net.minecraft.tileentity.TileEntityShulkerBox", CharmClassTransformer::transformTileEntityShulkerBox);
    }
}

