/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.brewing.feature;

import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import svenhjol.charm.base.CharmSounds;
import svenhjol.charm.brewing.client.EnderSightSound;
import svenhjol.charm.brewing.message.MessageSetStructure;
import svenhjol.charm.brewing.potion.EnderSightPotion;
import svenhjol.meson.Feature;
import svenhjol.meson.handler.ClientHandler;
import svenhjol.meson.handler.NetworkHandler;
import svenhjol.meson.helper.EntityHelper;
import svenhjol.meson.helper.PlayerHelper;
import svenhjol.meson.helper.WorldHelper;

public class EnderSight
extends Feature {
    public static EnderSightPotion potion;
    public static int duration;
    public static double endermanSpawnChance;
    public static boolean doShaderEffects;
    private BlockPos nearestStructure = null;
    private boolean hasEnderSight = false;
    private boolean isCloseAndPlaying = false;
    private int ticks = 0;
    private int clientTicks = 0;
    private int endermanSpawnDistance;
    private double minDist;

    @Override
    public String getDescription() {
        return "Brew an Eye of Ender with a Night Vision potion to make a Potion of Ender Sight.\nEnderman are attracted to your location and you might hear a ringing sound coming from the direction of a stronghold.\n";
    }

    @Override
    public void configure() {
        super.configure();
        duration = this.propInt("Ender Sight duration", "Duration (in seconds) of Ender Sight effect when consumed.", 10);
        endermanSpawnChance = this.propDouble("Enderman spawn chance", "Chance (out of 1.0) of an Enderman spawning close by when experiencing the Ender Sight effect.", 0.05);
        doShaderEffects = this.propBoolean("Client shader effect", "Invert the colours when under the effect of Ender Sight.", true);
        this.minDist = 2000.0;
        this.endermanSpawnDistance = 5;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        potion = new EnderSightPotion();
        NetworkHandler.register(MessageSetStructure.class, Side.CLIENT);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.START && mc.field_71439_g != null && !mc.func_147113_T()) {
            EntityPlayerSP player = mc.field_71439_g;
            World world = player.field_70170_p;
            if (!this.hasEnderSight && mc.field_71439_g.func_70660_b((Potion)potion) != null) {
                this.hasEnderSight = true;
                mc.func_147118_V().func_147682_a((ISound)new EnderSightSound(CharmSounds.ENDER_WHISPERS, (EntityPlayer)player, 0.25f, 0.8f));
                if (doShaderEffects) {
                    mc.field_71460_t.func_175069_a(new ResourceLocation("charm", "shaders/ender_sight.json"));
                }
            } else if (this.hasEnderSight && player.func_70660_b((Potion)potion) != null && world.field_73011_w.getDimension() == 0) {
                this.nearestStructure = ClientHandler.getNearestStronghold();
                if (this.nearestStructure != null) {
                    double dist = this.nearestStructure.func_177954_c(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                    double d1 = MathHelper.func_191273_b((double)((double)player.field_70177_z / 360.0), (double)1.0);
                    double d2 = PlayerHelper.getLocationAngleToPlayer((EntityPlayer)player, this.nearestStructure) / (Math.PI * 2);
                    double d0 = 0.5 - (d1 - 0.25 - d2);
                    if (dist >= this.minDist) {
                        double d = MathHelper.func_191273_b((double)d0, (double)1.0);
                        if ((d > 0.95 || d < 0.05) && this.clientTicks % 4 + mc.field_71441_e.field_73012_v.nextInt(4) == 0) {
                            float pitch = 0.9f + (0.1f - (float)(d > 0.95 ? 1.0 - d : d));
                            mc.func_147118_V().func_147682_a((ISound)new EnderSightSound(CharmSounds.ENDER_RESONANCE, (EntityPlayer)player, 0.8f, pitch));
                        }
                    } else if (!this.isCloseAndPlaying) {
                        this.isCloseAndPlaying = true;
                        mc.func_147118_V().func_147682_a((ISound)new EnderSightSound(CharmSounds.ENDER_ABOVE_STRONGHOLD, (EntityPlayer)player, 0.8f, 1.0f));
                    }
                    ++this.clientTicks;
                }
            } else if (this.hasEnderSight && player.func_70660_b((Potion)potion) == null) {
                this.hasEnderSight = false;
                this.isCloseAndPlaying = false;
                this.nearestStructure = null;
                if (doShaderEffects) {
                    mc.field_71460_t.func_181022_b();
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side.isServer() && event.player.func_70660_b((Potion)potion) != null) {
            if (WorldHelper.canGenerateStructures(event.player.field_70170_p) && WorldHelper.canGenerateStructure(event.player.field_70170_p, WorldHelper.StructureType.STRONGHOLD) && event.player.field_70170_p.field_73011_w.getDimension() == 0 && this.nearestStructure == null) {
                this.nearestStructure = event.player.func_130014_f_().func_190528_a("Stronghold", event.player.func_180425_c(), false);
                if (this.nearestStructure != null) {
                    NetworkHandler.INSTANCE.sendTo((IMessage)new MessageSetStructure("Stronghold", this.nearestStructure), (EntityPlayerMP)event.player);
                }
            }
            if (this.ticks++ % 20 == 0 && (double)event.player.field_70170_p.field_73012_v.nextFloat() < endermanSpawnChance) {
                EntityHelper.spawnEntityNearPlayer(event.player, this.endermanSpawnDistance, new ResourceLocation("enderman"));
                this.ticks = 0;
            }
        }
    }

    @SubscribeEvent
    public void onLoad(WorldEvent.Load event) {
        WorldHelper.populateWorldSettings(event.getWorld());
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

