/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.crafting.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import svenhjol.charm.Charm;
import svenhjol.charm.base.CharmSounds;
import svenhjol.charm.crafting.feature.BookshelfChest;
import svenhjol.charm.crafting.tile.TileBookshelfChest;
import svenhjol.meson.MesonBlockTE;
import svenhjol.meson.iface.IMesonBlock;

public class BlockBookshelfChest
extends MesonBlockTE<TileBookshelfChest>
implements IMesonBlock {
    public static final PropertyInteger SLOTS = PropertyInteger.func_177719_a((String)"slots", (int)0, (int)9);

    public BlockBookshelfChest() {
        super(Material.field_151575_d, "bookshelf_chest");
        this.func_149711_c(BookshelfChest.hardness);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)SLOTS, (Comparable)Integer.valueOf(0)));
    }

    @Override
    public String getModId() {
        return "charm";
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ItemStack thisChest = new ItemStack((Block)this, 1, 0);
        TileBookshelfChest chest = (TileBookshelfChest)this.getTileEntity(world, pos);
        if (this.validTileEntity(chest)) {
            this.dropsInventory(chest, 9, (World)world, pos);
            thisChest.func_151001_c(chest.getName());
        }
        drops.add((Object)thisChest);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileBookshelfChest chest = (TileBookshelfChest)this.getTileEntity((IBlockAccess)worldIn, pos);
        if (this.validTileEntity(chest)) {
            chest.setName(stack.func_82833_r());
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            TileBookshelfChest bookshelf = (TileBookshelfChest)this.getTileEntity((IBlockAccess)world, pos);
            if (!this.validTileEntity(bookshelf)) {
                return false;
            }
            if (player.func_70093_af()) {
                return false;
            }
            if (bookshelf.hasLootTable()) {
                bookshelf.generateLoot(player);
            }
            player.openGui((Object)Charm.instance, 1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        if (world.field_72995_K) {
            player.func_184185_a(CharmSounds.BOOKSHELF_OPEN, 1.0f, 1.0f);
        }
        return true;
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return true;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 50;
    }

    @Override
    public Class<TileBookshelfChest> getTileEntityClass() {
        return TileBookshelfChest.class;
    }

    @Override
    @Nullable
    public TileBookshelfChest createTileEntity(World world, IBlockState state) {
        return new TileBookshelfChest();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SLOTS});
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)SLOTS);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)SLOTS, (Comparable)Integer.valueOf(meta & 9));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        int slots = this.getNumberOfOccupiedSlots(worldIn, pos);
        return state.func_177226_a((IProperty)SLOTS, (Comparable)Integer.valueOf(slots));
    }

    public float getEnchantPowerBonus(World world, BlockPos pos) {
        return this.getNumberOfOccupiedSlots((IBlockAccess)world, pos) > 0 ? 1.0f : 0.0f;
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_151122_aG;
    }

    public int func_149745_a(Random random) {
        return 3;
    }

    private int getNumberOfOccupiedSlots(IBlockAccess world, BlockPos pos) {
        TileBookshelfChest chest = (TileBookshelfChest)world.func_175625_s(pos);
        return this.getNumberOfOccupiedSlots(chest);
    }

    private int getNumberOfOccupiedSlots(TileBookshelfChest chest) {
        int slots = 0;
        if (this.validTileEntity(chest) && chest != null) {
            slots = chest.getNumberOfFilledSlots();
        }
        return slots;
    }
}

