/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.crafting.feature;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import svenhjol.charm.crafting.block.BlockBarrel;
import svenhjol.meson.Feature;
import svenhjol.meson.MesonBlock;
import svenhjol.meson.handler.RecipeHandler;
import svenhjol.meson.helper.ForgeHelper;
import svenhjol.meson.helper.LootHelper;
import svenhjol.meson.registry.ProxyRegistry;

public class Barrel
extends Feature {
    public static BlockBarrel block;
    public static float hardness;
    public static boolean useCharmBarrels;
    public static Map<RARITY, List<BarrelType>> types;

    @Override
    public String getDescription() {
        return "A compact storage solution borrowed lovingly from Minecraft 1.14.";
    }

    @Override
    public boolean isEnabled() {
        return this.enabled && (!ForgeHelper.areModsLoaded("minecraftfuture") || useCharmBarrels);
    }

    @Override
    public void configure() {
        super.configure();
        useCharmBarrels = this.propBoolean("Use Charm barrels", "Charm's barrels will be enabled even if barrels from other mods are present.", false);
        hardness = 2.5f;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        block = new BlockBarrel();
        GameRegistry.registerTileEntity(block.getTileEntityClass(), (ResourceLocation)new ResourceLocation("charm:barrel"));
        HashMap<RARITY, List<ResourceLocation>> map = new HashMap<RARITY, List<ResourceLocation>>(){
            {
                this.put(RARITY.COMMON, LootHelper.getLootTables(LootHelper.RARITY.COMMON, LootHelper.TYPE.MISC));
                this.put(RARITY.UNCOMMON, LootHelper.getLootTables(LootHelper.RARITY.UNCOMMON, LootHelper.TYPE.MISC));
            }
        };
        for (RARITY rarity : map.keySet()) {
            List tables = (List)map.get((Object)rarity);
            ArrayList<BarrelType> barrels = new ArrayList<BarrelType>();
            for (ResourceLocation res : tables) {
                String[] a = res.func_110623_a().split("/");
                barrels.add(new BarrelType(a.length > 1 ? a[1] : a[0], res.toString()));
            }
            types.put(rarity, barrels);
        }
        for (int i = 0; i < MesonBlock.WoodVariant.values().length; ++i) {
            RecipeHandler.addShapedRecipe(ProxyRegistry.newStack(block, 1, i), "WSW", "W W", "WSW", Character.valueOf('W'), ProxyRegistry.newStack(Blocks.field_150344_f, 1, i), Character.valueOf('S'), ProxyRegistry.newStack((Block)Blocks.field_150376_bx, 1, i));
        }
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        OreDictionary.registerOre((String)"barrel", (ItemStack)ProxyRegistry.newStack(block, 1, Short.MAX_VALUE));
    }

    public static BarrelType getRandomBarrelType(RARITY r) {
        Random rand = new Random();
        List<BarrelType> t = types.get((Object)r);
        return t.get(rand.nextInt(types.size()));
    }

    static {
        types = new HashMap<RARITY, List<BarrelType>>();
    }

    public class BarrelType {
        public String name;
        public String id;
        public ResourceLocation pool;

        public BarrelType(String id, String pool) {
            this.id = id;
            this.pool = new ResourceLocation(pool);
        }
    }

    public static enum RARITY {
        COMMON,
        UNCOMMON;

    }
}

