/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.crafting.feature;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import svenhjol.charm.base.CharmLootTables;
import svenhjol.charm.crafting.item.ItemSuspiciousSoup;
import svenhjol.charm.crafting.potion.SuspiciousEffects;
import svenhjol.meson.Feature;
import svenhjol.meson.handler.RecipeHandler;
import svenhjol.meson.helper.ForgeHelper;
import svenhjol.meson.helper.LootHelper;
import svenhjol.meson.registry.ProxyRegistry;

public class SuspiciousSoup
extends Feature {
    public static Item suspiciousSoup;
    public static List<SuspiciousEffects.CustomEffect> effects;
    public static long lastSeed;
    public static int duration;
    public static int amplifier;
    public static int heal;
    public static double saturation;
    public static boolean addToLoot;
    public static int maxTypes;
    public static int maxStackSize;

    @Override
    public String getDescription() {
        return "Craft (or find) beetroot soup with a flower to make a suspicious soup.\nDifferent flowers provide positive effects that are different for each world.\nBe warned: these unstable concoctions might occasionally have negative side effects.";
    }

    @Override
    public boolean isEnabled() {
        return this.enabled && !ForgeHelper.areModsLoaded("sm");
    }

    @Override
    public void configure() {
        super.configure();
        duration = this.propInt("Suspicious Soup duration", "Minimum duration (in seconds) of the effect(s) of the soup when consumed.", 20);
        heal = this.propInt("Health restored", "Amount of half-hearts of health restored by consuming any soup.", 10);
        addToLoot = this.propBoolean("Add to loot", "Add soup to mansions, igloos and village blacksmith loot.", true);
        SuspiciousEffects.init();
        maxTypes = effects.size();
        maxStackSize = 1;
        amplifier = 1;
        saturation = 0.2;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        int i;
        super.preInit(event);
        suspiciousSoup = new ItemSuspiciousSoup();
        ArrayList<ItemStack> flowers = new ArrayList<ItemStack>();
        flowers.add(new ItemStack((Block)Blocks.field_150327_N, 1));
        for (i = 0; i <= 8; ++i) {
            flowers.add(new ItemStack((Block)Blocks.field_150328_O, 1, i));
        }
        for (i = 0; i <= 5; ++i) {
            flowers.add(new ItemStack((Block)Blocks.field_150398_cm, 1, i));
        }
        i = 0;
        for (ItemStack flower : flowers) {
            RecipeHandler.addShapedRecipe(ProxyRegistry.newStack(suspiciousSoup, 1, i), "BBB", "BBB", "FWF", Character.valueOf('B'), Items.field_185164_cV, Character.valueOf('W'), Items.field_151054_z, Character.valueOf('F'), flower);
            if (++i != maxTypes) continue;
            i = 0;
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        if (effects.isEmpty() || lastSeed != world.func_72905_C()) {
            lastSeed = world.func_72905_C();
            this.assignEffects();
        }
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        if (!addToLoot) {
            return;
        }
        int weight = 0;
        int quality = 0;
        LootCondition[] conditions = new LootCondition[]{};
        LootFunction[] functions = new LootFunction[]{new SetMetadata(new LootCondition[0], new RandomValueRange(0.0f, (float)(maxTypes - 1)))};
        if (event.getName().equals((Object)LootTableList.field_191192_o)) {
            weight = 14;
        }
        if (event.getName().equals((Object)LootTableList.field_186431_m)) {
            weight = 14;
        }
        if (event.getName().equals((Object)LootTableList.field_186423_e)) {
            weight = 14;
        }
        if (event.getName().equals((Object)CharmLootTables.VILLAGE_FARMER)) {
            weight = 14;
        }
        if (event.getName().equals((Object)CharmLootTables.VILLAGE_BUTCHER)) {
            weight = 14;
        }
        if (weight > 0) {
            LootHelper.addToLootTable(event.getTable(), suspiciousSoup, weight, quality, functions, conditions);
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    private void assignEffects() {
        Collections.shuffle(effects, new Random(lastSeed));
    }

    static {
        effects = new ArrayList<SuspiciousEffects.CustomEffect>();
    }
}

