/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.tweaks.feature;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.tileentity.TileEntityBed;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import svenhjol.charm.tweaks.item.ItemBoundCompass;
import svenhjol.meson.Feature;
import svenhjol.meson.helper.PlayerHelper;

public class CompassBinding
extends Feature {
    public static ItemBoundCompass boundCompass;
    public static List<Item> validItems;
    public static boolean useBeacons;
    public static boolean useBeds;
    public static boolean useBanners;
    public static boolean showInformation;

    @Override
    public String getDescription() {
        return "Right-click on a beacon whilst sneaking to bind the compass to the beacon's location.\nIf Quark is enabled the compass tooltip will be the same color as the beacon's beam.";
    }

    @Override
    public void configure() {
        super.configure();
        showInformation = this.propBoolean("Add compass information", "If true, adds co-ordinates and dimension to the bound compass tooltip.", true);
        useBeacons = this.propBoolean("Use Beacons", "If true, compasses can bind to active beacons.", true);
        useBeds = this.propBoolean("Use Beds", "If true, compasses can bind to beds.", false);
        useBanners = this.propBoolean("Use Banners", "If true, compasses can bind to banners.", false);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        boundCompass = new ItemBoundCompass();
        validItems.add(Items.field_151111_aL);
        validItems.add(boundCompass);
    }

    @SubscribeEvent
    public void onCompassUse(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getWorld().field_72995_K && event.getEntityPlayer() != null && event.getEntityPlayer().func_70093_af() && validItems.contains(event.getEntityPlayer().func_184586_b(event.getHand()).func_77973_b())) {
            EntityPlayer player = event.getEntityPlayer();
            World world = event.getWorld();
            BlockPos pos = event.getPos();
            EnumHand hand = event.getHand();
            boolean validCompass = false;
            int color = 0;
            String name = "";
            ItemStack compass = new ItemStack((Item)boundCompass);
            TileEntity tile = world.func_175625_s(pos);
            if (useBeacons && tile instanceof TileEntityBeacon) {
                TileEntityBeacon beacon = (TileEntityBeacon)tile;
                if (beacon.func_191979_s() < 1) {
                    return;
                }
                for (int i = 256 - pos.func_177956_o(); i > 0; --i) {
                    IBlockState above = world.func_180495_p(pos.func_177967_a(EnumFacing.UP, i));
                    if (above.func_177230_c() != Blocks.field_150399_cn) continue;
                    color = ((EnumDyeColor)above.func_177229_b((IProperty)BlockStainedGlass.field_176547_a)).func_176767_b();
                    break;
                }
                name = Objects.requireNonNull(beacon.func_145748_c_()).func_150260_c();
                validCompass = true;
            }
            if (useBeds && tile instanceof TileEntityBed) {
                TileEntityBed bed = (TileEntityBed)tile;
                color = bed.func_193048_a().func_176767_b();
                if (bed.func_145748_c_() != null) {
                    name = bed.func_145748_c_().func_150260_c();
                }
                validCompass = true;
            }
            if (useBanners && tile instanceof TileEntityBanner) {
                TileEntityBanner banner = (TileEntityBanner)tile;
                List colorList = banner.func_175110_d();
                EnumDyeColor c = (EnumDyeColor)colorList.iterator().next();
                color = c.func_176767_b();
                if (banner.func_145748_c_() != null) {
                    name = banner.func_145748_c_().func_150260_c();
                }
                validCompass = true;
            }
            if (!validCompass) {
                return;
            }
            BlockPos compassPos = new BlockPos(pos.func_177958_n(), world.field_73011_w.getDimension(), pos.func_177952_p());
            name = name.length() > 0 ? name : "Bound Compass";
            compass.func_151001_c(name);
            ItemBoundCompass.setPos(compass, compassPos);
            ItemBoundCompass.setColor(compass, color);
            PlayerHelper.setHeldItem(player, hand, compass);
        }
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        int xpCost = 0;
        ItemStack in = event.getLeft();
        ItemStack combine = event.getRight();
        if (in.func_190926_b() && combine.func_190926_b()) {
            return;
        }
        if (in.func_77973_b() == boundCompass && combine.func_77973_b() == Items.field_151042_j) {
            ItemStack out = new ItemStack(Items.field_151111_aL);
            event.setCost(xpCost);
            event.setMaterialCost(1);
            event.setOutput(out);
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    static {
        validItems = new ArrayList<Item>();
    }
}

