/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.tweaks.feature;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import svenhjol.charm.tweaks.render.RenderOcelotTextures;
import svenhjol.charm.tweaks.render.RenderWolfTextures;
import svenhjol.meson.Feature;
import svenhjol.meson.iface.IMesonEnum;

public class RandomAnimalTextures
extends Feature {
    public static Map<SET, String[]> sets = new HashMap<SET, String[]>();
    public static boolean enableCats;
    public static boolean enableWolves;

    @Override
    public String getDescription() {
        return "Like Quark's random animal textures, this feature lets wolves and cats spawn with additional skin textures.";
    }

    @Override
    public void configure() {
        super.configure();
        enableCats = this.propBoolean("Random cat textures", "Enable random textures depending on the cat type, borrowed lovingly from Minecraft 1.14.", true);
        enableWolves = this.propBoolean("Random wolf textures", "Enable random wolf textures with brown, grey and black variants.", true);
        String[] ocelots = this.propStringList("Ocelot textures", "Textures to use when rendering Ocelots.", new String[]{"minecraft:ocelot"});
        String[] redCats = this.propStringList("Red cat textures", "Textures to use when rendering Red cats (Cat Type 1).", new String[]{"minecraft:red", "charm:persian", "charm:tabby"});
        String[] blackCats = this.propStringList("Black cat textures", "Textures to use when rendering Black cats (Cat Type 2).", new String[]{"minecraft:black", "charm:all_black"});
        String[] otherCats = this.propStringList("Siamese / other cat textures", "Textures to use when rendering Siamese and other cats (Cat Type 3).", new String[]{"minecraft:siamese", "charm:calico", "charm:white", "charm:ragdoll", "charm:british_shorthair", "charm:jellie"});
        String[] wolves = this.propStringList("Wolf textures", "Textures to use when rendering wolves.", new String[]{"minecraft:wolf", "charm:brown", "charm:grey", "charm:black"});
        sets.put(SET.OCELOTS, ocelots);
        sets.put(SET.REDCATS, redCats);
        sets.put(SET.BLACKCATS, blackCats);
        sets.put(SET.OTHERCATS, otherCats);
        sets.put(SET.WOLVES, wolves);
    }

    @Override
    public void preInitClient(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityWolf.class, (IRenderFactory)RenderWolfTextures.factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityOcelot.class, (IRenderFactory)RenderOcelotTextures.factory());
    }

    @SideOnly(value=Side.CLIENT)
    public static ResourceLocation getWolfTexture(EntityWolf entity) {
        String[] set = sets.get((Object)SET.WOLVES);
        String tex = RandomAnimalTextures.getRandomTexture((Entity)entity, set);
        if (entity.func_70909_n()) {
            tex = tex + "_tame";
        } else if (entity.func_70919_bu()) {
            tex = tex + "_angry";
        }
        return RandomAnimalTextures.getTextureFromString(MOB.WOLF, tex);
    }

    @SideOnly(value=Side.CLIENT)
    public static ResourceLocation getOcelotTexture(EntityOcelot entity) {
        String[] set = sets.get((Object)SET.OTHERCATS);
        switch (entity.func_70913_u()) {
            case 0: {
                set = sets.get((Object)SET.OCELOTS);
                break;
            }
            case 1: {
                set = sets.get((Object)SET.REDCATS);
                break;
            }
            case 2: {
                set = sets.get((Object)SET.BLACKCATS);
                break;
            }
            case 3: {
                set = sets.get((Object)SET.OTHERCATS);
            }
        }
        String tex = RandomAnimalTextures.getRandomTexture((Entity)entity, set);
        return RandomAnimalTextures.getTextureFromString(MOB.CAT, tex);
    }

    public static String getRandomTexture(Entity entity, String[] set) {
        UUID id = entity.func_110124_au();
        int choice = Math.abs((int)(id.getMostSignificantBits() % (long)set.length));
        return set[choice];
    }

    public static ResourceLocation getTextureFromString(MOB mob, String texture) {
        String prefix = "textures/entity/" + mob.func_176610_l() + "/";
        String[] a = texture.split(":");
        return new ResourceLocation(a[0], prefix + a[1] + ".png");
    }

    public static enum SET {
        OCELOTS,
        REDCATS,
        BLACKCATS,
        OTHERCATS,
        WOLVES;

    }

    public static enum MOB implements IMesonEnum
    {
        CAT,
        WOLF;

    }
}

