/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.world.block;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.block.state.pattern.BlockStateMatcher;
import net.minecraft.block.state.pattern.FactoryBlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import svenhjol.charm.world.feature.EndPortalRunes;
import svenhjol.charm.world.tile.TileRunePortalFrame;
import svenhjol.meson.MesonBlock;
import svenhjol.meson.MesonBlockTE;
import svenhjol.meson.iface.IMesonBlock;
import vazkii.quark.api.IRotationLockHandler;

@Optional.Interface(iface="vazkii.quark.api.IRotationLockHandler", modid="quark")
public class BlockRunePortalFrame
extends MesonBlockTE<TileRunePortalFrame>
implements IMesonBlock,
IRotationLockHandler {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyEnum<MesonBlock.ColorVariant> VARIANT = PropertyEnum.func_177709_a((String)"variant", MesonBlock.ColorVariant.class);
    protected static final AxisAlignedBB AABB_BLOCK = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.8125, 1.0);
    protected static final AxisAlignedBB AABB_RUNE = new AxisAlignedBB(0.3125, 0.8125, 0.3125, 0.6875, 1.0, 0.6875);
    private static BlockPattern portalShape;

    public BlockRunePortalFrame() {
        super(Material.field_151576_e, "rune_portal_frame");
        this.func_149711_c(-1.0f);
        this.func_149722_s();
        this.func_149752_b(6000000.0f);
        this.func_149715_a(0.125f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(VARIANT, (Comparable)((Object)MesonBlock.ColorVariant.WHITE)));
    }

    @Override
    public String getModId() {
        return "charm";
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        BlockRunePortalFrame.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_BLOCK);
        BlockRunePortalFrame.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_RUNE);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        EndPortalRunes.deactivate(worldIn, pos);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        TileRunePortalFrame portalFrame = (TileRunePortalFrame)this.getTileEntity((IBlockAccess)worldIn, pos);
        if (this.validTileEntity(portalFrame)) {
            EnumFacing facing = placer.func_174811_aO().func_176734_d();
            portalFrame.setFacing(facing);
            IBlockState changed = state.func_177226_a((IProperty)FACING, (Comparable)facing);
            worldIn.func_180501_a(pos, changed, 2);
        }
        EndPortalRunes.activate(worldIn, pos);
    }

    public IBlockState setRotation(World world, BlockPos pos, IBlockState state, EnumFacing facing, boolean hasHalf, boolean topHalf) {
        TileRunePortalFrame portalFrame = (TileRunePortalFrame)this.getTileEntity((IBlockAccess)world, pos);
        if (this.validTileEntity(portalFrame)) {
            portalFrame.setFacing(facing);
        }
        state = state.func_177226_a((IProperty)FACING, (Comparable)facing);
        world.func_180501_a(pos, state, 2);
        return state;
    }

    @Override
    public String[] getVariants() {
        ArrayList<String> variants = new ArrayList<String>();
        for (MesonBlock.ColorVariant variant : MesonBlock.ColorVariant.values()) {
            variants.add(variant.toString().toLowerCase());
        }
        return variants.toArray(new String[0]);
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return false;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)MesonBlock.ColorVariant.byMetadata(meta)));
    }

    public static BlockPattern getOrCreatePortalShape() {
        if (portalShape == null) {
            portalShape = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"?vvv?", ">???<", ">???<", ">???<", "?^^^?"}).func_177662_a('?', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.field_185928_a)).func_177662_a('^', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)EndPortalRunes.frame).func_177637_a((IProperty)FACING, enumFacing -> Objects.equals(enumFacing, EnumFacing.SOUTH)))).func_177662_a('>', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)EndPortalRunes.frame).func_177637_a((IProperty)FACING, enumFacing -> Objects.equals(enumFacing, EnumFacing.WEST)))).func_177662_a('v', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)EndPortalRunes.frame).func_177637_a((IProperty)FACING, enumFacing -> Objects.equals(enumFacing, EnumFacing.NORTH)))).func_177662_a('<', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)EndPortalRunes.frame).func_177637_a((IProperty)FACING, enumFacing -> Objects.equals(enumFacing, EnumFacing.EAST)))).func_177661_b();
        }
        return portalShape;
    }

    public int func_176201_c(IBlockState state) {
        return ((MesonBlock.ColorVariant)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)MesonBlock.ColorVariant.byMetadata(meta)));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileRunePortalFrame portal = (TileRunePortalFrame)worldIn.func_175625_s(pos);
        if (portal != null && this.validTileEntity(portal)) {
            EnumFacing facing = portal.getFacing();
            state = state.func_177226_a((IProperty)FACING, (Comparable)facing);
        }
        return state;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, VARIANT});
    }

    @Override
    public TileRunePortalFrame createTileEntity(World world, IBlockState state) {
        return new TileRunePortalFrame();
    }

    @Override
    public Class<TileRunePortalFrame> getTileEntityClass() {
        return TileRunePortalFrame.class;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.func_176201_c(world.func_180495_p(pos)));
    }
}

