/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.world.decorator.inner;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import svenhjol.charm.Charm;
import svenhjol.charm.base.CharmDecoratorItems;
import svenhjol.charm.crafting.block.BlockBookshelfChest;
import svenhjol.charm.crafting.feature.BookshelfChest;
import svenhjol.charm.world.compat.QuarkDecoratorItems;
import svenhjol.charm.world.decorator.theme.VillageButcherTheme;
import svenhjol.charm.world.decorator.theme.VillageCarpenterTheme;
import svenhjol.charm.world.decorator.theme.VillageFishermanTheme;
import svenhjol.charm.world.decorator.theme.VillageLibrarianTheme;
import svenhjol.charm.world.decorator.theme.VillagePriestTheme;
import svenhjol.charm.world.decorator.theme.VillageShepherdTheme;
import svenhjol.charm.world.decorator.theme.VillageSmithTheme;
import svenhjol.charm.world.feature.MoreVillageBiomes;
import svenhjol.charm.world.feature.VillageDecorations;
import svenhjol.meson.Meson;
import svenhjol.meson.decorator.MesonDecoratorTheme;
import svenhjol.meson.decorator.MesonInnerDecorator;
import svenhjol.meson.helper.ForgeHelper;
import svenhjol.meson.helper.LootHelper;
import svenhjol.meson.helper.ObfuscationHelper;
import svenhjol.meson.helper.WorldHelper;

public abstract class VillageInnerDecorator
extends MesonInnerDecorator {
    protected CharmDecoratorItems items;
    public BlockPos pos = this.getPos();
    public Random villageRand;
    public Biome biome = this.getBiome();
    public QuarkDecoratorItems quarkItems;
    public int floor = 1;
    public int roof = 5;

    public VillageInnerDecorator(StructureVillagePieces.Village structure, World world, StructureBoundingBox box) {
        super((StructureComponent)structure, world, box);
        this.villageRand = this.getVillageRand();
        this.items = new CharmDecoratorItems(this);
        try {
            if (ForgeHelper.areModsLoaded("quark")) {
                this.quarkItems = (QuarkDecoratorItems)QuarkDecoratorItems.class.getConstructor(MesonInnerDecorator.class).newInstance(this);
            }
        }
        catch (Exception e) {
            Meson.runtimeException("Error loading QuarkDecoratorItems");
        }
    }

    @Override
    protected Class<? extends MesonDecoratorTheme> getThemeClass() {
        ArrayList<Class<? extends MesonDecoratorTheme>> availableThemes = new ArrayList<Class<? extends MesonDecoratorTheme>>(){
            {
                this.add(VillageSmithTheme.class);
                this.add(VillagePriestTheme.class);
                this.add(VillageLibrarianTheme.class);
                this.add(VillageButcherTheme.class);
                this.add(VillageCarpenterTheme.class);
                this.add(VillageShepherdTheme.class);
                this.add(VillageFishermanTheme.class);
            }
        };
        return (Class)availableThemes.get(this.rand.nextInt(availableThemes.size()));
    }

    @Override
    protected boolean common() {
        return this.chance(VillageDecorations.common);
    }

    @Override
    protected boolean uncommon() {
        return this.chance(VillageDecorations.uncommon);
    }

    @Override
    protected boolean valuable() {
        return this.chance(VillageDecorations.valuable);
    }

    @Override
    protected boolean rare() {
        return this.chance(VillageDecorations.rare);
    }

    public long getSeed() {
        return WorldHelper.getNearestVillageSeed(this.world, this.pos);
    }

    public BlockPos getPos() {
        StructureBoundingBox bb = this.structure.func_74874_b();
        return new BlockPos(bb.field_78897_a, bb.field_78895_b, bb.field_78896_c);
    }

    public ChunkPos getChunkPos() {
        return WorldHelper.getChunkPos(this.getPos());
    }

    public Random getVillageRand() {
        long seed = this.getSeed();
        Random rand = new Random();
        rand.setSeed(seed);
        return rand;
    }

    public boolean isZombieInfested() {
        return (Boolean)ReflectionHelper.getPrivateValue(StructureVillagePieces.Village.class, (Object)((StructureVillagePieces.Village)this.structure), (String[])ObfuscationHelper.Fields.IS_ZOMBIE_INFESTED);
    }

    public Biome getBiome() {
        BlockPos nearest = WorldHelper.getNearestVillage(this.world, this.pos);
        return nearest != null ? this.world.func_180494_b(nearest) : Biomes.field_76772_c;
    }

    public static class WoodHut
    extends VillageInnerDecorator {
        public WoodHut(StructureVillagePieces.Village structure, World world, StructureBoundingBox box) {
            super(structure, world, box);
            this.roof = 5;
        }

        @Override
        public void generate() {
            if (this.common()) {
                this.fill(Blocks.field_150347_e, 1, 0, 1, 2, 0, 3, true);
            }
            if (this.chance(0.5f)) {
                if (VillageDecorations.beds) {
                    this.addRow(this.items.getBed(), 2, 1, 3, EnumFacing.WEST, EnumFacing.EAST);
                    this.add(Blocks.field_150350_a, 1, 2, 3);
                    this.add(Blocks.field_150350_a, 2, 2, 3);
                }
                if (VillageDecorations.carpet) {
                    this.items.addRug(1, 1, 2, 2, 2, null);
                }
            } else if (VillageDecorations.storage && this.uncommon()) {
                this.items.addStorageBlock(1, 1, 3, EnumFacing.SOUTH);
                this.add(Blocks.field_150350_a, 1, 2, 3);
            }
            if (this.chance(0.5f)) {
                if (VillageDecorations.functionalBlocks && this.common()) {
                    if (this.chance(0.5f)) {
                        this.items.addFunctionalBlock(2, 1, 1, EnumFacing.EAST);
                    } else {
                        this.items.addStand(2, 1, 1, EnumFacing.EAST, null);
                    }
                }
            } else if (VillageDecorations.armorStands && this.valuable()) {
                this.items.addArmorStand(2, this.floor, 1, 135.0f);
            }
            if (VillageDecorations.itemFrames && this.common()) {
                this.items.addFramedItem(1, this.floor + 2, 3, EnumFacing.SOUTH);
            }
            if (VillageDecorations.torches) {
                this.items.addTorch(2, this.floor + 2, 3, EnumFacing.SOUTH);
            }
        }
    }

    public static class Well
    extends VillageInnerDecorator {
        public Well(StructureVillagePieces.Village structure, World world, StructureBoundingBox box) {
            super(structure, world, box);
        }

        @Override
        public void generate() {
            if (VillageDecorations.carpet) {
                int roof = 16;
                this.items.addRug(roof, 1, 1, 4, 4, this.getVillageRand());
            }
            if (this.common()) {
                IBlockState ore = null;
                switch (this.getRand().nextInt(4)) {
                    case 0: {
                        ore = Blocks.field_150366_p.func_176223_P();
                        break;
                    }
                    case 1: {
                        ore = Blocks.field_150352_o.func_176223_P();
                        break;
                    }
                    case 2: {
                        ore = Blocks.field_150412_bA.func_176223_P();
                        break;
                    }
                    case 3: {
                        ore = Blocks.field_150482_ag.func_176223_P();
                    }
                }
                if (ore != null) {
                    this.add(ore, 2, 0, 2, EnumFacing.NORTH);
                }
            }
        }
    }

    public static class House4
    extends VillageInnerDecorator {
        public House4(StructureVillagePieces.Village structure, World world, StructureBoundingBox box) {
            super(structure, world, box);
        }

        @Override
        public void generate() {
            if (this.chance(0.5f)) {
                if (VillageDecorations.beds) {
                    this.addRow(this.items.getBed(), 2, 1, 3, EnumFacing.WEST, EnumFacing.EAST);
                }
                if (VillageDecorations.carpet) {
                    this.items.addRug(1, 1, 2, 2, 2, null);
                }
            } else if (VillageDecorations.storage) {
                if (this.uncommon()) {
                    this.items.addStorageBlock(1, 1, 3, EnumFacing.SOUTH);
                }
                if (this.uncommon()) {
                    this.items.addStorageBlock(2, 1, 3, EnumFacing.SOUTH);
                }
            }
            if (this.common() && Charm.hasFeature(MoreVillageBiomes.class)) {
                BlockPlanks.EnumType wood = MoreVillageBiomes.getWoodForBiome(this.biome);
                this.items.addDoor(2, 1, 0, EnumFacing.NORTH, MoreVillageBiomes.getDoorForWood(wood));
            }
            if (this.isRoofAccessible()) {
                if (VillageDecorations.storage) {
                    if (this.uncommon()) {
                        this.items.addStorageBlock(1, 5, 3, EnumFacing.EAST);
                    }
                    if (this.uncommon()) {
                        this.items.addStorageBlock(3, 5, 1, EnumFacing.NORTH);
                    }
                }
            } else if (VillageDecorations.itemFrames && this.common()) {
                this.items.addFramedItem(3, 3, 3, EnumFacing.SOUTH);
            }
            if (VillageDecorations.torches) {
                this.items.addTorch(0, 6, 0, null);
                this.items.addTorch(4, 6, 4, null);
                if (this.uncommon()) {
                    this.items.addLantern(2, this.floor + 2, 2, true);
                }
            }
            if (VillageDecorations.itemFrames) {
                if (this.common()) {
                    this.items.addFramedItem(1, 3, 3, EnumFacing.SOUTH);
                }
                if (this.common()) {
                    this.items.addFramedItem(1, 3, 1, EnumFacing.NORTH);
                }
                if (this.common()) {
                    this.items.addFramedItem(3, 3, 1, EnumFacing.NORTH);
                }
            }
            if (VillageDecorations.armorStands && this.valuable()) {
                this.items.addArmorStand(3, this.floor, 1, 135.0f);
            }
        }

        public boolean isRoofAccessible() {
            return (Boolean)ReflectionHelper.getPrivateValue(StructureVillagePieces.House4Garden.class, (Object)((StructureVillagePieces.House4Garden)this.structure), (String[])ObfuscationHelper.Fields.IS_ROOF_ACCESSIBLE);
        }
    }

    public static class House3
    extends VillageInnerDecorator {
        public House3(StructureVillagePieces.Village structure, World world, StructureBoundingBox box) {
            super(structure, world, box);
        }

        @Override
        public void generate() {
            float r = this.rand.nextFloat();
            if (r <= 0.25f) {
                if (VillageDecorations.beds && VillageDecorations.decorativeBlocks) {
                    this.addRow(this.items.getBed(), 4, this.floor, 9, EnumFacing.NORTH, EnumFacing.NORTH);
                    this.addRow(this.items.getBed(), 6, this.floor, 9, EnumFacing.NORTH, EnumFacing.NORTH);
                    this.add(Blocks.field_150462_ai.func_176223_P(), 5, this.floor, 9);
                    this.add(Blocks.field_150342_X.func_176223_P(), 3, this.floor, 9);
                    this.add(Blocks.field_150342_X.func_176223_P(), 7, this.floor, 9);
                }
            } else if (r <= 0.5f) {
                if (VillageDecorations.beds && VillageDecorations.decorativeBlocks) {
                    this.addRow(this.items.getBed(), 4, this.floor, 9, EnumFacing.WEST, EnumFacing.EAST);
                    this.add(Blocks.field_150342_X.func_176223_P(), 5, this.floor, 9);
                    this.addRow(this.items.getBed(), 6, this.floor, 9, EnumFacing.EAST, EnumFacing.WEST);
                    if (this.common()) {
                        this.items.addRandomBlock(6, this.floor, 1, EnumFacing.SOUTH);
                    }
                    if (this.common()) {
                        this.items.addRandomBlock(7, this.floor, 1, EnumFacing.SOUTH);
                    }
                }
            } else if (r <= 0.75f) {
                if (VillageDecorations.functionalBlocks && VillageDecorations.decorativeBlocks) {
                    if (this.common()) {
                        this.items.addFunctionalBlock(3, this.floor, 9, EnumFacing.SOUTH);
                    }
                    if (this.common()) {
                        this.items.addFunctionalBlock(4, this.floor, 9, EnumFacing.SOUTH);
                    }
                    if (this.uncommon()) {
                        this.items.addStorageBlock(5, this.floor, 9, EnumFacing.SOUTH);
                    }
                    if (this.common()) {
                        this.items.addFunctionalBlock(6, this.floor, 9, EnumFacing.SOUTH);
                    }
                    if (this.common()) {
                        this.items.addFunctionalBlock(7, this.floor, 9, EnumFacing.SOUTH);
                    }
                }
            } else if (VillageDecorations.storage) {
                if (this.common()) {
                    this.items.addStorageBlock(5, this.floor, 9, EnumFacing.SOUTH);
                }
                if (this.common()) {
                    this.items.addStorageBlock(6, this.floor, 9, EnumFacing.SOUTH);
                }
            }
            if (VillageDecorations.decorativeBlocks && VillageDecorations.functionalBlocks) {
                if (this.common()) {
                    this.items.addStand(7, this.floor, 5, EnumFacing.WEST, null);
                }
                if (this.common()) {
                    this.items.addRandomBlock(7, this.floor, 6, EnumFacing.WEST);
                }
                if (this.common()) {
                    this.items.addStand(4, this.floor, 1, EnumFacing.NORTH, null);
                }
                if (this.common()) {
                    this.items.addRandomBlock(5, this.floor, 1, EnumFacing.NORTH);
                }
            }
            if (VillageDecorations.storage) {
                if (this.uncommon()) {
                    this.items.addStorageBlock(1, this.floor, 2, EnumFacing.EAST);
                }
                if (this.uncommon()) {
                    this.items.addStorageBlock(1, this.floor, 3, EnumFacing.EAST);
                }
            }
            if (VillageDecorations.itemFrames) {
                if (this.uncommon()) {
                    this.items.addFramedItem(6, this.floor + 1, 1, EnumFacing.NORTH);
                }
                if (this.uncommon()) {
                    this.items.addFramedItem(4, this.floor + 1, 9, EnumFacing.SOUTH);
                }
                if (this.uncommon()) {
                    this.items.addFramedItem(6, this.floor + 1, 9, EnumFacing.SOUTH);
                }
            }
            if (VillageDecorations.functionalBlocks) {
                if (this.common()) {
                    this.items.addFunctionalBlock(7, this.floor, 2, EnumFacing.WEST);
                }
                if (this.common()) {
                    this.items.addFunctionalBlock(7, this.floor, 3, EnumFacing.WEST);
                }
            }
            if (VillageDecorations.carpet) {
                this.items.addRug(this.floor, 3, 3, 6, 6, null);
            }
            if (VillageDecorations.torches) {
                this.items.addTorch(5, 3, 9, EnumFacing.SOUTH);
                this.items.addTorch(7, 3, 5, EnumFacing.WEST);
                this.items.addTorch(3, 3, 5, EnumFacing.EAST);
                if (this.uncommon()) {
                    this.items.addLantern(5, 5, 5, true);
                }
            }
        }
    }

    public static class House2
    extends VillageInnerDecorator {
        List<ItemStack> anvilItems = new ArrayList<ItemStack>(){
            {
                this.add(new ItemStack(Items.field_151040_l));
                this.add(new ItemStack(Items.field_151036_c));
                this.add(new ItemStack(Items.field_151037_a));
                this.add(new ItemStack(Items.field_151035_b));
            }
        };

        public House2(StructureVillagePieces.Village structure, World world, StructureBoundingBox box) {
            super(structure, world, box);
        }

        @Override
        protected Class<? extends MesonDecoratorTheme> getThemeClass() {
            return VillageSmithTheme.class;
        }

        @Override
        public void generate() {
            if (VillageDecorations.functionalBlocks) {
                this.items.addAnvil(8, this.floor, 1, this.chance(0.5f) ? 1 : 0, EnumFacing.EAST);
                if (this.quarkItems != null && this.common()) {
                    this.quarkItems.addGlassFramedItem(8, this.floor + 1, 1, EnumFacing.UP, this.anvilItems.get(this.rand.nextInt(this.anvilItems.size())));
                }
            }
            if (VillageDecorations.decorativeBlocks && this.common()) {
                this.fill((Block)Blocks.field_150333_U, 6, 5, 4, 8, 5, 6, true);
                this.add(Blocks.field_150350_a, 7, 4, 5);
                this.add(Blocks.field_150350_a, 8, 4, 5);
                this.add(Blocks.field_150350_a, 7, 5, 5);
                this.add(Blocks.field_150350_a, 8, 5, 5);
                this.add(Blocks.field_189877_df, 7, 3, 5);
                this.add(Blocks.field_189877_df, 8, 3, 5);
            }
            if (VillageDecorations.torches) {
                this.items.addTorch(1, 3, 3, EnumFacing.EAST);
                this.items.addTorch(3, 3, 5, EnumFacing.SOUTH);
            }
            if (VillageDecorations.armorStands && this.uncommon()) {
                this.items.addArmorStand(1, this.floor, 1, 40.0f);
            }
        }
    }

    public static class House1
    extends VillageInnerDecorator {
        public House1(StructureVillagePieces.Village structure, World world, StructureBoundingBox box) {
            super(structure, world, box);
        }

        @Override
        protected Class<? extends MesonDecoratorTheme> getThemeClass() {
            return VillageLibrarianTheme.class;
        }

        @Override
        public void generate() {
            if (VillageDecorations.storage) {
                if (this.common()) {
                    this.items.addStorageBlock(7, 1, 2, EnumFacing.WEST);
                }
                if (Charm.hasFeature(BookshelfChest.class)) {
                    IBlockState type = BookshelfChest.bookshelfChest.func_176223_P();
                    for (int i = 0; i < 7; ++i) {
                        if (!this.uncommon()) continue;
                        int numberOfBooks = this.rand.nextInt(4) + 1;
                        type.func_177226_a((IProperty)BlockBookshelfChest.SLOTS, (Comparable)Integer.valueOf(numberOfBooks));
                        this.items.addStorageBlock(type, i + 1, 3, 4, EnumFacing.SOUTH, LootHelper.getRandomLootTable(LootHelper.RARITY.COMMON, LootHelper.TYPE.BOOK), numberOfBooks);
                    }
                }
            }
            if (VillageDecorations.torches) {
                this.items.addTorch(1, 4, 2, EnumFacing.EAST);
                this.items.addTorch(1, 4, 3, EnumFacing.EAST);
                this.items.addTorch(7, 4, 2, EnumFacing.WEST);
                this.items.addTorch(7, 4, 3, EnumFacing.WEST);
            }
            if (VillageDecorations.itemFrames) {
                if (this.common()) {
                    this.items.addFramedItem(7, 2, 1, EnumFacing.WEST);
                }
                if (this.common()) {
                    this.items.addFramedItem(1, 3, 1, EnumFacing.NORTH);
                }
            }
        }
    }

    public static class Hall
    extends VillageInnerDecorator {
        public Hall(StructureVillagePieces.Village structure, World world, StructureBoundingBox box) {
            super(structure, world, box);
        }

        @Override
        protected Class<? extends MesonDecoratorTheme> getThemeClass() {
            return VillageButcherTheme.class;
        }

        @Override
        public void generate() {
            if (VillageDecorations.storage && this.uncommon()) {
                this.items.addStorageBlock(3, this.floor, 4, EnumFacing.SOUTH);
            }
            if (VillageDecorations.functionalBlocks && this.common()) {
                if (this.chance(0.5f)) {
                    this.items.addFunctionalBlock(4, this.floor, 4, EnumFacing.SOUTH);
                } else {
                    this.items.addStand(4, this.floor, 4, EnumFacing.SOUTH, null);
                }
            }
            if (VillageDecorations.itemFrames) {
                if (this.common()) {
                    this.items.addFramedItem(5, this.floor + 2, 4, EnumFacing.SOUTH);
                }
                if (this.common()) {
                    this.items.addFramedItem(7, this.floor + 2, 1, EnumFacing.WEST);
                }
                if (this.common()) {
                    this.items.addFramedItem(3, this.floor + 2, 1, EnumFacing.NORTH);
                }
            }
            if (VillageDecorations.armorStands && this.uncommon()) {
                this.items.addArmorStand(7, this.floor, 4, 215.0f);
            }
            if (VillageDecorations.decorativeBlocks) {
                this.fill(Blocks.field_150458_ak.func_176223_P(), 3, 0, 6, 7, 0, 9, EnumFacing.UP, true);
                for (int xx = 3; xx <= 7; ++xx) {
                    for (int zz = 6; zz <= 9; ++zz) {
                        if (!(this.rand.nextFloat() < 0.4f)) continue;
                        this.add(((BlockCrops)Blocks.field_150464_aj).func_185528_e(6 + this.rand.nextInt(1)), xx, this.floor, zz);
                    }
                }
                this.add(Blocks.field_150355_j.func_176223_P(), 5, 0, 8);
                this.add(Blocks.field_150350_a.func_176223_P(), 5, 1, 8);
            }
            if (VillageDecorations.torches) {
                this.items.addTorch(2, this.floor + 1, 10, null);
                this.items.addTorch(8, this.floor + 1, 10, null);
            }
        }
    }

    public static class Field2
    extends VillageInnerDecorator {
        public Field2(StructureVillagePieces.Village structure, World world, StructureBoundingBox box) {
            super(structure, world, box);
        }

        @Override
        public void generate() {
            if (VillageDecorations.torches) {
                this.items.addTorch(3, 1, 0, null);
                this.items.addTorch(3, 1, 8, null);
                this.items.addTorch(9, 1, 0, null);
                this.items.addTorch(9, 1, 8, null);
            }
        }
    }

    public static class Field1
    extends VillageInnerDecorator {
        public Field1(StructureVillagePieces.Village structure, World world, StructureBoundingBox box) {
            super(structure, world, box);
        }

        @Override
        public void generate() {
            if (VillageDecorations.torches) {
                this.items.addTorch(3, 1, 0, null);
                this.items.addTorch(3, 1, 8, null);
            }
        }
    }

    public static class Church
    extends VillageInnerDecorator {
        public Church(StructureVillagePieces.Village structure, World world, StructureBoundingBox box) {
            super(structure, world, box);
        }

        @Override
        protected Class<? extends MesonDecoratorTheme> getThemeClass() {
            return VillagePriestTheme.class;
        }

        @Override
        public void generate() {
            if (VillageDecorations.functionalBlocks && this.valuable()) {
                this.add(Blocks.field_150381_bn, 2, 2, 7);
            }
            if (VillageDecorations.torches) {
                if (this.common()) {
                    this.items.addLantern(2, this.floor + 3, 6, true);
                }
                this.items.addTorch(3, 7, 1, EnumFacing.WEST);
                this.items.addTorch(2, 10, 2, null);
            }
            if (VillageDecorations.decorativeBlocks) {
                if (this.common()) {
                    this.addRow(this.items.getBed(), 3, 5, 2, EnumFacing.NORTH, EnumFacing.NORTH);
                }
                if (this.common()) {
                    this.addRow(this.items.getBed(), 2, 5, 2, EnumFacing.NORTH, EnumFacing.NORTH);
                }
            }
            if (VillageDecorations.storage && this.common()) {
                this.items.addStorageBlock(3, 10, 1, EnumFacing.NORTH);
            }
        }
    }
}

