/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic;

import com.lothrazar.cyclicmagic.config.IHasConfig;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Logger;

public class ModLogger
implements IHasConfig {
    private Logger logger;
    private boolean sendInfo = true;
    private boolean sendLogs = false;
    private boolean runUnitTests;

    public ModLogger(Logger l) {
        this.logger = l;
    }

    public void info(String string, Object ... params) {
        if (this.sendInfo) {
            this.logger.info(string, params);
        }
    }

    public void log(String string, Object ... params) {
        if (this.sendLogs) {
            this.logger.info(string, params);
        }
    }

    public void error(String string) {
        this.logger.error(string);
    }

    public void error(String string, Object ... params) {
        this.logger.error(string, params);
    }

    public boolean runUnitTests() {
        return this.runUnitTests;
    }

    public void logTestResult(String string) {
        if (this.runUnitTests()) {
            this.logger.info("[UnitTest]" + string);
        }
    }

    @Override
    public void syncConfig(Configuration config) {
        String category = "cyclicmagic.logging";
        this.sendInfo = config.getBoolean("Information", category, true, "Log basic game startup information such as ore dictionary registration");
        this.runUnitTests = config.getBoolean("UnitTests", category, false, "Run unit tests on startup and log the result.  Still experimental and not widely used");
        this.sendLogs = config.getBoolean("Debug", category, false, "Log debug related information.  This can be very spammy, only used for debugging problems or new features, so just leave it off normally.");
    }
}

