/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.autouser;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.block.autouser.BlockUser;
import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.capability.EnergyStore;
import com.lothrazar.cyclicmagic.data.ITilePreviewToggle;
import com.lothrazar.cyclicmagic.data.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import com.lothrazar.cyclicmagic.util.UtilFakePlayer;
import com.lothrazar.cyclicmagic.util.UtilFluid;
import com.lothrazar.cyclicmagic.util.UtilInventoryTransfer;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilShape;
import com.lothrazar.cyclicmagic.util.UtilString;
import com.lothrazar.cyclicmagic.util.UtilWorld;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.FluidActionResult;

public class TileEntityUser
extends TileEntityBaseMachineInvo
implements ITileRedstoneToggle,
ITilePreviewToggle,
ITickable {
    private static final String NBT_LR = "lr";
    private static final int MAX_SIZE = 9;
    public static final int MAX_SPEED = 200;
    private static final int SLOT_TOOL = 0;
    private static final int SLOT_OUTPUT_START = 3;
    private static final int INV_SIZE = 9;
    public static int maxHeight = 10;
    private int rightClickIfZero = 0;
    private WeakReference<FakePlayer> fakePlayer;
    private UUID uuid;
    private int size;
    private int vRange = 2;
    public int yOffset = 0;
    private int tickDelay;
    private static List<String> blacklistAll;

    public TileEntityUser() {
        super(9);
        this.timer = this.tickDelay;
        this.initEnergy(new EnergyStore(64000), BlockUser.FUEL_COST);
        this.setSlotsForInsert(0, 2);
        this.setSlotsForExtract(3, 8);
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    public void func_73660_a() {
        if (!this.isRunning()) {
            return;
        }
        this.shiftAllUp(6);
        if (!this.updateEnergyIsBurning()) {
            return;
        }
        boolean triggered = this.updateTimerIsZero();
        if (this.field_145850_b instanceof WorldServer) {
            this.setupBeforeTrigger();
            if (triggered) {
                this.timer = this.tickDelay;
                this.trigger();
            }
            this.func_70296_d();
        }
    }

    private void trigger() {
        BlockPos targetPos = this.getTargetPos();
        try {
            boolean fluidSuccess;
            if (this.isRightClick() && !this.isInBlacklist(targetPos) && !(fluidSuccess = this.interactFluid(targetPos)) && !this.field_145850_b.func_175623_d(targetPos)) {
                this.rightClickBlock(targetPos);
            }
        }
        catch (Throwable e) {
            ModCyclic.logger.error("Automated User [rightClickBlock] Error '" + e.getMessage() + "'" + e.getClass(), e);
        }
        try {
            this.interactEntities(targetPos);
        }
        catch (Throwable e) {
            ModCyclic.logger.error("Automated User [interactEntities] Error '" + e.getMessage() + "'" + e.getClass(), e);
        }
    }

    private void setupBeforeTrigger() {
        this.verifyUuid(this.field_145850_b);
        if (this.fakePlayer == null) {
            this.fakePlayer = UtilFakePlayer.initFakePlayer((WorldServer)this.field_145850_b, this.uuid, "block_user");
            if (this.fakePlayer == null) {
                ModCyclic.logger.error("Fake player failed to init ");
                return;
            }
        }
        ((FakePlayer)this.fakePlayer.get()).field_70177_z = UtilEntity.getYawFromFacing(this.getCurrentFacing());
        this.tryEquipItem();
    }

    private boolean isInBlacklist(BlockPos targetPos) {
        if (this.field_145850_b.func_180495_p(targetPos) == null || this.field_145850_b.func_180495_p(targetPos).func_177230_c() == null) {
            return false;
        }
        return UtilString.isInList(blacklistAll, this.field_145850_b.func_180495_p(targetPos).func_177230_c().getRegistryName());
    }

    private void interactEntities(BlockPos targetPos) {
        BlockPos entityCenter = this.getTargetCenter();
        AxisAlignedBB entityRange = UtilEntity.makeBoundingBox(entityCenter, this.size, this.vRange);
        List living = this.field_145850_b.func_72872_a(EntityLivingBase.class, entityRange);
        if (this.isRightClick()) {
            List carts = this.field_145850_b.func_72872_a(EntityMinecart.class, entityRange);
            ArrayList<Entity> all = new ArrayList<Entity>(living);
            all.addAll(carts);
            this.rightClickEntities(all);
            this.func_145831_w().func_175646_b(targetPos, (TileEntity)this);
        } else {
            this.leftClickEntities(living);
        }
    }

    private void leftClickEntities(List<EntityLivingBase> living) {
        ItemStack held = ((FakePlayer)this.fakePlayer.get()).func_184614_ca();
        ((FakePlayer)this.fakePlayer.get()).field_70122_E = true;
        int countDamaged = 0;
        for (EntityLivingBase ent : living) {
            if (ent == null || ent.field_70128_L) continue;
            ((FakePlayer)this.fakePlayer.get()).func_71059_n((Entity)ent);
            IAttributeInstance damage = new AttributeMap().func_111150_b(SharedMonsterAttributes.field_111264_e);
            if (!held.func_190926_b()) {
                for (AttributeModifier modifier : held.func_111283_C(EntityEquipmentSlot.MAINHAND).get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a())) {
                    damage.func_111121_a(modifier);
                }
            }
            float dmgVal = (float)damage.func_111126_e();
            float f1 = EnchantmentHelper.func_152377_a((ItemStack)held, (EnumCreatureAttribute)ent.func_70668_bt());
            if (!ent.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)this.fakePlayer.get())), dmgVal + f1) || BlockUser.maxAttackPer <= 0 || ++countDamaged < BlockUser.maxAttackPer) continue;
            break;
        }
    }

    private void rightClickEntities(List<Entity> all) {
        Collections.shuffle(all);
        for (Entity ent : all) {
            if (this.field_145850_b.field_72995_K || ent == null || ent.field_70128_L || this.fakePlayer == null || this.fakePlayer.get() == null) continue;
            this.validateTool();
            if (EnumActionResult.FAIL == ((FakePlayer)this.fakePlayer.get()).func_190775_a(ent, EnumHand.MAIN_HAND)) continue;
            this.tryDumpFakePlayerInvo(false);
            break;
        }
    }

    private boolean isRightClick() {
        return this.rightClickIfZero == 0;
    }

    private boolean interactFluid(BlockPos targetPos) {
        FakePlayer player = (FakePlayer)this.fakePlayer.get();
        ItemStack playerHeld = player.func_184614_ca();
        if (UtilFluid.stackHasFluidHandler(playerHeld) && UtilFluid.hasFluidHandler(this.field_145850_b.func_175625_s(targetPos), this.getCurrentFacing().func_176734_d())) {
            boolean success = this.rightClickFluidTank(targetPos);
            if (success) {
                this.syncPlayerTool();
                return true;
            }
        } else if (UtilFluid.stackHasFluidHandler(playerHeld) && this.rightClickFluidAir(targetPos)) {
            this.syncPlayerTool();
            return true;
        }
        return false;
    }

    private void rightClickBlock(BlockPos targetPos) throws Exception {
        ItemStack before = ((FakePlayer)this.fakePlayer.get()).func_184614_ca();
        boolean wasEmpty = ((FakePlayer)this.fakePlayer.get()).func_184614_ca().func_190926_b();
        EnumActionResult result = ((FakePlayer)this.fakePlayer.get()).field_71134_c.func_187251_a((EntityPlayer)this.fakePlayer.get(), this.field_145850_b, ((FakePlayer)this.fakePlayer.get()).func_184614_ca(), EnumHand.MAIN_HAND, targetPos, EnumFacing.UP, 0.5f, 0.5f, 0.5f);
        if (result != EnumActionResult.FAIL) {
            boolean eq = ItemStack.func_77989_b((ItemStack)before, (ItemStack)((FakePlayer)this.fakePlayer.get()).func_184614_ca());
            if (!wasEmpty && ((FakePlayer)this.fakePlayer.get()).func_184614_ca().func_190926_b()) {
                this.syncPlayerTool();
            } else if (!eq) {
                this.tryDumpFakePlayerInvo(true);
                this.syncPlayerTool();
            }
        } else {
            ActionResult res;
            result = ((FakePlayer)this.fakePlayer.get()).field_71134_c.func_187250_a((EntityPlayer)this.fakePlayer.get(), this.field_145850_b, ((FakePlayer)this.fakePlayer.get()).func_184614_ca(), EnumHand.MAIN_HAND);
            if (((FakePlayer)this.fakePlayer.get()).func_184614_ca().func_190916_E() == 0) {
                this.inv.set(0, (Object)ItemStack.field_190927_a);
                ((FakePlayer)this.fakePlayer.get()).func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
            }
            if (result != EnumActionResult.SUCCESS && ((res = ((FakePlayer)this.fakePlayer.get()).func_184614_ca().func_77973_b().func_77659_a(this.field_145850_b, (EntityPlayer)this.fakePlayer.get(), EnumHand.MAIN_HAND)) == null || res.func_188397_a() != EnumActionResult.SUCCESS) && ((FakePlayer)this.fakePlayer.get()).func_184614_ca().func_77973_b() == Items.field_151069_bo && this.field_145850_b.func_180495_p(targetPos).func_185904_a() == Material.field_151586_h) {
                ItemStack itemstack = ((FakePlayer)this.fakePlayer.get()).func_184614_ca();
                EntityPlayer p = (EntityPlayer)this.fakePlayer.get();
                this.field_145850_b.func_184148_a(p, p.field_70165_t, p.field_70163_u, p.field_70161_v, SoundEvents.field_187615_H, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                itemstack.func_190918_g(1);
                ItemStack is = new ItemStack((Item)Items.field_151068_bn);
                PotionUtils.func_185188_a((ItemStack)is, (PotionType)PotionTypes.field_185230_b);
                this.tryDumpStacks(Arrays.asList(is));
            }
            this.tryDumpFakePlayerInvo(wasEmpty);
        }
    }

    private void syncPlayerTool() {
        this.func_70299_a(0, ((FakePlayer)this.fakePlayer.get()).func_184614_ca());
    }

    private void tryDumpStacks(List<ItemStack> toDump) {
        ArrayList<ItemStack> toDrop = UtilInventoryTransfer.dumpToIInventory(toDump, this, 3, 9);
        BlockPos dropHere = this.getTargetPos();
        for (ItemStack s : toDrop) {
            if (s.func_190926_b()) continue;
            EntityItem entityItem = UtilItemStack.dropItemStackInWorld(this.field_145850_b, dropHere, s.func_77946_l());
            if (entityItem != null && this.field_145850_b.field_72995_K) {
                entityItem.func_70016_h(0.0, 0.0, 0.0);
            }
            s.func_190920_e(0);
        }
    }

    private void tryDumpFakePlayerInvo(boolean includeMainHand) {
        int start = includeMainHand ? 0 : 1;
        ArrayList<ItemStack> toDrop = new ArrayList<ItemStack>();
        for (int i = start; i < ((FakePlayer)this.fakePlayer.get()).field_71071_by.field_70462_a.size(); ++i) {
            ItemStack s = (ItemStack)((FakePlayer)this.fakePlayer.get()).field_71071_by.field_70462_a.get(i);
            if (s.func_190926_b()) continue;
            toDrop.add(s.func_77946_l());
            ((FakePlayer)this.fakePlayer.get()).field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
        }
        this.tryDumpStacks(toDrop);
    }

    private boolean rightClickFluidTank(BlockPos targetPos) {
        FakePlayer player = (FakePlayer)this.fakePlayer.get();
        ItemStack playerHeld = player.func_184614_ca();
        boolean wasFull = UtilFluid.isEmptyOfFluid(playerHeld);
        boolean success = UtilFluid.interactWithFluidHandler((EntityPlayer)player, this.field_145850_b, targetPos, this.getCurrentFacing().func_176734_d());
        playerHeld = player.func_184614_ca();
        if (success) {
            if (UtilFluid.isEmptyOfFluid(playerHeld)) {
                this.tryDumpFakePlayerInvo(!wasFull && playerHeld.func_190916_E() == 1);
            } else {
                this.tryDumpFakePlayerInvo(true);
            }
            return success;
        }
        return false;
    }

    private boolean rightClickFluidAir(BlockPos targetPos) {
        FakePlayer player = (FakePlayer)this.fakePlayer.get();
        ItemStack playerHeld = player.func_184614_ca();
        if (UtilFluid.isEmptyOfFluid(playerHeld)) {
            FluidActionResult res = UtilFluid.fillContainer(this.field_145850_b, targetPos, playerHeld, this.getCurrentFacing());
            if (res != FluidActionResult.FAILURE) {
                player.func_184611_a(EnumHand.MAIN_HAND, res.getResult());
                this.tryDumpFakePlayerInvo(true);
                return true;
            }
        } else if (this.field_145850_b.func_175623_d(targetPos)) {
            ItemStack drainedStackOrNull = UtilFluid.dumpContainer(this.field_145850_b, targetPos, playerHeld);
            player.func_184611_a(EnumHand.MAIN_HAND, drainedStackOrNull);
            if (UtilFluid.isEmptyOfFluid(drainedStackOrNull)) {
                this.tryDumpFakePlayerInvo(true);
            }
            return true;
        }
        return false;
    }

    private void validateTool() {
        ItemStack maybeTool = this.func_70301_a(0);
        if (!maybeTool.func_190926_b() && maybeTool.func_190916_E() < 0) {
            maybeTool = ItemStack.field_190927_a;
            ((FakePlayer)this.fakePlayer.get()).func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
            this.inv.set(0, (Object)ItemStack.field_190927_a);
        }
    }

    private ItemStack tryEquipItem() {
        ItemStack maybeTool = this.func_70301_a(0);
        if (!maybeTool.func_190926_b() && maybeTool.func_190916_E() <= 0) {
            maybeTool = ItemStack.field_190927_a;
        }
        ((FakePlayer)this.fakePlayer.get()).func_70107_b((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p());
        ((FakePlayer)this.fakePlayer.get()).func_70071_h_();
        if (maybeTool.func_190926_b()) {
            ((FakePlayer)this.fakePlayer.get()).func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
            this.inv.set(0, (Object)ItemStack.field_190927_a);
        } else if (!maybeTool.equals(((FakePlayer)this.fakePlayer.get()).func_184586_b(EnumHand.MAIN_HAND))) {
            ((FakePlayer)this.fakePlayer.get()).func_184611_a(EnumHand.MAIN_HAND, maybeTool);
        }
        return maybeTool;
    }

    private void verifyUuid(World world) {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
            IBlockState state = world.func_180495_p(this.field_174879_c);
            world.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (this.uuid != null) {
            compound.func_74778_a("uuid", this.uuid.toString());
        }
        compound.func_74768_a("redstone", this.needsRedstone);
        compound.func_74768_a(NBT_LR, this.rightClickIfZero);
        compound.func_74768_a("size", this.size);
        compound.func_74768_a("yoff", this.yOffset);
        if (this.tickDelay != 0) {
            compound.func_74768_a("tickDelay", this.tickDelay);
        }
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("uuid")) {
            this.uuid = UUID.fromString(compound.func_74779_i("uuid"));
        }
        this.needsRedstone = compound.func_74762_e("redstone");
        this.rightClickIfZero = compound.func_74762_e(NBT_LR);
        this.size = compound.func_74762_e("size");
        this.renderParticles = compound.func_74762_e("render");
        this.yOffset = compound.func_74762_e("yoff");
        this.tickDelay = compound.func_74762_e("tickDelay");
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case SPEED: {
                return this.tickDelay;
            }
            case TIMER: {
                return this.getTimer();
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
            case SIZE: {
                return this.size;
            }
            case LEFTRIGHT: {
                return this.rightClickIfZero;
            }
            case RENDERPARTICLES: {
                return this.renderParticles;
            }
            case Y_OFFSET: {
                return this.yOffset;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case Y_OFFSET: {
                if (value > 1) {
                    value = -1;
                }
                this.yOffset = value;
                break;
            }
            case SPEED: {
                if (value > 200 || value == 0) break;
                this.tickDelay = value;
                if (this.timer <= this.tickDelay) break;
                this.timer = this.tickDelay;
                break;
            }
            case TIMER: {
                if (value < 0) {
                    value = 0;
                }
                this.timer = value;
                break;
            }
            case REDSTONE: {
                this.needsRedstone = value;
                break;
            }
            case LEFTRIGHT: {
                if (value > 1) {
                    value = 0;
                }
                this.rightClickIfZero = value;
                break;
            }
            case SIZE: {
                if (value > 9) {
                    value = 0;
                }
                if (value < 0) {
                    value = 9;
                }
                this.size = value;
                break;
            }
            case RENDERPARTICLES: {
                this.renderParticles = value % 2;
            }
        }
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        super.onDataPacket(net, pkt);
    }

    public int getTimer() {
        return this.timer;
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = this.needsRedstone == 1 ? 0 : 1;
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    @Override
    public int getSpeed() {
        return 1;
    }

    private BlockPos getTargetPos() {
        BlockPos targetPos = UtilWorld.getRandomPos(this.field_145850_b.field_73012_v, this.getTargetCenter(), this.size);
        return targetPos;
    }

    private BlockPos getTargetCenter() {
        return this.func_174877_v().func_177967_a(this.getCurrentFacing(), this.size + 1).func_177967_a(EnumFacing.UP, this.yOffset);
    }

    @Override
    public List<BlockPos> getShape() {
        return UtilShape.squareHorizontalHollow(this.getTargetCenter(), this.size);
    }

    @Override
    public boolean isPreviewVisible() {
        return this.func_174887_a_(Fields.RENDERPARTICLES.ordinal()) == 1;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        if (index <= 2 && stack.func_190916_E() > 1) {
            return false;
        }
        return super.func_94041_b(index, stack);
    }

    public static void syncConfig(Configuration config) {
        String category = "modpacks";
        String[] deflist = new String[]{};
        Object[] blacklist = config.getStringList("AutoUserTargetBlacklist", category, deflist, "Blocks in-world that cannot be targeted by the auto user.  Use block id; for example minecraft:chest");
        blacklistAll = NonNullList.func_193580_a((Object)"", (Object[])blacklist);
    }

    public static enum Fields {
        TIMER,
        SPEED,
        REDSTONE,
        LEFTRIGHT,
        SIZE,
        RENDERPARTICLES,
        Y_OFFSET;

    }
}

