/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.battery;

import com.lothrazar.cyclicmagic.block.cable.TileEntityCableBase;
import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.capability.EnergyStore;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityBattery
extends TileEntityBaseMachineInvo
implements ITickable {
    private static final double PCT_UPDATE_ON_TICK = 0.01;
    private int transferRate = 1000;
    public static final int ITEM_CHARGE_RATE = 64000;
    public int capacity = 1000000;
    private Map<EnumFacing, Boolean> poweredSides;

    public TileEntityBattery() {
        super(1);
        this.initEnergy(new EnergyStore(this.capacity), 0);
        this.setSlotsForBoth();
        this.poweredSides = new HashMap<EnumFacing, Boolean>();
        for (EnumFacing f : EnumFacing.values()) {
            this.poweredSides.put(f, false);
        }
    }

    public boolean getSideHasPower(EnumFacing side) {
        return this.poweredSides.get(side);
    }

    public int getSideField(EnumFacing side) {
        return this.getSideHasPower(side) ? 1 : 0;
    }

    public void setSideField(EnumFacing side, int pow) {
        this.poweredSides.put(side, pow == 1);
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case RATEOUT: {
                this.transferRate = value;
                break;
            }
            case D: {
                this.setSideField(EnumFacing.DOWN, value % 2);
                break;
            }
            case E: {
                this.setSideField(EnumFacing.EAST, value % 2);
                break;
            }
            case N: {
                this.setSideField(EnumFacing.NORTH, value % 2);
                break;
            }
            case S: {
                this.setSideField(EnumFacing.SOUTH, value % 2);
                break;
            }
            case U: {
                this.setSideField(EnumFacing.UP, value % 2);
                break;
            }
            case W: {
                this.setSideField(EnumFacing.WEST, value % 2);
            }
        }
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case RATEOUT: {
                return this.transferRate;
            }
            case D: {
                return this.getSideField(EnumFacing.DOWN);
            }
            case E: {
                return this.getSideField(EnumFacing.EAST);
            }
            case N: {
                return this.getSideField(EnumFacing.NORTH);
            }
            case S: {
                return this.getSideField(EnumFacing.SOUTH);
            }
            case U: {
                return this.getSideField(EnumFacing.UP);
            }
            case W: {
                return this.getSideField(EnumFacing.WEST);
            }
        }
        return -1;
    }

    public void func_73660_a() {
        if (!this.isValid()) {
            return;
        }
        if (this.field_145850_b.field_73012_v.nextDouble() < 0.01) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        }
        this.tryChargeItem();
        if (!this.field_145850_b.field_72995_K) {
            this.tryOutputItem();
        }
    }

    private void tryOutputItem() {
        for (EnumFacing f : EnumFacing.values()) {
            TileEntityCableBase cable;
            int drain;
            if (!this.poweredSides.get(f).booleanValue()) continue;
            IEnergyStorage handlerHere = (IEnergyStorage)this.getCapability(CapabilityEnergy.ENERGY, f);
            if (handlerHere.getEnergyStored() == 0) {
                return;
            }
            EnumFacing themFacingMe = f.func_176734_d();
            BlockPos posTarget = this.field_174879_c.func_177972_a(f);
            TileEntity tileTarget = this.field_145850_b.func_175625_s(posTarget);
            if (tileTarget == null || !tileTarget.hasCapability(CapabilityEnergy.ENERGY, themFacingMe)) {
                return;
            }
            IEnergyStorage handlerOutput = (IEnergyStorage)tileTarget.getCapability(CapabilityEnergy.ENERGY, themFacingMe);
            if (handlerHere == null || handlerOutput == null || !handlerHere.canExtract() || !handlerOutput.canReceive() || (drain = handlerHere.extractEnergy(this.transferRate, true)) <= 0) continue;
            int filled = handlerOutput.receiveEnergy(drain, false);
            handlerHere.extractEnergy(filled, false);
            if (filled <= 0 || !(tileTarget instanceof TileEntityCableBase) || !(cable = (TileEntityCableBase)tileTarget).isEnergyPipe()) continue;
            cable.updateIncomingEnergyFace(themFacingMe);
        }
    }

    private void tryChargeItem() {
        IEnergyStorage energyItemStack;
        ItemStack toCharge = this.func_70301_a(0);
        if (toCharge.hasCapability(CapabilityEnergy.ENERGY, null) && (energyItemStack = (IEnergyStorage)toCharge.getCapability(CapabilityEnergy.ENERGY, null)).canReceive() && this.energyStorage.canExtract()) {
            int canRecieve = energyItemStack.receiveEnergy(64000, true);
            int canExtract = this.energyStorage.extractEnergy(64000, true);
            int actual = Math.min(canRecieve, canExtract);
            int toExtract = energyItemStack.receiveEnergy(actual, false);
            this.energyStorage.extractEnergy(toExtract, false);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("power", this.transferRate);
        for (EnumFacing f : EnumFacing.values()) {
            compound.func_74757_a(f.func_176610_l(), this.poweredSides.get(f).booleanValue());
        }
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.transferRate = compound.func_74762_e("power");
        if (this.transferRate <= 0) {
            this.transferRate = 1000;
        }
        this.poweredSides = new HashMap<EnumFacing, Boolean>();
        for (EnumFacing f : EnumFacing.values()) {
            this.poweredSides.put(f, compound.func_74767_n(f.func_176610_l()));
        }
    }

    public static enum Fields {
        RATEOUT,
        N,
        E,
        S,
        W,
        U,
        D;

    }
}

