/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.enchant;

import com.lothrazar.cyclicmagic.enchant.BaseEnchant;
import com.lothrazar.cyclicmagic.guide.GuideRegistry;
import com.lothrazar.cyclicmagic.registry.EnchantRegistry;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantVenom
extends BaseEnchant {
    final int durationTicksPerLevel = 60;
    private boolean enabled;

    public EnchantVenom() {
        super("venom", Enchantment.Rarity.COMMON, EnumEnchantmentType.WEAPON, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
        GuideRegistry.register(this, new ArrayList<String>(Arrays.asList("60")));
    }

    @Override
    public void register() {
        EnchantRegistry.register(this);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean("EnchantVenom", "cyclicmagic.content", true, " Set false to delete - requires restart");
    }

    public int func_77325_b() {
        return 2;
    }

    @SubscribeEvent
    public void onAttackEntity(AttackEntityEvent event) {
        int level;
        if (!(event.getTarget() instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase target = (EntityLivingBase)event.getTarget();
        EntityPlayer attacker = event.getEntityPlayer();
        ItemStack main = attacker.func_184614_ca();
        ItemStack off = attacker.func_184592_cb();
        int mainLevel = -1;
        int offLevel = -1;
        if (main != null && EnchantmentHelper.func_82781_a((ItemStack)main).containsKey(this)) {
            mainLevel = (Integer)EnchantmentHelper.func_82781_a((ItemStack)main).get(this);
        }
        if (off != null && EnchantmentHelper.func_82781_a((ItemStack)off).containsKey(this)) {
            offLevel = (Integer)EnchantmentHelper.func_82781_a((ItemStack)off).get(this);
        }
        if ((level = Math.max(mainLevel, offLevel)) > 0) {
            UtilEntity.addOrMergePotionEffect(target, new PotionEffect(MobEffects.field_76436_u, 60 * level, level - 1));
        }
    }
}

