/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.boomerang;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.item.boomerang.EntityBoomerang;
import com.lothrazar.cyclicmagic.item.core.BaseItemChargeScepter;
import com.lothrazar.cyclicmagic.registry.EntityProjectileRegistry;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBoomerang
extends BaseItemChargeScepter
implements IHasRecipe,
IContent {
    private boolean enabled;

    public ItemBoomerang() {
        super(256);
    }

    @Override
    public void register() {
        ItemRegistry.register(this, "boomerang");
        EntityProjectileRegistry.registerModEntity(EntityBoomerang.class, this.getContentName(), 1729);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public String getContentName() {
        return "boomerang";
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean(this.getContentName(), "cyclicmagic.content", true, " Set false to delete - requires restart");
    }

    @Override
    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entity, int chargeTimer) {
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        int charge = this.func_77626_a(stack) - chargeTimer;
        float percentageCharged = ItemBow.func_185059_b((int)charge);
        if ((double)percentageCharged < 0.1) {
            return;
        }
        float amountCharged = percentageCharged * 9.7f;
        float velocityFactor = percentageCharged * 1.5f;
        float damage = MathHelper.func_76141_d((float)amountCharged) / 2;
        EntityBoomerang projectile = (EntityBoomerang)this.shootMain(world, player, velocityFactor, damage);
        UtilItemStack.damageItem(player, stack);
        projectile.setBoomerangThrown(stack.func_77946_l());
        player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
    }

    @Override
    public EntityBoomerang createBullet(World world, EntityPlayer player, float dmg) {
        EntityBoomerang e = new EntityBoomerang(world, (EntityLivingBase)player);
        e.setOwner((EntityLivingBase)player);
        return e;
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedOreRecipe(new ItemStack((Item)this), " fd", "dgf", " fd", Character.valueOf('d'), Items.field_151114_aO, Character.valueOf('g'), "ingotGold", Character.valueOf('f'), new ItemStack(Blocks.field_180405_aT));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(UtilChat.lang(this.getTooltip()));
        super.func_77624_a(stack, player, tooltip, advanced);
    }

    @Override
    public SoundEvent getSound() {
        return SoundRegistry.step_height_up;
    }
}

