/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.shears;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.entity.EntityThrowableDispensable;
import com.lothrazar.cyclicmagic.entity.RenderBall;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilSound;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class EntityShearingBolt
extends EntityThrowableDispensable {
    private static final int FORTUNE = 3;

    public EntityShearingBolt(World worldIn) {
        super(worldIn);
    }

    public EntityShearingBolt(World worldIn, EntityLivingBase ent) {
        super(worldIn, ent);
    }

    public EntityShearingBolt(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    @Override
    protected void processImpact(RayTraceResult mop) {
        IShearable target;
        World world = this.func_130014_f_();
        if (mop.field_72308_g != null && mop.field_72308_g instanceof IShearable) {
            try {
                IShearable target2 = (IShearable)mop.field_72308_g;
                BlockPos ePos = mop.field_72308_g.func_180425_c();
                if (target2.isShearable(null, (IBlockAccess)world, ePos)) {
                    List drops = target2.onSheared(null, (IBlockAccess)world, ePos, 3);
                    UtilItemStack.dropItemStacksInWorld(world, ePos, drops);
                    UtilSound.playSound(world, ePos, SoundEvents.field_187763_eJ, SoundCategory.NEUTRAL);
                    this.func_70106_y();
                }
            }
            catch (Exception e) {
                ModCyclic.logger.error("Error shearing entity from projectile ", e);
            }
        }
        if (this.field_70128_L || mop.func_178782_a() == null) {
            return;
        }
        BlockPos pos = mop.func_178782_a();
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block instanceof IShearable && (target = (IShearable)block).isShearable(null, (IBlockAccess)world, pos)) {
            List drops = target.onSheared(null, (IBlockAccess)world, pos, 3);
            for (ItemStack stack : drops) {
                float f = 0.7f;
                double d = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + d, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, stack);
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)entityitem);
                    world.func_175698_g(pos);
                }
                UtilSound.playSound(world, pos, SoundEvents.field_187763_eJ, SoundCategory.BLOCKS);
            }
            this.func_70106_y();
        }
    }

    public static class FactoryShear
    implements IRenderFactory<EntityShearingBolt> {
        public Render<? super EntityShearingBolt> createRenderFor(RenderManager rm) {
            return new RenderBall(rm, "shears");
        }
    }
}

