/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.net;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.util.UtilChat;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketEntityDropRandom
implements IMessage,
IMessageHandler<PacketEntityDropRandom, IMessage> {
    private int entityId;
    private int slot;

    public PacketEntityDropRandom() {
    }

    public PacketEntityDropRandom(int entityid, int level) {
        this.entityId = entityid;
        this.slot = level;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tags = ByteBufUtils.readTag((ByteBuf)buf);
        this.entityId = tags.func_74762_e("entityId");
        this.slot = tags.func_74762_e("level");
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74768_a("entityId", this.entityId);
        tags.func_74768_a("level", this.slot);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tags);
    }

    public IMessage onMessage(final PacketEntityDropRandom message, final MessageContext ctx) {
        if (ctx.side.isServer()) {
            MinecraftServer s = FMLCommonHandler.instance().getMinecraftServerInstance();
            s.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    PacketEntityDropRandom.this.handle(message, ctx);
                }
            });
        }
        return null;
    }

    private void handle(PacketEntityDropRandom message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        World world = player.func_130014_f_();
        Entity entityTarget = world.func_73045_a(message.entityId);
        if (entityTarget != null && entityTarget instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)entityTarget;
            EntityEquipmentSlot slot = EntityEquipmentSlot.values()[message.slot];
            ItemStack stackCurrent = player.func_184582_a(slot);
            if (stackCurrent.func_190926_b()) {
                return;
            }
            BlockPos pos = entity.func_180425_c();
            EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stackCurrent);
            world.func_72838_d((Entity)entityItem);
            entity.func_184201_a(slot, ItemStack.field_190927_a);
            if (entity instanceof EntityPlayer) {
                UtilChat.sendStatusMessage((EntityPlayer)entity, "potion.butter.oops");
            }
        } else {
            ModCyclic.logger.error("NOT FOUND packet entityid" + message.entityId);
        }
    }
}

