/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe;

import com.google.gson.JsonObject;
import java.util.function.BooleanSupplier;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.config.MekanismConfig;
import mekanism.generators.common.block.states.BlockStateGenerator;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.common.crafting.IConditionFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.common.Loader;

public class MekanismRecipeEnabledCondition
implements IConditionFactory {
    public BooleanSupplier parse(JsonContext context, JsonObject json) {
        if (JsonUtils.func_151204_g((JsonObject)json, (String)"machineType")) {
            String machineType = JsonUtils.func_151200_h((JsonObject)json, (String)"machineType");
            BlockStateMachine.MachineType type = MekanismConfig.current().general.machinesManager.typeFromName(machineType);
            return () -> MekanismConfig.current().general.machinesManager.isEnabled(type);
        }
        if (Loader.isModLoaded((String)"mekanismgenerators") && JsonUtils.func_151204_g((JsonObject)json, (String)"generatorType")) {
            String generatorType = JsonUtils.func_151200_h((JsonObject)json, (String)"generatorType");
            final BlockStateGenerator.GeneratorType type = MekanismConfig.current().generators.generatorsManager.typeFromName(generatorType);
            return new BooleanSupplier(){

                @Override
                public boolean getAsBoolean() {
                    return MekanismConfig.current().generators.generatorsManager.isEnabled(type);
                }
            };
        }
        if (JsonUtils.func_151204_g((JsonObject)json, (String)"circuitOredict")) {
            return () -> MekanismConfig.current().general.controlCircuitOreDict.val();
        }
        throw new IllegalStateException("Config defined with recipe_enabled condition without a valid field defined! Valid values: \"machineType\", \"generatorType\" (when Mekanism Generators installed) and \"circuitOredict\"");
    }
}

