/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.transmitter;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.TileNetworkList;
import mekanism.common.Mekanism;
import mekanism.common.block.states.BlockStateTransmitter;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporter;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class TileEntityDiversionTransporter
extends TileEntityLogisticalTransporter {
    public int[] modes = new int[]{0, 0, 0, 0, 0, 0};

    @Override
    public BlockStateTransmitter.TransmitterType getTransmitterType() {
        return BlockStateTransmitter.TransmitterType.DIVERSION_TRANSPORTER;
    }

    @Override
    public boolean renderCenter() {
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        if (nbtTags.func_74764_b("modes")) {
            this.modes = nbtTags.func_74759_k("modes");
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74783_a("modes", this.modes);
        return nbtTags;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) throws Exception {
        super.handlePacketData(dataStream);
        if (this.func_145831_w().field_72995_K) {
            this.modes[0] = dataStream.readInt();
            this.modes[1] = dataStream.readInt();
            this.modes[2] = dataStream.readInt();
            this.modes[3] = dataStream.readInt();
            this.modes[4] = dataStream.readInt();
            this.modes[5] = dataStream.readInt();
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        data = super.getNetworkedData(data);
        return this.addModes(data);
    }

    @Override
    public TileNetworkList makeSyncPacket(int stackId, TransporterStack stack) {
        return this.addModes(super.makeSyncPacket(stackId, stack));
    }

    @Override
    public TileNetworkList makeBatchPacket(Map<Integer, TransporterStack> updates, Set<Integer> deletes) {
        return this.addModes(super.makeBatchPacket(updates, deletes));
    }

    private TileNetworkList addModes(TileNetworkList data) {
        data.add(this.modes[0]);
        data.add(this.modes[1]);
        data.add(this.modes[2]);
        data.add(this.modes[3]);
        data.add(this.modes[4]);
        data.add(this.modes[5]);
        return data;
    }

    @Override
    protected EnumActionResult onConfigure(EntityPlayer player, int part, EnumFacing side) {
        int newMode = (this.modes[side.ordinal()] + 1) % 3;
        String description = "ERROR";
        this.modes[side.ordinal()] = newMode;
        switch (newMode) {
            case 0: {
                description = LangUtils.localize("control.disabled.desc");
                break;
            }
            case 1: {
                description = LangUtils.localize("control.high.desc");
                break;
            }
            case 2: {
                description = LangUtils.localize("control.low.desc");
            }
        }
        this.refreshConnections();
        this.notifyTileChange();
        player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + (Object)((Object)EnumColor.GREY) + " " + LangUtils.localize("tooltip.configurator.toggleDiverter") + ": " + (Object)((Object)EnumColor.RED) + description));
        Mekanism.packetHandler.sendUpdatePacket(this);
        return EnumActionResult.SUCCESS;
    }

    @Override
    public boolean canConnect(EnumFacing side) {
        if (!super.canConnect(side)) {
            return false;
        }
        int mode = this.modes[side.ordinal()];
        boolean redstone = MekanismUtils.isGettingPowered(this.func_145831_w(), new Coord4D(this.func_174877_v(), this.func_145831_w()));
        return !(mode == 2 && redstone || mode == 1 && !redstone);
    }

    @Override
    public EnumColor getRenderColor() {
        return null;
    }
}

