/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.multimob.capabilities;

import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;

public class CapabilityProviderSerializable<H>
implements ICapabilityProvider,
INBTSerializable<NBTBase> {
    protected final Capability<H> capability;
    protected final EnumFacing facing;
    protected final H instance;

    public CapabilityProviderSerializable(Capability<H> capability, @Nullable EnumFacing facing, @Nullable H instance) {
        this.capability = capability;
        this.facing = facing;
        this.instance = instance;
    }

    public CapabilityProviderSerializable(Capability<H> capability, @Nullable EnumFacing facing) {
        this(capability, facing, capability.getDefaultInstance());
    }

    public CapabilityProviderSerializable(Capability<H> capability) {
        this(capability, null, capability.getDefaultInstance());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == this.getCapability();
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == this.getCapability()) {
            return (T)this.getCapability().cast(this.getInstance());
        }
        return null;
    }

    public NBTBase serializeNBT() {
        return this.getCapability().writeNBT(this.getInstance(), this.getFacing());
    }

    public void deserializeNBT(NBTBase nbt) {
        this.getCapability().readNBT(this.getInstance(), this.getFacing(), nbt);
    }

    @Nullable
    public EnumFacing getFacing() {
        return this.facing;
    }

    public final Capability<H> getCapability() {
        return this.capability;
    }

    @Nullable
    public final H getInstance() {
        return this.instance;
    }
}

