/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.multimob.core;

import java.io.File;
import java.io.IOException;
import java.util.function.BiPredicate;
import net.daveyx0.multimob.common.MMCommonProxy;
import net.daveyx0.multimob.config.MMConfig;
import net.daveyx0.multimob.core.MMCapabilities;
import net.daveyx0.multimob.core.MMEntityRegistry;
import net.daveyx0.multimob.core.MMEvents;
import net.daveyx0.multimob.core.MMTameableEntries;
import net.daveyx0.multimob.core.MMVariantEntries;
import net.daveyx0.multimob.entity.IMultiMob;
import net.daveyx0.multimob.entity.IMultiMobLava;
import net.daveyx0.multimob.entity.IMultiMobPassive;
import net.daveyx0.multimob.entity.IMultiMobWater;
import net.daveyx0.multimob.message.MMMessageRegistry;
import net.daveyx0.multimob.spawn.MMSpawnRegistry;
import net.daveyx0.multimob.spawn.MMSpawnerEventHandler;
import net.daveyx0.multimob.util.FileUtil;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="multimob", name="Multi Mob Library", version="1.0.5", acceptedMinecraftVersions="[1.12]", guiFactory="net.daveyx0.multimob.config.MMFactoryGui")
public class MultiMob {
    public static final Logger LOGGER = LogManager.getLogger((String)"multimob");
    @Mod.Instance(value="multimob")
    public static MultiMob instance = new MultiMob();
    @SidedProxy(clientSide="net.daveyx0.multimob.client.MMClientProxy", serverSide="net.daveyx0.multimob.common.MMCommonProxy")
    public static MMCommonProxy proxy;
    private File directory;
    public static final EntityLiving.SpawnPlacementType IN_LAVA;
    public static final EnumCreatureType MULTIMOB_MONSTER;
    public static final EnumCreatureType MULTIMOB_PASSIVE;
    public static final EnumCreatureType MULTIMOB_WATER;
    public static final EnumCreatureType MULTIMOB_LAVA;

    @Mod.EventHandler
    public void PreInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new MultiMob());
        MinecraftForge.EVENT_BUS.register((Object)new MMEvents.EntityEventHandler());
        MMMessageRegistry.preInit();
        MMCapabilities.preInit();
        MinecraftForge.EVENT_BUS.register((Object)new MMSpawnerEventHandler());
        this.directory = new File(event.getModConfigurationDirectory(), "multimob");
        if (!this.directory.exists()) {
            this.directory.mkdirs();
        }
        MMConfig.preInit(this.directory, event);
        MMEntityRegistry.addDummy();
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void Init(FMLInitializationEvent event) {
        MMTameableEntries.registerTameables();
        MMVariantEntries.registerVariants();
        MMSpawnRegistry.registerFillerSpawns();
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        File subDirectory = new File(this.directory, "modInformation");
        if (!subDirectory.exists()) {
            subDirectory.mkdirs();
        }
        try {
            FileUtil.createTextFilesForModInfo(subDirectory);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        MMConfig.postInit();
        proxy.postInit(event);
    }

    public File getDirectory() {
        return this.directory;
    }

    static {
        IN_LAVA = EnumHelper.addSpawnPlacementType((String)"IN_LAVA", (BiPredicate)new BiPredicate<IBlockAccess, BlockPos>(){

            @Override
            public boolean test(IBlockAccess t, BlockPos u) {
                IBlockState iblockstate = t.func_180495_p(u);
                return iblockstate.func_185904_a() == Material.field_151587_i && t.func_180495_p(u.func_177977_b()).func_185904_a() == Material.field_151587_i && !t.func_180495_p(u.func_177984_a()).func_185915_l();
            }
        });
        MULTIMOB_MONSTER = EnumHelper.addCreatureType((String)"MULTIMOB_MONSTER", IMultiMob.class, (int)35, (Material)Material.field_151579_a, (boolean)false, (boolean)false);
        MULTIMOB_PASSIVE = EnumHelper.addCreatureType((String)"MULTIMOB_PASSIVE", IMultiMobPassive.class, (int)10, (Material)Material.field_151579_a, (boolean)false, (boolean)false);
        MULTIMOB_WATER = EnumHelper.addCreatureType((String)"MULTIMOB_WATER", IMultiMobWater.class, (int)10, (Material)Material.field_151586_h, (boolean)false, (boolean)false);
        MULTIMOB_LAVA = EnumHelper.addCreatureType((String)"MULTIMOB_LAVA", IMultiMobLava.class, (int)5, (Material)Material.field_151587_i, (boolean)false, (boolean)false);
    }
}

