/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.multimob.message;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.daveyx0.multimob.common.capabilities.CapabilityTameableEntity;
import net.daveyx0.multimob.common.capabilities.ITameableEntity;
import net.daveyx0.multimob.core.MultiMob;
import net.daveyx0.multimob.util.EntityUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageMMTameable
implements IMessage {
    private String entityId;
    private String ownerId;
    private int followState;

    public MessageMMTameable() {
    }

    public MessageMMTameable(String entityInID, String summonerInID, int followState) {
        this.entityId = entityInID;
        this.ownerId = summonerInID;
        this.followState = followState;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.ownerId = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.followState = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.entityId);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.ownerId);
        buf.writeInt(this.followState);
    }

    public static class Handler
    implements IMessageHandler<MessageMMTameable, IMessage> {
        public IMessage onMessage(MessageMMTameable message, MessageContext ctx) {
            MultiMob.proxy.getThreadListener(ctx).func_152344_a(() -> {
                EntityLivingBase entity;
                if (!message.entityId.isEmpty() && !message.ownerId.isEmpty() && (entity = EntityUtil.getLoadedEntityByUUID(UUID.fromString(message.entityId), MultiMob.proxy.getClientWorld())) != null && entity.hasCapability(CapabilityTameableEntity.TAMEABLE_ENTITY_CAPABILITY, null)) {
                    ITameableEntity tameable = EntityUtil.getCapability((Entity)entity, CapabilityTameableEntity.TAMEABLE_ENTITY_CAPABILITY, null);
                    tameable.setTamed(true);
                    tameable.setOwner(UUID.fromString(message.ownerId));
                    tameable.setFollowState(message.followState);
                    NBTTagCompound nbttagcompound = entity.func_189511_e(new NBTTagCompound());
                    nbttagcompound.func_74778_a("Owner", message.ownerId);
                    nbttagcompound.func_74778_a("OwnerUUID", message.ownerId);
                    nbttagcompound.func_74757_a("Tame", true);
                    nbttagcompound.func_74757_a("Tamed", true);
                    entity.func_70020_e(nbttagcompound);
                }
            });
            return null;
        }
    }
}

